# Example 11_angr_sim_scanf

This time, the solution involves simply replacing scanf with our own version,
since Angr does not support requesting multiple parameters with scanf.

## Context

## Script

1. Load the file and initialize memory with zero
```
load '11_angr_sim_scanf'
unconstrained_fill True
```
2. Since scanf is not supported with multiple parameters we hook the function with our own implementation. 

We first have to create two symbolic variables for the user inputs scanf stores in the buffers on the provided addresses. 
To get the results we have to add the symbolic values of our scanf symbolic variables to the globals of the state. 

```

def scanf(format_string, address0, address1):
    add_symbol scanf0 4
    add_symbol scanf1 4
    set_memory address0 &sym.scanf0 endness=MEMORY
    set_memory address1 &sym.scanf1 endness=MEMORY
    add_to_state solution0 &sym.scanf0
    add_to_state solution1 &sym.scanf1

hook_function  "scanf" "__isoc99_scanf" 

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results

We check the values of the solution for the state where the breakpoint ended on the "Good Job" stream.
```
sol0 = get_from_state solution0
sol1 = get_from_state solution1
s0 = to_int (evaluate sol0)
s1 = to_int (evaluate sol1)
!("{} {}".format(&vars.s0,&vars.s1))
```