# Example 10_angr_simprocedures
## Context

## Script

1. Load the file and initialize memory with zero
```
load '10_angr_simprocedures'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```

def check_equals(address, length):
    m = get_memory address length
    &reg.eax = IIF m==b'OSIWHBXIFOQVSBZB' THEN 1 ELSE 0

hook_function "check_equals" "check_equals_OSIWHBXIFOQVSBZB" 

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
```
dump_stdstream stdin
```