# Example 09_angr_hooks
## Context

## Script

1. Load the file and initialize memory with zero
```
load '09_angr_hooks'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```

def skip_check_equals():
    &reg.eax = IIF &mem[0x804a044->16]==b'OSIWHBXIFOQVSBZB' THEN 1 ELSE 0

hook_region skip_check_equals 0x80486ca 5

```
3. Add an address filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
```
dump_stdstream stdin
```