# Example 08_angr_constraints

## Context

In this example the password (user input) needs to be equal to the value stored at 0x804a030 ("OSIWHBXIFOQVSBZB"). To make this a challenge a complex function is added that mutates the input of the user. If the input value is the same as the desired value after the complex function, a Good Job is printed.

The program initialises the desired value before it reads the user input.

## Script

1. Load the file and initialize memory with zero
```
load '08_angr_constraints'
unconstrained_fill
```
2. Create symbolic variable

Since *scanf* is not supported, we start the execution after the scanf call. We create a symbolic variable for password and set the memory address. 

```
add_symbol password 16

set_entry_state 0x804863c

set_memory 0x804a040 &sym.password

```
3. Set breakpoint

Simply searching for the sequence "Good Job" will not work in this instance. Because the desired value is initialised before the user input. We can solve this challenge by setting the symbolic memory (see example 07) or we can use a constraint. We can place the constraint before the equals check and see if the password equals the desired value after the mutation.

```
breakpoint (by_address 0x8048683)
run
add_constraint &mem[0x804a040->16] == b'OSIWHBXIFOQVSBZB'
```

The constraint has to be set after the run, when the constrain is set before the run it will constrain the user input before the mutation. 

4. Obtain the results

```
to_str (evaluate &sym.password bytes)
```
