# Example 07_angr_symbolic_file
## Context

## Script

1. Load the file and initialize memory with zero
```
load '07_angr_symbolic_file'
unconstrained_fill
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```
set_entry_state 0x80488bc

add_symbol password 8

create_symbolic_file "FOQVSBZB.txt" &sym.password

```
3. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
```
to_str (evaluate &sym.password)
```