# Example 06_angr_symbolic_dynamic_memory
## Context

## Script

1. Load the file and initialize memory with zero
```
load '06_angr_symbolic_dynamic_memory'
unconstrained_fill

set_entry_state 0x80486af

```
2. The binary is calling scanf("%8s %8s").
```
add_symbol password0 8
add_symbol password1 8
```
Instead of telling the binary to write to the address of the memory allocated with malloc, we can simply fake an address to any unused block of memory and overwrite the pointer to the data. This will point the pointer with the address of pointer_to_malloc_memory_address0 to fake_heap_address. Be aware, there is more than one pointer! Analyze the binary to determine global location of each pointer.

Note: by default, Angr stores integers in memory with big-endianness. To specify to use the endianness of your architecture, use the parameter endness. On x86, this is little-endian. size=number of bytes being stored (e.g. 32-bit address = 4 bytes)
```
set_memory 0xa2def74 0x4444444 endness=MEMORY
set_memory 0xa2def7c 0x4444454 endness=MEMORY
```
Store our symbolic values at our fake_heap_address. Look at the binary to determine the offsets from the fake_heap_address where scanf writes.
```
&mem[0x4444444] = &sym.password0
&mem[0x4444454] = &sym.password1
```
3. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```
4. Obtain the results
```
p0 = to_str (evaluate &sym.password0)
p1 = to_str (evaluate &sym.password1)
!("{} {}".format(&vars.p0,&vars.p1))
```