# Example 05_angr_symbolic_memory
## Context

## Script

1. Load the file and initialize memory with zero
```
load '05_angr_symbolic_memory'
unconstrained_fill
```
2. The binary is calling scanf("%8s %8s %8s %8s"). 

To understand where to set our entry state and the set_memory addresses, we need to look at the disassembly. 

    0x80485f1: add esp, 0x10
    0x80485f4: sub esp, 0xc
    0x80485f7: push 0xab232d8
    0x80485fc: push 0xab232d0
    0x8048601: push 0xab232c8
    0x8048606: push 0xab232c0
    0x804860b: push 0x8048743
    0x8048610: call 0x8048400
    0x8048615: add esp, 0x20
    0x8048618: mov dword ptr [ebp - 0xc], 0
    0x804861f: jmp 0x804864e

```
add_symbol password0 8
add_symbol password1 8
add_symbol password2 8
add_symbol password3 8

set_entry_state 0x8048618
```
Determine the address of the global variable to which scanf writes the user input. The function 'initial_state.memory.store(address, value)' will write 'value' (a bitvector) to 'address' (a memory location, as an integer.) The 'address' parameter can also be a bitvector (and can be symbolic!).
```
set_memory 0xab232c0 &sym.password0
set_memory 0xab232c8 &sym.password1
set_memory 0xab232d0 &sym.password2
set_memory 0xab232d8 &sym.password3
```
3. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
Solve for the symbolic values. We are trying to solve for a string. Therefore, we will use evaluate, with named parameter cast_to bytes which returns bytes that can be decoded to a string instead of an integer.
```
p0 = to_str (evaluate &sym.password0 bytes)
p1 = to_str (evaluate &sym.password1 bytes)
p2 = to_str (evaluate &sym.password2 bytes)
p3 = to_str (evaluate &sym.password3 bytes)
!("{} {} {} {}".format(&vars.p0,&vars.p1,&vars.p2,&vars.p3))
```