# Example 04_angr_symbolic_stack
## Context
This challenge will be more challenging than the previous challenges that you have encountered thus far. Since the goal of this CTF is to teach symbolic execution and not how to construct stack frames, these comments will work you through understanding what is on the stack.

## Script

1. Load the file and initialize memory with zero
```
load '04_angr_symbolic_stack'
unconstrained_fill True
```
2. Setup State

For this challenge, we want to begin after the call to scanf. Note that this is in the middle of a function.
  
This challenge requires dealing with the stack, so you have to pay extra careful attention to where you start, otherwise you will enter a condition where the stack is set up incorrectly. In order to determine where after scanf to start, we need to look at the dissassembly of the call and the instruction immediately following it:
	
    0x8048690:    push    ebp
	0x8048691:    mov    ebp, esp
	0x8048693:    sub    esp, 0x18
	0x8048696:    sub    esp, 4
	0x8048699:    lea    eax, [ebp - 0x10]
	0x804869c:    push   eax
	0x804869d:    lea    eax, [ebp - 0xc]
	0x80486a0:    push   eax
	0x80486a1:    push   0x80487c3
	0x80486a6:    call   0x8048370
	0x80486ab:    add    esp, 0x10
	0x80486ae:    mov    eax, dword ptr [ebp - 0xc]
	0x80486b1:    sub    esp, 0xc
	0x80486b4:    push   eax
	0x80486b5:    call   0x80484c0
    
Now, the question is: do we start on the instruction immediately following scanf (add $0x10,%esp), or the instruction following that (not shown)?
Consider what the 'add $0x10,%esp' is doing. Hint: it has to do with the scanf parameters that are pushed to the stack before calling the function. Given that we are not calling scanf in our Angr simulation, where should we start?
```
set_entry_state 0x80486ae
```
We are jumping into the middle of a function! Therefore, we need to account for how the function constructs the stack. The second instruction of the function is:

    mov    ebp, esp

At which point it allocates the part of the stack frame we plan to target:

    sub    esp, 0x18
Note the value of esp relative to ebp. The space between them is (usually) the stack space. Since esp was decreased by 0x18
  
           /-------- The stack --------\
    ebp -> |                           |
           |---------------------------|
           |                           |
           |---------------------------|
            . . . (total of 0x18 bytes)
            . . . Somewhere in here is
            . . . the data that stores
            . . . the result of scanf.
    esp -> |                           |
           \---------------------------/
  
  Since we are starting after scanf, we are skipping this stack construction
  step. To make up for this, we need to construct the stack ourselves. Let us
  start by initializing ebp in the exact same way the program does.
```
&reg.ebp = &reg.esp
&reg.esp = &reg.esp - 8
```
3. Scanf Arguments

scanf("%u %u") needs to be replaced by injecting two bitvectors. The reason for this is that Angr does not (currently) automatically inject symbols if scanf has more than one input parameter. This means Angr can handle 'scanf("%u")', but not 'scanf("%u %u")'.
```
add_symbol 'password0' 4
add_symbol 'password1' 4
```
4. Stack Setup

Here is the hard part. We need to figure out what the stack looks like, at least well enough to inject our symbols where we want them. In order to do that, let's figure out what the parameters of scanf are:

    0x8048696:    sub    esp, 4
	0x8048699:    lea    eax, [ebp - 0x10]
	0x804869c:    push   eax
	0x804869d:    lea    eax, [ebp - 0xc]
	0x80486a0:    push   eax
	0x80486a1:    push   0x80487c3
	0x80486a6:    call   0x8048370 <__isoc99_scanf@plt>
	0x80486ab:    add    esp, 0x10
As you can see, the call to scanf looks like this:
    
    scanf(  0x80489c3,   ebp - 0xc,   ebp - 0x10  )
          format_string    password0    password1
From this, we can construct our new, more accurate stack diagram:
  
               /-------- The stack --------\
    ebp ->     |          padding          |
               |---------------------------|
    ebp - 0x01 |       more padding        |
               |---------------------------|
    ebp - 0x02 |     even more padding     |
               |---------------------------|
                           . . .               <- How much padding? Hint: how
               |---------------------------|      many bytes is password0?
    ebp - 0x0b |   password0, second byte  |
               |---------------------------|
    ebp - 0x0c |   password0, first byte   |
               |---------------------------|
    ebp - 0x0d |   password1, last byte    |
               |---------------------------|
                           . . .
               |---------------------------|
    ebp - 0x10 |   password1, first byte   |
               |---------------------------|
                           . . .
               |---------------------------|
    esp ->     |                           |
               \---------------------------/
  
Figure out how much space there is and allocate the necessary padding to the stack by decrementing esp before you push the password bitvectors.
```
&reg.ebp = &reg.esp
&reg.esp = &reg.esp - 8
```
5. Prepare Stack

Push the variables to the stack. Make sure to push them in the right order!
The syntax for the following function is:
  
  initial_state.stack_push(bitvector)
  
This will push the bitvector on the stack, and increment esp the correct amount. You will need to push multiple bitvectors on the stack.

```
add_to_stack &sym.password0
add_to_stack &sym.password1

```
6. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
```
a0 = to_int (evaluate &sym.password0)
a1 = to_int (evaluate &sym.password1)

!("{} {}".format(&vars.a0, &vars.a1))
```