# Example 03_angr_symbolic_registers
## Context
Explore the binary, but this time, instead of only looking for a # Angr doesn't currently support reading multiple things with scanf (Ex: scanf("%u %u",...).) You will have to tell the simulation engine to begin the program after scanf is called and manually inject the symbols into registers.

## Script

1. Load the file and initialize memory with zero
```
load '03_angr_symbolic_registers'
unconstrained_fill True
```
2. Since scanf is not supported, we start the execution after the scanf call, create 3 symex symbols and assign the symbols to the registers containing the scanf result.
```
set_entry_state 0x80488c7

add_symbol 'password0' 4
add_symbol 'password1' 4
add_symbol 'password2' 4

assign &reg.eax &sym.password0
assign &reg.ebx &sym.password1
assign &reg.edx &sym.password2
```
3. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'
```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

4. Obtain the results
```
a0 = to_int (evaluate &sym.password0)
a1 = to_int (evaluate &sym.password1)
a2 = to_int (evaluate &sym.password2)
!("{:08x} {:08x} {:08x}".format(&vars.a0, &vars.a1, &vars.a2))
```