# Example 02_angr_find_condition
## Context
It is very useful to be able to search for a state that reaches a certain instruction. However, in some cases, you may not know the address of the specific instruction you want to reach (or perhaps there is no single instruction goal.) In this challenge, you don't know which instruction grants you success. Instead, you just know that you want to find a state where the binary prints "Good Job."

Angr is powerful in that it allows you to search for a states that meets an arbitrary condition that you specify in Python, using a predicate you define as a function that takes a state and returns True if you have found what you are looking for, and False otherwise.


## Script
1. Load the file:

`load '02_angr_find_condition'`

2. Add an output filter to break on 'Good Job' and exclude states that output 'Try again'

This time we add a breakpoint by stream instead of by address. 

```
breakpoint (by_stream "Good Job")
exclude (by_stream "Try again")
run
```

3. Retrieve the result
`dump_stdstream stdin`