# Example 01_angr_void

## Context
In this example the binary can get into state where it will not reach the succeed address. We will have to search the basic block that makes a state unsolvable and set dAngr to avoid it.

## Script

### 1. Load the file:

`load '01_angr_avoid'`

### 2. Search for the string 'Good Job' in the binaries string symbols and notice its address *at 0x80d463e*

Once again we can search for the 'Good Job' string. This time it is at address 0x80d463e.

`list_binary_strings`

Lets also list the functions in the binary. 

```
list_binary_symbols
less
```
Here we see a function avoid me, and a function maybe_good. Lets take a look at those functions.

```
decompiled_function avoid_me
decompiled_function maybe_good
````

In the avoid_me function the variable should_succeed gets set to 0. Once that variable is zero the program will not print 'Good Job' **even** if the value is correct. 


### 3. Search for the 'avoid_me' function address.

```
get_basicblocks
less
```

### 4. Add an address filter to break on the code using the string 'Good Job', and an address filter to exclude the 'avoid_me' function, and execute the binary

```
breakpoint (by_address 0x80485f7)
exclude (by_address 0x80485bf)
run
```

5. Finally, Retrieve the result

`dump_stdstream stdin`

