# Example 00_angr_find
## Context
This binary reads a password as command argument. A *complex function* is called to change the input. If the altered input matches the desired value a 'Good Job' is printed.

## Script

### 1. Load the file:
First we are going to load the binary, you can do this with the command *load* and adding the file name as argumets. 
**NOTE the file name needs to be between quotes.**

`load '00_angr_find'`

### 2. Search 'Good Job'

We can request certain usefull information about the binary. In this case we would like to know what strings are in the binary. 
That gives us the addresses and the corresponding string. 

`list_binary_strings`

The string "Good Job" has address 0x400a68. From the context we know that a correct solution will print the string "Good Job".

### 3. Search for the breakpoint 

First lets take a look at how the decompiled program looks. That can give us an idea of what is going on. 

`decompiled_function main`

We see that the input is stored in &v3. After a the mutation the input is validated. When the input is correct the string "Good Job" is printed.

Angr splits functions into basic blocks. Those are code sequences with only one exit branch. We can search for the basic block where the program prints "Good Job".
**Use less to view large dAngr outputs**

```
get_basicblocks
less
```

By searching for "a68" we find that the basic block with starting address "0x4009c0" is the winning branch.


### 4. Add a breakpoint at the address of the basic block printing 'Good Job'

By setting a breakpoint on that address we will stop in the state where we have the correct input. 


```
add_breakpoint 0x4009c0
run
```
### 5. Finally, Retrieve the result

`dump_stdstream stdin`