# Script de Processamento de dados de processos judiciais trabalhistas 
Este repositório contém scripts de ETL desenvolvidos para a extração, transformação e carregamento de dados de processos jurídicos. 
Os scripts são otimizados para processar arquivos JSON contendo informações sobre processos, relacionamentos, distribuições, partes, assuntos e movimentos processuais, e são configuráveis para rodar com diferentes tribunais e graus de jurisdição.

---
## Sumario
<!-- TOC -->
* [Script de Processamento de dados de processos judiciais trabalhistas](#script-de-processamento-de-dados-de-processos-judiciais-trabalhistas-)
  * [Descrição](#descrição)
  * [Estrutura do Projeto](#estrutura-do-projeto)
  * [Funcionalidades Principais](#funcionalidades-principais)
  * [Estrutura de Diretórios](#estrutura-de-diretórios)
  * [Estrutura de Diretórios](#estrutura-de-diretórios-1)
  * [Script de comandos para rodar o projeto](#script-de-comandos-para-rodar-o-projeto)
  * [Como Usar](#como-usar)
    * [1. Configuração de Ambiente](#1-configuração-de-ambiente)
    * [2. Executando o Script](#2-executando-o-script)
    * [3. Argumentos Principais](#3-argumentos-principais)
    * [4. Exemplo de Uso](#4-exemplo-de-uso)
  * [Funções Principais](#funções-principais)
    * [`setup_logger(name, log_file, level=logging.INFO)`](#setup_loggername-log_file-levellogginginfo)
    * [`running(e, item, trt, log_folder, g, n_job=None)`](#runninge-item-trt-log_folder-g-n_jobnone)
    * [`go(n, grau, n_job=None)`](#gon-grau-n_jobnone)
      * [dentro da função go](#dentro-da-função-go)
  * [Estrutura do Código](#estrutura-do-código)
  * [Estrutura dos Extratores](#estrutura-dos-extratores)
  * [Scripts Extratores](#scripts-extratores)
  * [Scripts Tratadores](#scripts-tratadores)
* [Documentação do Script ETL para parte](#documentação-do-script-etl-para-parte)
  * [Descrição](#descrição-1)
  * [Funcionalidades](#funcionalidades)
  * [Dependências](#dependências)
  * [Estrutura do Projeto](#estrutura-do-projeto-1)
  * [Estrutura do Código](#estrutura-do-código-1)
    * [1. Função `extrai_dados`](#1-função-extrai_dados)
    * [2. Função `salva`](#2-função-salva)
    * [3. Função `run`](#3-função-run)
  * [Como Funciona](#como-funciona)
    * [Exemplo de Execução](#exemplo-de-execução)
      * [Parâmetros:](#parâmetros)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-2)
    * [Log e Erros](#log-e-erros)
* [Documentação do Script ETL para Processo](#documentação-do-script-etl-para-processo)
  * [Descrição](#descrição-2)
  * [Funcionalidades](#funcionalidades-1)
  * [Dependências](#dependências-1)
  * [Estrutura do Projeto](#estrutura-do-projeto-2)
  * [Estrutura do Código](#estrutura-do-código-2)
    * [1. Função `extrai_dados`](#1-função-extrai_dados-1)
    * [2. Função `salva`](#2-função-salva-1)
    * [3. Função `run`](#3-função-run-1)
  * [Como Funciona](#como-funciona-1)
    * [Exemplo de Execução](#exemplo-de-execução-1)
      * [Parâmetros:](#parâmetros-1)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-3)
    * [Log e Erros](#log-e-erros-1)
* [Documentação do Script ETL para Distribuições](#documentação-do-script-etl-para-distribuições)
  * [Descrição](#descrição-3)
  * [Funcionalidades](#funcionalidades-2)
  * [Dependências](#dependências-2)
  * [Estrutura do Projeto](#estrutura-do-projeto-3)
  * [Estrutura do Código](#estrutura-do-código-3)
    * [1. Função `extrai_dados`](#1-função-extrai_dados-2)
    * [2. Função `salva`](#2-função-salva-2)
    * [3. Função `run`](#3-função-run-2)
  * [Como Funciona](#como-funciona-2)
    * [Exemplo de Execução](#exemplo-de-execução-2)
      * [Parâmetros:](#parâmetros-2)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-4)
    * [Log e Erros](#log-e-erros-2)
* [Documentação do Script ETL para Assuntos](#documentação-do-script-etl-para-assuntos)
  * [Descrição](#descrição-4)
  * [Funcionalidades](#funcionalidades-3)
  * [Dependências](#dependências-3)
  * [Estrutura do Projeto](#estrutura-do-projeto-4)
  * [Estrutura do Código](#estrutura-do-código-4)
    * [1. Função `extrai_dados`](#1-função-extrai_dados-3)
    * [2. Função `salva`](#2-função-salva-3)
    * [3. Função `run`](#3-função-run-3)
  * [Como Funciona](#como-funciona-3)
    * [Exemplo de Execução](#exemplo-de-execução-3)
      * [Parâmetros:](#parâmetros-3)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-5)
    * [Log e Erros](#log-e-erros-3)
* [Documentação do Script ETL para movimento](#documentação-do-script-etl-para-movimento)
  * [Descrição](#descrição-5)
  * [Funcionalidades](#funcionalidades-4)
  * [Dependências](#dependências-4)
    * [Estrutura do Código](#estrutura-do-código-5)
    * [1. Função `extrai_dados`](#1-função-extrai_dados-4)
    * [2. Função `salva`](#2-função-salva-4)
    * [3. Função `run`](#3-função-run-4)
  * [Como Funciona](#como-funciona-4)
    * [Exemplo de Execução](#exemplo-de-execução-4)
      * [Parâmetros:](#parâmetros-4)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-6)
    * [Log e Erros](#log-e-erros-4)
* [Documentação do Script ETL para Relacionamentos](#documentação-do-script-etl-para-relacionamentos)
  * [Descrição](#descrição-6)
  * [Funcionalidades](#funcionalidades-5)
  * [Dependências](#dependências-5)
  * [Estrutura do Projeto](#estrutura-do-projeto-5)
  * [Estrutura do Código](#estrutura-do-código-6)
    * [1. Função `extrai_dados`](#1-função-extrai_dados-5)
    * [2. Função `salva`](#2-função-salva-5)
    * [3. Função `run`](#3-função-run-5)
  * [Como Funciona](#como-funciona-5)
    * [Exemplo de Execução](#exemplo-de-execução-5)
      * [Parâmetros:](#parâmetros-5)
    * [Estrutura de Diretórios](#estrutura-de-diretórios-7)
    * [Log e Erros](#log-e-erros-5)
* [Documentação do Script ETL para gerador_caminho_json](#documentação-do-script-etl-para-gerador_caminho_json)
  * [Descrição](#descrição-7)
  * [Estrutura do Projeto](#estrutura-do-projeto-6)
  * [Funcionalidades Principais](#funcionalidades-principais-1)
  * [Estrutura de Diretórios](#estrutura-de-diretórios-8)
  * [Como Usar](#como-usar-1)
    * [1. Parâmetros Principais](#1-parâmetros-principais)
    * [2. Exemplo de Diretório de Arquivos](#2-exemplo-de-diretório-de-arquivos)
  * [Funções Principais](#funções-principais-1)
    * [`extrair(caminho, pasta, trt, ext=None)`](#extraircaminho-pasta-trt-extnone)
    * [`__main__`](#__main__)
  * [Estrutura do Código](#estrutura-do-código-7)
* [Documentação do Script ETL para Limpeza e Salvamento de Arquivos CSV](#documentação-do-script-etl-para-limpeza-e-salvamento-de-arquivos-csv)
  * [Descrição](#descrição-8)
  * [Estrutura do Projeto](#estrutura-do-projeto-7)
  * [Funcionalidades Principais](#funcionalidades-principais-2)
  * [Parâmetros da Função](#parâmetros-da-função)
    * [`limpa_para_banco(trt, directory, file_names, logger)`](#limpa_para_bancotrt-directory-file_names-logger)
    * [`clean_and_save(file_name, logger)`](#clean_and_savefile_name-logger)
  * [Estrutura do Código](#estrutura-do-código-8)
  * [Como Usar](#como-usar-2)
    * [1. Executando o Script](#1-executando-o-script)
    * [2. Registro de Informações](#2-registro-de-informações)
  * [Funções Principais](#funções-principais-2)
    * [`limpa_para_banco(trt, directory, file_names, logger)`](#limpa_para_bancotrt-directory-file_names-logger-1)
    * [`clean_and_save(file_name, logger)`](#clean_and_savefile_name-logger-1)
  * [Estrutura do Código](#estrutura-do-código-9)
* [Scripts de Integração e Processamento de Banco de Dados](#scripts-de-integração-e-processamento-de-banco-de-dados)
  * [Arquivos:](#arquivos)
    * [Exemplo de Uso](#exemplo-de-uso)
      * [Configuração do Ambiente](#configuração-do-ambiente)
      * [Executando os Scripts](#executando-os-scripts)
      * [Fluxo Geral de Execução](#fluxo-geral-de-execução)
* [Limpadores - Módulo CorretorGeral](#limpadores---módulo-corretorgeral)
      * [Funções Principais](#funções-principais-3)
    * [Exemplos de Uso](#exemplos-de-uso)
      * [Exemplo de Chamada](#exemplo-de-chamada)
      * [Estrutura de Saída](#estrutura-de-saída)
      * [`limpa_para_banco(trt, directory, file_names, logger)`](#limpa_para_bancotrt-directory-file_names-logger-2)
        * [Parâmetros:](#parâmetros-6)
        * [Passos Internos:](#passos-internos)
  * [Como Usar](#como-usar-3)
  * [Estrutura de Logs](#estrutura-de-logs)
  * [Tratamento de Erros](#tratamento-de-erros)
* [Limpadores - Módulo limpador](#limpadores---módulo-limpador)
    * [Função `limpadores(root, trt)`](#função-limpadoresroot-trt)
  * [Dependências](#dependências-6)
  * [Como Utilizar](#como-utilizar)
  * [Logs e Erros](#logs-e-erros)
  * [Estrutura de Saída](#estrutura-de-saída-1)
* [Limpadores - Módulo `movimento_map_parte`](#limpadores---módulo-movimento_map_parte)
  * [Descrição do Script `movimento_map_parte.py`](#descrição-do-script-movimento_map_partepy)
    * [Estrutura do Script](#estrutura-do-script)
    * [Caminhos de Arquivos Utilizados](#caminhos-de-arquivos-utilizados)
    * [Exemplo de Execução](#exemplo-de-execução-6)
    * [Resultado](#resultado)
* [ferramentas Uteis](#ferramentas-uteis)
  * [correção Json](#correção-json)
    * [Aplicação](#aplicação)
  * [correção StringUtil](#correção-stringutil)
    * [aplicação](#aplicação-1)
* [DevOps Módulo de Verificação e Processamento](#devops-módulo-de-verificação-e-processamento)
      * [Principais Funções:](#principais-funções)
  * [Validadores CPF, CNPJ, TE](#validadores-cpf-cnpj-te)
* [Ferramenta para enriquecimento de dados das partes sem genero](#ferramenta-para-enriquecimento-de-dados-das-partes-sem-genero)
    * [Consulta ao Banco de Dados](#consulta-ao-banco-de-dados)
  * [Fluxo de Execução](#fluxo-de-execução)
  * [Funções Implementadas](#funções-implementadas)
    * [`att_base(query)`](#att_basequery)
    * [`get_df(query, base)`](#get_dfquery-base)
    * [`ler_df(base)`](#ler_dfbase)
    * [`pega_dado(base)`](#pega_dadobase)
    * [`manipula_dado(base)`](#manipula_dadobase)
    * [`estuda_gen(base)`](#estuda_genbase)
    * [`atualiza_base(base)`](#atualiza_basebase)
  * [Execução do Script](#execução-do-script)
  * [Estrutura de Saída](#estrutura-de-saída-2)
    * [Cálculos Realizados](#cálculos-realizados)
    * [Resultados](#resultados)
  * [Autor](#autor)
<!-- TOC -->
___


## Descrição
Este script realiza o processamento de dados de processos judiciais, extraindo, limpando e registrando informações.
O script utiliza a biblioteca **Joblib** para processamento paralelo e funções personalizadas para extração e limpeza de arquivos CSV. Ele foi projetado para lidar com várias categorias de dados, como movimentos, partes, assuntos, processos e relacionamentos entre processos.

## Estrutura do Projeto

```
├── analisadores                                 
│   └── enriquecimento_genero           # script gerado para preencher os id_generos de partes que estão como null. 
├── csv                                 
│   └── {trt}                           # as pastas são geradas automaticamente elas contem o RAW e os dados TRATADOS para ir ao banco
├── ERM                                 # diagrama do banco de dados CODEX
├── logs
│   ├── {trt}                           # cada pasta do trt gerado vai ter o seu log de maneira individual
│   └── ETL
│       └── db
│           └── banco_banco.csv         # registro de quais arquivos já foram subidos para o banco
├── src
│   ├── Extrator
│   │   ├── assuntos.py                 # EXTRATOR de assuntos seguindo o padrão do CODEX
│   │   ├── dados_processo.py           # EXTRATOR de processos seguindo o padrão do CODEX
│   │   ├── movimento.py                # EXTRATOR de movimentos seguindo o padrão do CODEX
│   │   ├── parte.py                    # EXTRATOR de parte seguindo o padrão do CODEX
│   │   ├── processo_distribuicoes.py   # EXTRATOR de distribuições seguindo o padrão do CODEX
│   │   ├── relacionamentos.py          # EXTRATOR de ralacionamentos seguindo o padrão do CODEX
│   │   └── run.py                      # fuções que iniciam os extratores
│   ├── Load
│   │   ├── model                       # todos os modelos de ORM estão nessa pasta
│   │   ├── .env_template               # remova o _template deixando somente o .env e coloque suas credencias do banco
│   │   ├── banco.py                    # Script principal para processar arquivos CSV em blocos e carregar dados em tabelas do banco de dados 
│   │   ├── engine.py                   # função responsável por gerenciar a conexão com o banco de dados utilizando SQLAlchemy
│   │   └── query.py                    # responsável por executar a inserção e atualização de dados no banco de dados a partir de arquivos CSV
│   ├── Tratadores
│   │   └── limpadores                  
│   │   │   ├── Corretor_limpa.py       # faz toda a limpeza necessaria do csv
│   │   │   ├── limpa_csv_duplicados.py # remove possiveis linhas duplicadas
│   │   │   ├── Limpador.py             # usa a função de corretor limpar para cada csv indicado
│   │   │   ├── movimento_map_parte.py  # extrai o nome de parte e atribui o id
│   │   │   └── orgaoJulgador_limpa.py  # remove duplicatas de orgao julgador não existente em orgao julgador não mencionados antes
│   ├── __main__.py                     # inicializa todas as etapas para rodar o banco sendo este o script principal
│   ├── run_banco.py                    # inicializa as etapas para rodar o upload do banco
│   ├── run_limpa.py                    # inicializa as etapas para rodar os limpadores
│   └── run_mult.py                     # inicializa as etapas para rodar os extratores
├── util
│   ├── corrige_erro_arquivo.py         # Função auxiliar para correção do json
│   ├── DevOps.py                       # Funções auxiliar para não repetir o mesmo arquivo já processado
│   ├── gerador_caminho_json.py         # Analisa os documentos que estão no LAKE e informa se tem arquivos novos não processados
│   ├── StringUtil.py                   # Fuções que tiram acentuações e erros no json não tratados
│   ├── validador_cnpj.py               # valida cnpj
│   ├── validador_cpf.py                # valida cpf
│   └── validador_te.py                 # valida titulo de eleitor
├── README_RUN.md                       # Documento de orientação do projeto
└── README_BANCO.md                     # Documento de orientação do banco
```

- **Extract**: Contém as classes de extração de dados, como `distribuicoes`, `parte`, `assuntos`, `movimento`, `dados_processo`, e `relacionamento`.
- **Tratadores**: Inclui os módulos de limpeza de dados, como `limpa_csv_duplicatas`, que trata a remoção de duplicatas e outros problemas nos arquivos CSV.
- **Util**: Contém funções auxiliares, como [`gerador_caminho_json`](#script-de-extração-de-arquivos-json-para-processamento-de-dados-jurídicos---gerador_caminho_json), que gerencia a geração e manipulação dos caminhos dos arquivos JSON. Esse arquivo também controla quais os json chegaram a mais e os incorpora ao mapa de json a serem processados
## Funcionalidades Principais

1. **Extração de Dados**: Extrai dados de arquivos TXT com caminhos de arquivos JSON relacionados a processos judiciais.
2. **Limpeza de Dados**: Realiza limpeza nos arquivos extraídos, tratando duplicatas e outros erros que podem ocorrer durante o processo.
3. **Registro de Logs**: Gera logs detalhados sobre o processo de extração e possíveis problemas encontrados durante o processamento.
## Estrutura de Diretórios

Os dados e logs gerados pelo script são organizados em diretórios específicos para cada tipo de dado e tribunal:
## Estrutura de Diretórios

- `../logs/{trt}`: Contém os arquivos de log para cada tribunal.
- `../csv/{trt}/parte`: Contém os CSVs processados para as partes envolvidas nos processos.
- `../csv/{trt}/assuntos`: Contém os CSVs processados para os assuntos dos processos.
- `../csv/{trt}/movimentos`: Contém os CSVs processados para os movimentos dos processos.
- `../csv/{trt}/dados_processo`: Contém os CSVs processados para os dados gerais dos processos.
- `../csv/{trt}/relacionamentos`: Contém os CSVs processados para os relacionamentos entre processos.
- `../csv/{trt}/distribuicoes`: Contém os CSVs processados para o historico de distribuições.
## Script de comandos para rodar o projeto
1. **__main__.py**: fica localizado na pasta de src, ele implementa o run_mult, run_limpa e o run_banco.
2. **run_mult.py**: inicia somente os extratores 
3. **run_banco.py**: inicia somente os tratadores
4. **run_limpa.py**: inicia somente o upload para o banco

**NOTA**: o util.DevOps faz o controle do que já foi processado, caso queira reprocessar o mesmo arquivo é necessario usar para controlar os arquivos de controle
  
## Como Usar

### 1. Configuração de Ambiente

Instale as dependências necessárias:

```bash
pip install -r requirements.txt
```

### 2. Executando o Script

O script pode ser executado diretamente a partir da linha de comando:

```bash
python run.py
```

Aqui, o script processará automaticamente as listas de caminhos fornecidas em arquivos `.txt` localizados em `../data/lista_dados/{trt}/{item}.txt`.

### 3. Argumentos Principais

- **grau**: Grau da instância judicial. Pode ser 1 (primeiro grau) ou 2 (segundo grau).
- **n**: Código do tribunal (por exemplo, 13 para TRT13, 14 para TRT14).
- **n_job**: Número de tarefas a serem executadas em paralelo (padrão: 10).

### 4. Exemplo de Uso

O seguinte comando processa os dados para o TRT13, no primeiro grau:

```bash
python run.py --tribunal 13 --grau 1 --jobs 10
```
---
## Funções Principais

### `setup_logger(name, log_file, level=logging.INFO)`

Configura o logger para registrar informações em um arquivo de log.

### `running(e, item, trt, log_folder, g, n_job=None)`

Processa os arquivos de entrada, extrai os dados e realiza a limpeza para inserção no banco de dados. Cria logs sobre o progresso e problemas encontrados.
dentro dessa função é chamada a função de limpeza.

### `go(n, grau, n_job=None)`

Configura os parâmetros e caminhos necessários para o processamento de um tribunal específico.

#### dentro da função go
é criado as pastas para armazenar as saidas e iniciada em sequencia cada umas das tasks 
sendo estes `(<extrator_item>, '<nome_output>', <tribunal>, <grau>, <quantidade_de_nucleos_processantes>)`

````
tasks = [
      (parte.Extract(), 'partes', trt, grau, n_job),
      (movimento.Extract(), 'movimentos', trt, grau, n_job),
      (dados_processo.Extract(), 'processos', trt, grau, n_job),
      (assuntos.Extract(), 'assuntos', trt,grau, n_job),
      (relacionamento.Extract(), 'relacionamentos', trt, grau, n_job),
      (processo_distribuicoes.Extract(), 'distribuicoes', trt, grau, n_job),
  ]

for task in tasks:
    running(*task)
````
## Estrutura do Código

- **logging**: Configuração e gerenciamento de logs.
- **joblib**: Gerenciamento de processamento paralelo.
- **src.Extract**: Módulo de extração de dados de partes, assuntos, movimentos, etc.
- **limpa_csv_duplicatas**: Função de limpeza de CSV para garantir a integridade dos dados.
## Estrutura dos Extratores

**src/Extract/**:
  - [`parte.py`](#documentação-do-script-etl-para-parte)
  - [`assuntos.py`](#documentação-do-script-etl-para-assuntos)
  - [`movimentos.py`](#documentação-do-script-etl-para-movimento)
  - [`dados_processo.py`](#documentação-do-script-etl-para-processo)
  - [`relacionamentos.py`](#documentação-do-script-etl-para-relacionamentos)
  - [`processo_distribuicoes.py`](#documentação-do-script-etl-para-distribuições) 

- **src/Tratadores/**:
  - Contém os modulos responsaveis por tirar duplicatas, limpar e mapear os dados

- **data/lista_dados/**: Diretório onde os arquivos de caminho (listas de processos) estão armazenados.
- **csv/**: Diretório onde os resultados das extrações são salvos, organizados por tribunal.
- **logs/**: Diretório onde os logs de execução são gerados.
## Scripts Extratores
- n ==> escolha o numero de arquivos processados de uma vez
- trt ==> escolha o TRT a ser processado
- **src/Extract/**: 
  - `python ./src/Extract/parte.py --run <n> --trt <trt>`
  - `python ./src/Extract/dados_processo.py --run <n> --trt <trt>`
  - `python ./src/Extract/movimento.py --run <n> --trt <trt>`
  - `python ./src/Extract/relacionamento.py --run <n> --trt <trt>`
  - `python ./src/Extract/processo_distribuicoes.py --run <n> --trt <trt>`
  - `python ./src/Extract/assuntos.py --run <n> --trt <trt>`
## Scripts Tratadores
- **src/Tratadores/limpadores**
    - Cotém todos limpadores para serem usados após o processamento sendo estes após agrupados

Este script orquestra a execução dos diferentes módulos de extração. Ele pode ser configurado para rodar extrações específicas (ex: partes, assuntos) em paralelo para diferentes tribunais e graus de jurisdição.

---
# Documentação do Script ETL para parte

## Descrição

O script `parte.py` é destinada a processar dados de partes do processo.
Ele extrai informações sobre partes envolvidas em processos, seus documentos e outros detalhes relacionados a partir de arquivos JSON,
realiza validações e salva os dados em arquivos CSV. O script utiliza processamento paralelo para otimizar o desempenho.

## Funcionalidades

- **Extração de Dados**: Extrai informações de processos, partes, documentos e tipos de partes a partir de arquivos JSON.
- **Validação de Dados**: Valida documentos como CPF, CNPJ e TE.
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processamento paralelo dos arquivos JSON.

## Dependências

o script depende de módulos personalizados localizados na pasta `util` e `src/Tratadores`, como:
- `StringUtil`
- `corrige_erro_arquivo`
- `validador_cpf`
- `validador_cnpj`
- `validador_te`

## Estrutura do Projeto

- **parte.py**: Script principal para extração e processamento dos dados de parte.
- **util/corrige_erro_arquivo.py**: Função auxiliar `concerta_json` para corrigir erros nos arquivos JSON.
- **src/Tratadores/limpadores/limpa_csv_duplicatas.py**: Função para remover duplicatas do CSV e preparar os dados para o banco de dados.

## Estrutura do Código

### 1. Função `extrai_dados`

Esta função processa os dados do processo e extrai informações sobre:
- Partes envolvidas (`parte_lista`)
- Relação entre processos e partes (`processo_parte_list`)
- Documentos (`documentos_lista`)
- Tipos de partes (`tipo_lista`)
- Relação entre partes e documentos (`parte_documento_lista`)

### 2. Função `salva`

Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `parte.csv`
- `processo_parte.csv`
- `documentos.csv`
- `tipo_parte.csv`
- `parte_documento.csv`

### 3. Função `run`

Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona

1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução

O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python parte.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:

- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios

Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:

```
../csv/{trt}/parte/parte.csv
../csv/{trt}/parte/processo_parte.csv
../csv/{trt}/parte/documentos.csv
../csv/{trt}/parte/tipo_parte.csv
../csv/{trt}/parte/parte_documento.csv
```

Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para Processo

## Descrição

O script `dados_processo.py` é destinada a processar dados dos processos.
Ele extrai informações sobre os processos, seus órgão julgadores, tribunais e outros detalhes relacionados a partir de arquivos JSON,
realiza validações e salva os dados em arquivos CSV. O script utiliza processamento paralelo para otimizar o desempenho.


## Funcionalidades

- **Extração de Dados**: Extrai informações sobre processos a partir de arquivos JSON.
- **Validação e Correção de Arquivos**: Corrige possíveis erros nos arquivos JSON antes da extração.
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processar múltiplos arquivos JSON em paralelo.

## Dependências
Além disso, o script depende de módulos personalizados localizados na pasta `util`, como:
- `corrige_erro_arquivo`
- `StringUtil`

## Estrutura do Projeto

- **dados_processo.py**: Script principal para extração e processamento dos dados de assuntos.
- **util/corrige_erro_arquivo.py**: Função auxiliar `concerta_json` para corrigir erros nos arquivos JSON.
- **src/Tratadores/limpadores/limpa_csv_duplicatas.py**: Função para remover duplicatas do CSV e preparar os dados para o banco de dados.


## Estrutura do Código

### 1. Função `extrai_dados`

Esta função processa os dados do processo e extrai informações sobre:
- lista de processos (`processo`)
- tribunal associado (`tribunal`)
- órgão julgador (`orgao_julgador`)
- órgão julgador local (`orgao_julgador_local`)
- órgão julgador colegiado que só aparece no segundo grau (`orgao_julgador_colegiado`)
- competência do processo (`competencia`) 

### 2. Função `salva`

Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `processo.csv`
- `tribunal.csv`
- `competencia.csv`
- `orgao_julgador.csv`
- `orgao_julgador_local.csv`
- `orgao_julgador_colegiado.csv`


### 3. Função `run`

Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona

1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução

O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python dados_processo.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:

- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios

Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:

```
../csv/{trt}/dados_processo/processo.csv
../csv/{trt}/dados_processo/tribunal.csv
../csv/{trt}/dados_processo/competencia.csv
../csv/{trt}/dados_processo/orgao_julgador.csv
../csv/{trt}/dados_processo/orgao_julgador_local.csv
../csv/{trt}/dados_processo/orgao_julgador_colegiado.csv

```

Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para Distribuições

## Descrição

O script `processo_distribuicoes.py` é destinada a processar o histórico das distribuições do processo.
Ele extrai informações sobre onde o processo passou a partir de arquivos JSON,
realiza validações e salva os dados em arquivos CSV. O script utiliza processamento paralelo para otimizar o desempenho.

## Funcionalidades

- **Extração de Dados**: Extrai informações das distribuições do processo a partir de arquivos JSON.
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processamento paralelo dos arquivos JSON.

## Dependências

o script depende de módulos personalizados localizados na pasta `util` e `src/Tratadores`, como:
- `StringUtil`
- `corrige_erro_arquivo`
- `validador_de_orgao_julgador`

## Estrutura do Projeto

- **parte.py**: Script principal para extração e processamento dos dados de parte.
- **Tratadores/limpadores/orgaoJulgador_limpadores.py** : Script dedicado em tirar as duplicatas na lista de órgão julgador não encontrado que vem de processos.
- **util/corrige_erro_arquivo.py**: Função auxiliar `concerta_json` para corrigir erros nos arquivos JSON.
- **src/Tratadores/limpadores/limpa_csv_duplicatas.py**: Função para remover duplicatas do CSV e preparar os dados para o banco de dados.

## Estrutura do Código

### 1. Função `extrai_dados`

Esta função processa os dados do processo e extrai informações sobre:
- distribuições do processo (`parte_lista`)
- Relação entre processo distribuído e órgão julgador (`processo_parte_list`)

### 2. Função `salva`

Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `distribuicoes_processos.csv`
- `orgao_julgador_add.csv`


### 3. Função `run`

Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona

1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução

O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python processo_distribuicoes.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:

- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios

Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:

```
../csv/{trt}/distribuicoes/parte.csv
../csv/geral/PR3/orgao_julgador_add.csv

```

Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para Assuntos

## Descrição

O script `assuntos.py` é destinada a processar dados de partes do processo.
Ele extrai informações sobre partes envolvidas em processos, seus documentos e outros detalhes relacionados a partir de arquivos JSON,
realiza validações e salva os dados em arquivos CSV. O script utiliza processamento paralelo para otimizar o desempenho.


## Funcionalidades
- **Extração de Dados**: Extrai informações sobre assuntos de processos a partir de arquivos JSON.
- **Validação e Correção de Arquivos**: Corrige possíveis erros nos arquivos JSON antes da extração.
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processar múltiplos arquivos JSON em paralelo.

## Dependências
Além disso, o script depende de módulos personalizados localizados na pasta `util`, como:
- `corrige_erro_arquivo`

## Estrutura do Projeto
- **assuntos.py**: Script principal para extração e processamento dos dados de assuntos.
- **util/corrige_erro_arquivo.py**: Função auxiliar `concerta_json` para corrigir erros nos arquivos JSON.
- **src/Tratadores/limpadores/limpa_csv_duplicatas.py**: Função para remover duplicatas do CSV e preparar os dados para o banco de dados.


## Estrutura do Código

### 1. Função `extrai_dados`
Esta função processa os dados do processo e extrai informações sobre:
- processo-assunto (`assunto_list`)

### 2. Função `salva`
Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `processo_assunto.csv`

### 3. Função `run`
Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona
1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução
O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python assuntos.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:
- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios
Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:

```
../csv/{trt}/assuntos/processo_assunto.csv
```

Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para movimento

## Descrição
O script `movimento.py` é destinada a processar dados de moviemtnos do processo.
Ele extrai informações sobre partes envolvidas em processos, seus documentos e outros detalhes relacionados a partir de arquivos JSON,
realiza validações e salva os dados em arquivos CSV. O script utiliza processamento paralelo para otimizar o desempenho.

## Funcionalidades
- **Extração de Dados**: Extrai informações de movimentos, magistrados e documentos a partir de arquivos JSON.
- **extração de partes**: Extrai nomes com ou sem (CPF|CNPJ).
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processamento paralelo dos arquivos JSON.

## Dependências
o script depende de módulos personalizados localizados na pasta `util` e `src/Tratadores`, como:
- `StringUtil`
- `corrige_erro_arquivo`

### Estrutura do Código

### 1. Função `extrai_dados`
Esta função processa os dados do processo e extrai informações sobre:
- Movimentos (`movimentos`)
- Relação entre documentos com documentos(`docs`)
- magistrados (`magistrados`)

### 2. Função `salva`
Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `movimentos.csv`
- `magistrados.csv`
- `docs.csv`

### 3. Função `run`
Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona
1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução
O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python movimento.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:
- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios
Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:
```
../csv/{trt}/movimentos/docs.csv
../csv/{trt}/movimentos/magistrados.csv
../csv/{trt}/movimentos/movimentos.csv
```

Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para Relacionamentos

## Descrição
Este script `relacionamento.py` é projetado para extrair e processar dados de relacionamentos a partir de arquivos JSON contendo informações de processos jurídicos. Os dados extraídos são então limpos, deduplicados e salvos no formato CSV para análise posterior. O script utiliza processamento paralelo para otimizar o desempenho ao processar grandes volumes de dados.


## Funcionalidades
- **Extração de Dados**: O script extrai os relacionamentos dos processos, incluindo o número do processo relacionado, o tipo de relação e a data de exclusão, se houver.
- **Limpeza e Deduplicação**: Os dados extraídos são automaticamente deduplicados e preparados para serem salvos no banco de dados.
- **Salvamento de Dados**: Salva os dados extraídos em arquivos CSV.
- **Processamento Paralelo**: Utiliza Joblib para processamento paralelo dos arquivos JSON.

## Dependências
o script depende de módulos personalizados localizados na pasta `util` e `src/Tratadores`, como:
- `StringUtil`
- `corrige_erro_arquivo`

## Estrutura do Projeto
- **relacionamento.py**: Script principal para extração e processamento dos dados de relacionamento.
- **util/corrige_erro_arquivo.py**: Função auxiliar `concerta_json` para corrigir erros nos arquivos JSON.
- **src/Tratadores/limpadores/limpa_csv_duplicatas.py**: Função para remover duplicatas do CSV e preparar os dados para o banco de dados.


## Estrutura do Código

### 1. Função `extrai_dados`
Esta função processa os dados do processo e extrai informações sobre:
- realcionamentos (`relacionamento_processo_list`)

### 2. Função `salva`
Salva os dados extraídos em arquivos CSV. O script cria diretórios conforme necessário e escreve os dados nos arquivos correspondentes:
- `relacionamento.csv`

### 3. Função `run`
Executa o processo de extração de dados e validação dos arquivos JSON.
Utiliza processamento paralelo para lidar com múltiplos arquivos.
Recebe uma lista de caminhos para os arquivos JSON, o nome do tribunal (TRT) e o número de threads a serem usadas.

## Como Funciona
1. O script lê os arquivos JSON fornecidos em uma lista de caminhos.
2. Para cada arquivo, os dados de relacionamentos de processos são extraídos e organizados em um DataFrame.
3. O DataFrame é deduplicado e salvo em um arquivo CSV específico para o tribunal fornecido.
4. O script registra problemas encontrados durante o processamento, como arquivos ausentes ou erros no formato dos dados.

### Exemplo de Execução
O script pode ser executado diretamente a partir da linha de comando. Aqui está um exemplo de como rodá-lo:

```bash
python relacionamento.py --run <NÚMERO_DE_THREADS> --trt <TRIBUNAL>
```

#### Parâmetros:
- `--run`: Número de threads a serem usadas no processamento (padrão: 4).
- `--trt`: Código do tribunal para o qual os dados estão sendo extraídos (padrão: `trt2pg`).

### Estrutura de Diretórios
Os arquivos CSV gerados serão salvos na seguinte estrutura de diretórios:

```
../csv/{trt}/relacionamentos/relacionamentos.csv
```
Onde `{trt}` representa o código do tribunal fornecido no parâmetro `--trt`.

### Log e Erros
- O script registra o tempo de execução e quaisquer problemas encontrados durante o processamento no arquivo de log. Se algum erro for detectado ao processar um arquivo JSON, ele será registrado junto com o caminho do arquivo problemático.

---
# Documentação do Script ETL para gerador_caminho_json

## Descrição

Este script automatiza o processo de extração de arquivos JSON contendo dados de processos judiciais de diferentes Tribunais Regionais do Trabalho (TRTs) e do Tribunal Superior do Trabalho (TST). Ele percorre diretórios predefinidos, verifica se os arquivos já foram processados, e armazena os caminhos dos arquivos JSON em arquivos `.txt` organizados por tribunal, pasta de dados e extensão (grau do tribunal).

## Estrutura do Projeto

- **pipeline()**: Classe principal que gerencia a extração de caminhos de arquivos JSON e o salvamento desses caminhos em arquivos `.txt`.
- **extrair()**: Método da classe `pipeline()` responsável por extrair caminhos de arquivos JSON, verificar duplicatas, e salvar os caminhos únicos.
- **run()**: Método que realiza a iteração pelos tribunais, datas e pastas para buscar os arquivos a serem processados.

## Funcionalidades Principais

1. **Extração de Arquivos JSON**: Busca e armazena os caminhos de arquivos `.json` contidos nos diretórios de origem.
2. **Prevenção de Duplicatas**: Verifica se um arquivo já foi processado e evita duplicar o registro no arquivo de destino.
3. **Registro de Caminhos**: Armazena os caminhos dos arquivos em arquivos `.txt` separados para cada pasta e tribunal, facilitando o processamento posterior.

## Estrutura de Diretórios

Os caminhos dos arquivos JSON extraídos são salvos em diretórios organizados por tribunal e pasta:

- `../data/lista_dados/{trt}{ext}/{pasta}.txt`: Caminho onde são salvos os arquivos `.txt` que contêm os caminhos dos arquivos JSON para cada tribunal (`trt`), extensão (`ext`) e pasta (`pasta`).

Exemplo de diretórios e arquivos gerados:

```
../data/lista_dados/trt1pg/partes.txt
../data/lista_dados/trt2sg/movimentos.txt
../data/lista_dados/tst_pje/assuntos.txt
```

## Como Usar

Ele irá iterar automaticamente pelos tribunais, datas e pastas de interesse, buscando e extraindo os arquivos JSON.

### 1. Parâmetros Principais

- **trt**: Lista de tribunais a serem processados (ex: TRT1, TRT2, TRT3...).
- **data**: Datas de referência para a busca de arquivos.
- **pasta**: Pastas específicas para extração de dados, como `assuntos`, `processos`, `distribuicoes`, `partes`, `movimentos`, `relacionamentos`.
- **grau**: Grau de jurisdição a ser processado (1 ou 2).

### 2. Exemplo de Diretório de Arquivos

Para o TRT1, no primeiro grau, o caminho seria:

```plaintext
\\lake\TRT1\TRT1\partes
```

Já para o TST_SIJ no segundo grau:

```plaintext
\\lake\TST_SIJ\TST_SIJ\movimentos
```

## Funções Principais

### `extrair(caminho, pasta, trt, ext=None)`

Extrai os arquivos JSON de um caminho específico, verifica se já foram processados, e registra os novos arquivos no arquivo `.txt` correspondente.

- **caminho**: Diretório de onde os arquivos JSON serão extraídos.
- **pasta**: Tipo de dado (assuntos, partes, etc.).
- **trt**: Tribunal (TRT1, TRT2, etc.).
- **ext**: Extensão do tribunal para diferenciar entre 1º e 2º grau (PG ou SG).

### `__main__`

Executa o pipeline para cada tribunal, data, pasta e grau, buscando e processando os arquivos.

## Estrutura do Código

- **os**: Usado para manipular diretórios e caminhos de arquivos.
- **glob**: Usado para encontrar arquivos que correspondem a um padrão específico.
- **tqdm**: Usado para exibir barras de progresso durante a execução do script.
- **pipeline**: Classe principal que gerencia a execução do pipeline de extração de arquivos JSON.
# Documentação do Script ETL para Limpeza e Salvamento de Arquivos CSV

## Descrição

Este script tem como objetivo automatizar a limpeza e preparação de arquivos CSV contendo dados de processos judiciais para posterior uso em banco de dados. Ele remove duplicatas, processa cada arquivo CSV e registra informações sobre o processo utilizando um logger.

## Estrutura do Projeto

- **limpa_para_banco(trt, directory, file_names, logger)**: Função principal que processa uma lista de arquivos CSV, removendo duplicatas e salvando os arquivos limpos no mesmo diretório. Cada arquivo processado é registrado através de um logger.
  - **clean_and_save(file_name, logger)**: Função auxiliar que realiza a limpeza de um arquivo CSV individual e o salva de volta no diretório original.

## Funcionalidades Principais

1. **Leitura e Processamento de Arquivos CSV**: Lê cada arquivo CSV especificado, removendo linhas duplicadas e pulando linhas problemáticas (`on_bad_lines='skip'`).
2. **Registro com Logger**: Utiliza um logger para registrar informações sobre o tamanho da tabela após a limpeza e para relatar possíveis erros durante o processamento.
3. **Salvamento dos Arquivos Limpados**: Após a limpeza, cada arquivo CSV é sobrescrito com os dados limpos.

## Parâmetros da Função

### `limpa_para_banco(trt, directory, file_names, logger)`

- **trt**: O nome do tribunal regional do trabalho (ex: TRT1, TRT2, etc.) ao qual os arquivos pertencem.
- **directory**: Caminho para o diretório onde os arquivos CSV estão localizados.
- **file_names**: Lista com os nomes dos arquivos CSV que serão processados.
- **logger**: Objeto de logger utilizado para registrar as atividades de processamento.

### `clean_and_save(file_name, logger)`

- **file_name**: Nome do arquivo CSV a ser processado.
- **logger**: Objeto de logger utilizado para registrar informações sobre o processo de limpeza.

## Estrutura do Código

1. **Leitura de Arquivo CSV**: A função `pd.read_csv()` é utilizada para carregar o arquivo CSV no pandas DataFrame, com a opção de `low_memory=False` para evitar problemas de memória com grandes arquivos.
2. **Remoção de Duplicatas**: A função `drop_duplicates()` remove quaisquer linhas duplicadas no arquivo CSV.
3. **Registro de Informações com Logger**: O logger registra o tamanho da tabela processada, usando a função `logger.info()` para registrar o número de linhas e colunas.
4. **Tratamento de Exceções**: A função `clean_and_save()` possui um bloco `try-except` para capturar e registrar possíveis erros que possam ocorrer durante a leitura ou o salvamento dos arquivos CSV.
5. **Salvamento de Arquivo CSV**: Após a limpeza, o arquivo CSV é sobrescrito no mesmo diretório com a codificação `utf-8`, usando separador `,` e `quotechar='"'`.

## Como Usar

### 1. Executando o Script

A função `limpa_para_banco()` deve ser chamada fornecendo os parâmetros necessários, como o nome do tribunal (TRT), diretório dos arquivos CSV, lista de nomes de arquivos, e o logger.

Exemplo de uso:

```
import logging

# Configuração do logger
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

# Definindo parâmetros
trt = 'TRT1'
directory = '/caminho/para/arquivos/'
file_names = ['processos.csv', 'movimentos.csv']

# Executando a limpeza
limpa_para_banco(trt, directory, file_names, logger)
```

### 2. Registro de Informações

O logger registra informações sobre o número de linhas e colunas de cada arquivo CSV processado. Em caso de erro, uma mensagem de erro será registrada.

Exemplo de mensagem de log:

```
INFO: a tabela processos.csv do TRT1 tem (10000, 15)
```

## Funções Principais

### `limpa_para_banco(trt, directory, file_names, logger)`

Processa uma lista de arquivos CSV, limpando e salvando os arquivos no mesmo diretório. Utiliza um logger para registrar as informações sobre o processamento.

- **trt**: O tribunal responsável pelos arquivos.
- **directory**: Caminho para o diretório onde os arquivos estão localizados.
- **file_names**: Lista de nomes dos arquivos CSV.
- **logger**: Logger utilizado para registrar as operações.

### `clean_and_save(file_name, logger)`

Realiza o processo de limpeza para um arquivo CSV individual e salva as alterações no diretório original.

- **file_name**: Nome do arquivo CSV a ser processado.
- **logger**: Logger utilizado para registrar informações e erros.

## Estrutura do Código

- **os**: Biblioteca usada para manipular caminhos de arquivos e diretórios.
- **pandas (pd)**: Usado para leitura e manipulação de arquivos CSV.
- **logger**: Usado para registrar as atividades do processo de limpeza.
___
Com a adição do script **`query.py`**, você pode expandir a seção do README.md para incluir a funcionalidade deste arquivo e sua interação com os outros scripts. Aqui está como você pode atualizar a seção:

---
# Scripts de Integração e Processamento de Banco de Dados

Este conjunto de scripts é responsável pela conexão com o banco de dados, processamento de arquivos CSV e inserção de dados nas tabelas relacionadas a processos judiciais.

## Arquivos:

- **`banco.py`**:  
  Script principal para processar arquivos CSV em blocos e carregar dados em tabelas do banco de dados. Gerencia informações relacionadas a:
  - Partes, documentos e tipos de partes.
  - Processos, assuntos e suas distribuições.
  - Movimentos judiciais, magistrados e órgãos julgadores.
  - Relacionamentos entre processos e outras entidades.

- **`db_engine.py`**:  
  Define a classe `DBEngine`, responsável por gerenciar a conexão com o banco de dados utilizando SQLAlchemy.  
  - Conecta-se ao banco com credenciais fornecidas via `.env`.
  - Cria sessões de banco para operações transacionais.
  - Fornece o objeto `engine` para manipulação direta de SQL.

- **`query.py`**:  
  Script responsável por executar a inserção e atualização de dados no banco de dados a partir de arquivos CSV.  
  - **Funcionalidades principais**:
    - Garante que a tabela associada a um modelo existe no banco (cria a tabela, se necessário).
    - Filtra registros existentes no banco antes de realizar inserções ou atualizações.
    - Gerencia a inserção de dados em blocos (chunking) para evitar problemas de memória.
    - Trata erros específicos durante operações no banco, como conflitos de chave primária ou valores nulos.
    - Atualiza o status de processamento de arquivos no CSV de controle após a conclusão do upload.
  - **Dependências**:
    - **`db_engine.py`**: Para conexão e transações com o banco de dados.
    - **`util.DevOps.verifica_upload`**: Para verificar o status de processamento do arquivo.

### Exemplo de Uso

#### Configuração do Ambiente

Antes de executar os scripts, certifique-se de configurar o ambiente corretamente:

1. **Instale as dependências:**  
   Instale as bibliotecas necessárias listadas no arquivo `requirements.txt`.  
   ```bash
   pip install -r requirements.txt
   ```

2. **Crie o arquivo `.env`:**  
   Configure as variáveis de ambiente necessárias no arquivo `.env`. Um exemplo de configuração para conexão ao banco de dados:
   ```
   DB_SERVER=seu_servidor
   DB_DATABASE=seu_banco
   DRIVER=ODBC+Driver+17+for+SQL+Server
   ```

3. **Organize a estrutura de pastas:**  
   Certifique-se de ter os arquivos CSV organizados e que o caminho para o log de controle esteja configurado corretamente no script.

#### Executando os Scripts

1. **Processar arquivos CSV com `banco.py`:**
   Este é o script principal para processar e carregar os dados no banco. Para executá-lo:
   ```bash
   python banco.py caminho/do/arquivo.csv
   ```

   **Parâmetros:**
   - `caminho/do/arquivo.csv`: Caminho do arquivo CSV a ser processado.

2. **Conectar ao Banco de Dados com `db_engine.py`:**
   O script `db_engine.py` é utilizado internamente pelos outros scripts para gerenciar conexões. Porém, você pode utilizá-lo diretamente para testar a conexão ao banco:
   ```
   from db_engine import DBEngine

   db = DBEngine()
   session = db.create_session()

   # Testando a conexão
   print(session.query('SELECT 1').all())
   ```

3. **Inserir ou Atualizar Registros com `query.py`:**
   O script `query.py` permite processar arquivos CSV, inserindo ou atualizando registros no banco. Exemplo de uso:
   ```
   from query import process_csv_in_chunks
   from src.Load.model import Parte, TipoParte, ProcessoParte, ParteDocumento, Documentos, DistribuicoesProcesso, \
    Movimentos, Magistrado, Relacionamentos, Processo, ProcessoAssunto, Competencia, TipoJustica, OrgaoJulgador, \
    OrgaoJulgadorLocal, OrgaoJulgadorColegiado, Polo, Genero, Natureza, Tribunal, Situacao

   file_path = 'caminho/do/arquivo.csv'
   primary_keys = ['id']  # Colunas que são chave primária no modelo
   att = True  # Flag para habilitar atualizações de registros existentes

   process_csv_in_chunks(file_path, Modelo, primary_keys, att)
   ```

   **Parâmetros:**
   - `file_path`: Caminho do arquivo CSV a ser processado.
   - `Modelo`: Classe ORM que representa a tabela no banco de dados.
   - `primary_keys`: Lista das colunas usadas como chave primária.
   - `att`: Flag para ativar ou desativar a atualização de registros existentes.

---

#### Fluxo Geral de Execução

1. **Preparação do Banco de Dados:**
   - O script `query.py` garante que as tabelas necessárias sejam criadas antes de inserir os dados.

2. **Processamento de Dados:**
   - `banco.py` e `query.py` processam os dados em blocos, evitando problemas de memória.

3. **Controle de Status de Upload:**
   - O status de processamento dos arquivos é atualizado em um CSV de controle localizado em `../logs/ETL/bd/banco_banco.csv`.

4. **Logs de Execução:**
   - Os logs de execução são armazenados na pasta especificada no script, facilitando o monitoramento.
   
---
# Limpadores - Módulo CorretorGeral

O script `CorretorGeral` é responsável por corrigir, limpar e padronizar tabelas provenientes de arquivos CSV. Ele utiliza bibliotecas como `Pandas` e `NumPy` para realizar as transformações. Abaixo, segue a descrição das principais funções disponíveis no script:

#### Funções Principais

1. **`corrige_assunto(arquivo_csv, root)`**
   - Corrige e filtra os dados da tabela de assuntos relacionados a processos judiciais.
   - Remove duplicatas e registros com IDs inválidos.
   - Salva a tabela limpa em: `assuntos/processo_assunto_banco.csv`.

2. **`corrige_competencia(arquivo_csv, root)`**
   - Corrige a tabela de competências jurídicas, mapeando colunas específicas para IDs padronizados (e.g., tipo de justiça, natureza).
   - Remove duplicatas e salva os arquivos processados em:
     - `dados_processo/tipo_justica.csv`
     - `dados_processo/natureza.csv`
     - `dados_processo/competencia_banco.csv`.

3. **`corrige_processo(arquivo_csv, root)`**
   - Trata os dados relacionados a processos judiciais:
     - Valida e filtra números únicos do processo (NPU) com base em um padrão regex.
     - Remove duplicatas e salva a tabela limpa em: `dados_processo/processo_banco.csv`.

4. **`org_limpa_geral(arquivo_csv)`**
   - Consolida dados do órgão julgador a partir de dois arquivos CSV, removendo duplicatas.

5. **`corrige_org(arquivo_csv, root)`**
   - Trata informações de órgãos julgadores, removendo duplicatas e valores inválidos.
   - Salva os resultados em: `dados_processo/orgao_julgador_banco.csv`.

6. **`corrige_org_local(arquivo_csv, root)`**
   - Corrige dados de órgãos locais (e.g., nome e ID), aplicando remoção de duplicatas e preenchendo valores nulos.
   - Salva a saída em: `dados_processo/orgao_julgador_local_banco.csv`.

7. **`corrige_org_colegiado(arquivo_csv, root)`**
   - Similar ao anterior, mas focado em órgãos colegiados.
   - Salva o resultado em: `dados_processo/orgao_julgador_colegiado_banco.csv`.

8. **`corrige_documentos(arquivo_csv, root)`**
   - Corrige e organiza dados relacionados a documentos, como tipo, número e emissores.
   - Remove duplicatas e valores inválidos.
   - Salva os arquivos processados em:
     - `../csv/geral/PR_3/doc_tipo.csv`
     - `parte/documentos_banco.csv`.

9. **`corrige_processo_parte(arquivo_csv, root)`**
   - Filtra e padroniza informações sobre os relacionamentos entre processos e partes envolvidas.
   - Salva tabelas auxiliares de situações e polos, além dos dados limpos em:
     - `parte/situacao.csv`
     - `parte/polo.csv`.

10. **`corrige_parte(arquivo_csv, root)`**
    - Trata e padroniza dados de partes envolvidas nos processos, validando IDs e outros campos.

---

### Exemplos de Uso

#### Exemplo de Chamada
```
from CorretorGeral import CorretorGeral

corretor = CorretorGeral()
corretor.corrige_assunto("caminho_para_arquivo.csv", "diretorio_destino")
```

#### Estrutura de Saída
Os arquivos corrigidos são salvos em diretórios organizados, como:
- `dados_processo/`: Dados relacionados a processos, competências e órgãos julgadores.
- `parte/`: Dados de partes e documentos relacionados.

#### `limpa_para_banco(trt, directory, file_names, logger)`

Esta é a função principal do script, que executa o processo de limpeza para uma lista de arquivos CSV.

##### Parâmetros:
- `trt`: Identifica o tribunal relacionado ao processo.
- `directory`: Diretório onde os arquivos CSV estão localizados.
- `file_names`: Lista com os nomes dos arquivos a serem processados.
- `logger`: Logger para registrar informações e erros durante o processo.

##### Passos Internos:
1. Para cada arquivo na lista `file_names`, chama a função `clean_and_save`.
2. **`clean_and_save(file_name, logger)`**:
   - Verifica se o arquivo existe no diretório especificado.
   - Lê o arquivo CSV ignorando linhas problemáticas com `on_bad_lines='skip'`.
   - Remove linhas duplicadas utilizando `df.drop_duplicates()`.
   - Salva o arquivo processado no mesmo caminho com as seguintes configurações:
     - `index=False`: Não salva os índices como coluna.
     - `encoding='utf-8'`: Define a codificação do arquivo como UTF-8.
     - `sep=','`: Define o separador como vírgula.
     - `quotechar='"'`: Define o caractere de aspas para campos.
   - Registra o tamanho da tabela antes de salvar (número de linhas e colunas).
   - Trata exceções e registra erros, caso ocorram.

## Como Usar

1. Certifique-se de que os arquivos CSV estão no diretório especificado.
2. Prepare uma lista dos nomes dos arquivos a serem limpos e forneça como entrada no parâmetro `file_names`.
3. Configure um `logger` para registrar informações sobre o processamento.
4. Execute a função `limpa_para_banco` com os parâmetros adequados.

Exemplo de Uso:
```
from logger_config import setup_logger

# Configuração do logger
logger = setup_logger("limpador.log")

# Diretório e arquivos
directory = "/caminho/para/arquivos"
file_names = ["arquivo1.csv", "arquivo2.csv", "arquivo3.csv"]

# Execução
limpa_para_banco("TRT01", directory, file_names, logger)
```

## Estrutura de Logs

Os logs gerados pela função fornecem informações importantes, incluindo:
- O tamanho da tabela após a limpeza, por exemplo:
  ```
  a tabela arquivo1.csv do TRT01 tem (100, 5)
  ```
- Mensagens de erro, caso algum arquivo não seja processado corretamente, por exemplo:
  ```
  Erro ao processar arquivo1.csv: [Descrição do erro]
  ```

## Tratamento de Erros

O script lida com os seguintes erros:
1. **Arquivo não encontrado**: Exibe uma mensagem e continua o processamento.
2. **Erro ao carregar ou salvar o arquivo**: Registra a exceção no logger e continua o processamento dos demais arquivos.

---
# Limpadores - Módulo limpador

Este script realiza uma série de processos de correção e limpeza de dados em arquivos CSV organizados por diferentes categorias de informações legais. O script utiliza a classe `CorretorGeral` para aplicar correções específicas para cada tipo de dado, garantindo que os arquivos estejam devidamente tratados e prontos para utilização em bancos de dados ou outras aplicações.

### Função `limpadores(root, trt)`

Esta função é responsável por processar arquivos de diferentes categorias:

1. **Parte**:
   - `tipo_parte.csv`: Corrige tipos de parte.
   - `parte.csv`: Corrige dados de partes.
   - `processo_parte.csv`: Corrige o relacionamento entre processos e partes.
   - `parte_documento.csv`: Corrige documentos relacionados às partes.
   - `documentos.csv`: Corrige informações gerais de documentos.

2. **Assuntos**:
   - `processo_assunto.csv`: Corrige dados relacionados a assuntos de processos.

3. **Processos**:
   - `processo.csv`: Corrige informações de processos.
   - `competencia.csv`: Corrige informações de competência dos processos.
   - `orgao_julgador.csv`: Corrige dados de órgãos julgadores.
   - `orgao_julgador_local.csv`: Corrige dados de órgãos julgadores locais.
   - `orgao_julgador_colegiado.csv`: Corrige dados de órgãos julgadores colegiados.

4. **Distribuições**:
   - `distribuicoes_processos.csv` e `distribuicoes_processos2.csv`: Corrige informações de distribuições de processos e gera um arquivo consolidado (`orgao_julgador_banco.csv`).

5. **Relacionamentos**:
   - `relacionamentos.csv`: Corrige relacionamentos entre processos e gera arquivos corrigidos, incluindo informações consolidadas em `processo_banco.csv`.

6. **Movimentos**:
   - `magistrados.csv`: Corrige dados de magistrados.
   - `movimentos.csv`: Corrige informações de movimentos processuais, gerando o arquivo consolidado `movimentos_banco.csv`. Também executa o mapeamento de documentos relacionados aos movimentos (`run_mov_doc_map`).

## Dependências

- Classe `CorretorGeral`: Responsável por realizar as correções específicas de cada arquivo.
- Função `run_mov_doc_map`: Realiza o mapeamento de documentos relacionados a movimentos.

## Como Utilizar

1. Certifique-se de que os arquivos estejam organizados nos seguintes diretórios:
   - `parte`
   - `assuntos`
   - `dados_processo`
   - `distribuicoes`
   - `relacionamentos`
   - `movimentos`

2. Execute a função `limpadores` passando:
   - `root`: Caminho raiz onde estão os arquivos.
   - `trt`: Identificação do Tribunal Regional do Trabalho (TRT).

Exemplo:
```
from limpadores import limpadores

root = "/caminho/para/arquivos"
trt = "TRT01"
limpadores(root, trt)
```

## Logs e Erros

- O script registra informações de progresso e erros encontrados durante o processamento.
- Certifique-se de que o logger esteja configurado corretamente no ambiente de execução.

## Estrutura de Saída

Os arquivos corrigidos são salvos nos mesmos diretórios de origem, com modificações aplicadas conforme as regras de correção de cada módulo.

---
# Limpadores - Módulo `movimento_map_parte`

Este módulo faz parte do conjunto de scripts responsáveis por corrigir, tratar e integrar dados de diferentes fontes em formato CSV relacionados a processos judiciais.

## Descrição do Script `movimento_map_parte.py`

O script `movimento_map_parte.py` é utilizado para tratar e integrar informações relacionadas aos movimentos de processos e documentos associados. Ele executa operações de carregamento, limpeza e integração de dados com o objetivo de criar um conjunto de dados unificado para análise e processamento posterior.

### Estrutura do Script

1. **Função `carrega_base`**  
   Responsável por carregar e combinar informações das seguintes tabelas:
   - `processo_parte.csv`
   - `parte.csv`
   - `parte_documento.csv`
   - `documentos_banco.csv`
   
   Após o carregamento, a função realiza merges para associar partes a documentos e filtra apenas documentos do tipo específico (5 e 6). Retorna um DataFrame consolidado.

2. **Função `carrega_doc`**  
   - Recebe os dados parciais resultantes da função `carrega_base` e realiza a integração com informações de `docs.csv`.
   - Realiza duas rodadas de matching:
     1. Com base nos campos `id_processo` e `nome_parte`.
     2. Com base nos campos `id_processo` e `nr` (número do documento).
   - Gera um arquivo `integracao_mov.csv` contendo os movimentos alinhados.

3. **Função `conectar_mov`**  
   - Realiza a integração entre os movimentos do arquivo principal de saída (`movimentos_banco.csv`) e o arquivo de integração de movimentos (`integracao_mov.csv`).
   - Gera uma nova versão do arquivo principal corrigida e integrada.

4. **Função `run_mov_doc_map`**  
   - Define os caminhos dos arquivos de entrada e saída, organizados pelo tribunal (`trt`).
   - Executa as etapas em sequência:
     1. Carregamento e integração inicial (`carrega_base`).
     2. Integração de documentos (`carrega_doc`).
     3. Conexão final entre movimentos (`conectar_mov`).

### Caminhos de Arquivos Utilizados
Os arquivos de entrada e saída são organizados no diretório `../csv/<TRT>`, onde `<TRT>` é o código do tribunal específico.  
Arquivos manipulados incluem:
- `parte/processo_parte.csv`
- `parte/parte.csv`
- `parte/parte_documento.csv`
- `parte/documentos_banco.csv`
- `movimentos/docs.csv`
- `movimentos/integracao_mov.csv`
- `movimentos/movimentos_banco.csv` (arquivo principal corrigido).

### Exemplo de Execução
A função principal do script é chamada como parte do fluxo dos limpadores:
```
from src.Tratadores.limpadores.movimento_map_parte import run_mov_doc_map

output_path = '../csv/TRT1/movimentos/movimentos_banco.csv'
run_mov_doc_map(output_path, trt="TRT1")
```

### Resultado
Após a execução, os dados processados e integrados estarão disponíveis nos seguintes arquivos:
- `../csv/<TRT>/movimentos/movimentos_banco.csv`: Arquivo principal corrigido.
- `../csv/<TRT>/movimentos/integracao_mov.csv`: Arquivo de integração de movimentos.
# ferramentas Uteis

## correção Json
O objetivo desse script é passar o json como texto e por meio de um regex concertar caso tenha alguma incosistencia 

### Aplicação

````python
# coding: latin-1
import re
def concerta_json(c):
    with open(c, 'r', encoding='latin-1', errors='ignore') as file:
        t = file.read()
        t = re.sub(r'#escape', '', t)
        t = re.sub(r'#escape,"fisica"','","fisica"', t)
        t = re.sub(r'"nome":\[', '"nome":"[', t)
        t = re.sub(r'"nomeFantasia":\[', '"nomeFantasia":"[', t)
        t = re.sub(r'\],"fisica"', ']","fisica"', t)
        t = re.sub(r'\],"dataAbertura"', ']","dataAbertura"', t)
        t = re.sub(r'"DETRAN],', r'"DETRAN",', t)
        t = re.sub(r':\[DETRAN"', ':"DETRAN"', t)
        t = re.sub(r'":"SSP],', '":"SSP",', t)
        t = re.sub(r'"m],"', '"m","', t)
        t = re.sub(r'#escape,"', '","', t)
        t = re.sub(r'],"complementos"',']","complementos"', t)
        t = re.sub(r'],"tabelado"',']","tabelado"', t)
        t = re.sub(r'"numero":\[', '"numero":"', t)
    return t

````
- c = é o caminho do arquivo
- ele é lido e analisado
- retorna uma texto estruturado

**NOTA** FORAM RECUPERADOS CERCA DE 20 MIL PARTES com as atualizações do arquivo de concertar_json

## correção StringUtil

1. Esse mtodo possui por 4 filtros
   - remove_acento
   - corrigir_caracteres_especiais
   - extrair_numeros
   - parse_date

### aplicação
A função remover acento entra com o texto, esse texto é processado pelo caracteres especiais e por fim passa pelo mapa 
de remoção dos acentos, foram testdas outras formas, porém essa é a que se mostrou mais eficiente, pelo fato de ter arquivos em dois tipos, latin1 e utf-8 misturados.
````python
import re
import unicodedata

def corrigir_caracteres_especiais(texto):
    texto_corrigido = unicodedata.normalize('NFKD', texto).encode('ascii', 'ignore').decode('utf-8', errors="ignore")
    return texto_corrigido
def remove_acento(texto: str) -> str:
    if texto != None:
        acentos = {
            'á': 'a', 'à': 'a', 'â': 'a', 'ã': 'a', 'ä': 'a', 'ª': 'a',
            'Á': 'A', 'À': 'A', 'Â': 'A', 'Ã': 'A', 'Ä': 'A',
            'é': 'e', 'è': 'e', 'ê': 'e', 'ë': 'e',
            'É': 'E', 'È': 'E', 'Ê': 'E', 'Ë': 'E',
            'í': 'i', 'ì': 'i', 'î': 'i', 'ï': 'i',
            'Í': 'I', 'Ì': 'I', 'Î': 'I', 'Ï': 'I',
            'ó': 'o', 'ò': 'o', 'ô': 'o', 'õ': 'o', 'ö': 'o', 'º': 'o',
            'Ó': 'O', 'Ò': 'O', 'Ô': 'O', 'Õ': 'O', 'Ö': 'O',
            'ú': 'u', 'ù': 'u', 'û': 'u', 'ü': 'u',
            'Ú': 'U', 'Ù': 'U', 'Û': 'U', 'Ü': 'U',
            'ç': 'c', 'Ç': 'C'
        }
        padrao = re.compile('|'.join(map(re.escape, acentos)))
        texto = corrigir_caracteres_especiais(texto)
        texto_sem_acento = padrao.sub(lambda match: acentos[match.group(0)], texto)
        texto_sem_acento = re.sub(r'\s+', ' ', texto_sem_acento)
        return texto_sem_acento
    else:
        return texto
````

A função extrair numeros, remove do texto qualquer letra e deixando somente numeros e retorna como texto
````python
import re
def extrair_numeros(texto):
    return str(''.join(re.findall(r'\d+', texto)))
````

A função parse_date, entra com uma data e rotorna ela somente com ano, mes e dia no formato ('%Y-%m-%d'), caso a data esteja invalida ele retorna um None
````python
import pandas as pd
def parse_date(date_str):
    try:
        return pd.to_datetime(date_str).strftime('%Y-%m-%d') if date_str else None
    except:
        return None
````
---
# DevOps Módulo de Verificação e Processamento

Este módulo contém funções que auxiliam na verificação de status de processamento, limpeza e upload de arquivos relacionados aos tribunais regionais do trabalho (TRTs) e outras entidades, como o TST. As funções têm como objetivo organizar e monitorar o pipeline de processamento, garantindo que apenas os dados necessários sejam manipulados.  

#### Principais Funções:
1. **`verifica_processados`**  
   - Identifica os arquivos já processados e retorna a lista de arquivos que ainda precisam ser processados.  
   - Garante que o diretório e o arquivo de controle de processados existam, criando-os caso necessário.  

2. **`verifica_upload`**  
   - Valida o status de upload de arquivos específicos para o banco de dados.  
   - Verifica colunas específicas de um DataFrame para identificar se há pendências.  

3. **`verifica_limpeza`**  
   - Avalia o status de limpeza de dados para um determinado TRT, verificando se as etapas foram concluídas ou se existem dados pendentes.  

4. **`verifica_banco`**  
   - Confirma se os dados necessários estão presentes no banco de dados para um TRT específico.  

5. **`verifica`**  
   - Verifica se uma célula em uma coluna específica contém o valor "feito" ou está vazia, monitorando o status de execução de tarefas.  

6. **`go`**  
   - Configura o nome do TRT e o grau de jurisdição com base nos parâmetros de entrada, incluindo suporte para o TST.

--- 

## Validadores CPF, CNPJ, TE
foi usado a matemática de referencia de calculo, em que primeiro preenche com zero a esquerda caso falte no tamanho da entrada
depois disso é processado pelo validador

- referencia [CPF](https://calculadoradev.com.br/validadores/cpf)
- referencia [CNPJ](https://calculadoradev.com.br/validadores/cnpj)
- referencia [TE](https://clubes.obmep.org.br/blog/a-matematica-nos-documentos-titulo-de-eleitor/)

---

# Ferramenta para enriquecimento de dados das partes sem genero
### Consulta ao Banco de Dados
O código executa a seguinte query para extrair os dados:
```sql
SELECT pessoa_juridica, id_genero FROM CODEX_PRODUCAO_TST.dbo.parte
```
Alternativamente, os dados podem ser lidos a partir de um arquivo Parquet previamente salvo.

## Fluxo de Execução
1. **Extração de Dados**: Consulta SQL para extrair nomes e gêneros do banco.
2. **Filtragem e Processamento**: Elimina duplicatas e extrai o primeiro nome.
3. **Cálculo de Frequência**: Determina a taxa de ocorrência de cada nome dentro dos gêneros.
4. **Filtragem por Significância**: Mantém apenas nomes com alta taxa de associação a um gênero.
5. **Atualização do Banco**: Aplica os gêneros identificados aos registros no banco de dados.

## Funções Implementadas

### `att_base(query)`
Executa uma consulta SQL para atualizar o banco de dados.
- **Parâmetros:**
  - `query` (str): Comando SQL a ser executado.
- **Retorno:** Nenhum.

### `get_df(query, base)`
Executa uma consulta SQL e salva o resultado em formato Parquet.
- **Parâmetros:**
  - `query` (str): Consulta SQL.
  - `base` (str): Nome da base de saída.
- **Retorno:** Nenhum.

### `ler_df(base)`
Lê um arquivo Parquet de uma consulta anterior.
- **Parâmetros:**
  - `base` (str): Nome base do arquivo Parquet.
- **Retorno:** DataFrame lido.

### `pega_dado(base)`
Elimina duplicatas e extrai o primeiro nome.
- **Parâmetros:**
  - `base` (str): Nome base do arquivo Parquet.
- **Retorno:** Nenhum.

### `manipula_dado(base)`
Calcula a frequência de gênero para cada nome e salva os resultados.
- **Parâmetros:**
  - `base` (str): Nome base dos arquivos.
- **Retorno:** Nenhum.

**Fórmula utilizada:**
```Latex
taxa = (frequência do nome no gênero) / (frequência total do nome)
```

### `estuda_gen(base)`
Filtra nomes com alta taxa de ocorrência em um gênero.
- **Parâmetros:**
  - `base` (str): Nome base dos arquivos.
- **Retorno:** Nenhum.

### `atualiza_base(base)`
Atualiza a base de dados aplicando os gêneros identificados.
- **Parâmetros:**
  - `base` (str): Nome base da tabela.
- **Retorno:** Nenhum.

## Execução do Script
Ao executar o script, os passos serão realizados automaticamente para a base CODEX:
```
if __name__ == "__main__":
    base = 'CODEX'
    query = """
    SELECT nome, id_genero
    FROM CODEX_PRODUCAO_TST.dbo.parte p
    WHERE p.pessoa_juridica = 0 AND controle_genero IS NULL
    """

    get_df(query, base)
    pega_dado(base)
    manipula_dado(base)
    estuda_gen(base)
    atualiza_base(base)
```

## Estrutura de Saída
- Arquivos intermediários em `input_data/`:
  - `consulta_{base}.parquet`
  - `filtrado_{base}.parquet`
- Arquivos de saída em `output_data/`:
  - `frequencia_{base}.csv`
  - `saida_banco_{base}.csv`


### Cálculos Realizados
1. **Contagem total de linhas**
2. **Contagem de registros com `pessoa_juridica = 0` e `pessoa_juridica = 1`**
3. **Contagem de `id_genero = 1`, `id_genero = 2`,`id_genero = 0` e `id_genero = NULL` dentro de `pessoa_juridica = 1`**
4. **Filtragem do subconjunto onde `pessoa_juridica = 0`**
5. **Contagem de `id_genero = 1`, `id_genero = 2` e `id_genero = NULL` dentro de `pessoa_juridica = 0`**
6. **Cálculo da representatividade percentual de `id_genero` dentro do grupo `pessoa_juridica = 0`**

### Resultados
| Descrição             | Quantidade | Porcentagem |
|-----------------------|------------|-------------|
| Total de Linhas       | 37497154   | 100.0%      |
| pessoa_juridica = 1   | 7404131    | 19.75%      |
| pj = 1 (pj=1)         | 99776      | 0.27%       |
| pj = 2 (pj=1)         | 17606      | 0.05%       |
| pj = 0 (pj=1)         | 6204729    | 16.55%      |
| pj =  null (pj=1)     | 1082020    | 2.89%       |
| pessoa_juridica = 0   | 30093023   | 80.25%      |
| genero = 1 (pj=0)     | 18610467   | 49.63%      |
| genero = 2 (pj=0)     | 11170179   | 29.79%      |
| genero =  null (pj=0) | 312377     | 0.83%       |

A porcentagem de `genero = 1`, `genero = 2` e `genero = NULL` foi recalculada considerando apenas os registros onde `pessoa_juridica = 0`.

**NOTA**: 
- Os existem muitas inconsistencias em preenchimento das partes, o que acarreta erros, a seguir exemplos de nomes adicionados como pessoa fisica
  - Parte cadastrada equivocadamente,
  - Juiz,
  - vara do trabalho,
  - Oficio de Registro de Imoveis de Cascavel,
  - CIRETRAN,
  - POLACIA MILITAR DE SAO MIGUEL DO IGUAÇU,
  - Confederacao Nacional dos Trabalhadores No Ramo Financeiro

---

## Autor
- Desenvolvido por [Jefferson dos Anjos Bolsista IPEA](jefferson.anjos@ipea.gov.br), [Alexandre Samy de Castro Técnico de planejamento de pesquisa do IPEA](alexandre.castro@ipea.gov.br) 

---
