### Upload data ###

eggnumberdata<-read.csv(file.choose())
eggdata<-read.csv(file.choose())
hatchlingdata<-read.csv(file.choose())
prophatched<-read.csv(file.choose())	


### Install libraries ###

library(glmmTMB)
library(MuMIn)
library(ggplot2)
library(dplyr)
library(tidyr)


### Designate variables as factors ###

eggnumberdata$motherID <- as.factor(eggnumberdata$motherID)
eggnumberdata$Reproduction <- as.factor(eggnumberdata$Reproduction)
eggnumberdata$Diet <- as.factor(eggnumberdata$Diet)
eggnumberdata$Genotype <- as.factor(eggnumberdata$Genotype)
eggnumberdata$Order <- as.factor(eggnumberdata$Order)

eggdata$motherID <- as.factor(eggdata$motherID)
eggdata$Reproduction <- as.factor(eggdata$Reproduction)
eggdata$Diet <- as.factor(eggdata$Diet)
eggdata$Genotype <- as.factor(eggdata$Genotype)
eggdata$Order <- as.factor(eggdata$Order)
eggdata$Treatment <- as.factor(eggdata$Treatment)

hatchlingdata$motherID <- as.factor(hatchlingdata$motherID)
hatchlingdata$Reproduction <- as.factor(hatchlingdata$Reproduction)
hatchlingdata$Diet <- as.factor(hatchlingdata$Diet)
hatchlingdata$Genotype <- as.factor(hatchlingdata$Genotype)
hatchlingdata$Order <- as.factor(hatchlingdata$Order)
hatchlingdata$Treatment <- as.factor(hatchlingdata$Treatment)
hatchlingdata$Diet.Genotype <- as.factor(hatchlingdata$Diet.Genotype)

prophatched$motherID <- as.factor(prophatched$motherID)
prophatched$Reproduction <- as.factor(prophatched$Reproduction)


##############################
### AICc model comparisons ###
##############################

### Number of eggs laid ###

# Fit full model
Eggnumber<-glmmTMB(Numbereggs~Reproduction*
                              Diet*
                              Genotype+
                              Order+                      
                              (1|motherID),family=poisson,data=eggnumberdata,na.action=na.fail)
summary(Eggnumber)


# Check for overdispersion

overdisp_fun <- function(Eggnumber){
    rdf <- df.residual(Eggnumber)
    rp <- residuals(Eggnumber,type="pearson")
    Pearson.chisq <- sum(rp^2)
    prat <- Pearson.chisq/rdf
    pval <- pchisq(Pearson.chisq, df=rdf, lower.tail=FALSE)
    c(chisq=Pearson.chisq,ratio=prat,rdf=rdf,p=pval)}
overdisp_fun (Eggnumber)


# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Eggnumber)
print(r2_values)


# Carry out model comparisons using AICc

Eggnumber_models<-dredge(Eggnumber,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Eggnumber_selected_models <- get.models(Eggnumber_models, subset = delta < 2)
Eggnumber_avg<-model.avg(Eggnumber_selected_models)
Eggnumber_avg_coef_table <- summary(Eggnumber_avg)$coefmat.full
print(Eggnumber_avg)


# Display and save AIC table

print(Eggnumber_models)
Eggnumber_models<- as.data.frame(Eggnumber_models)
write.csv(Eggnumber_models,"Egg_number_AIC-table.csv")


### Egg size ###

# Fit full model

Eggsizemod<-glmmTMB(Eggsize~Reproduction*
                            Diet*
                            Genotype+
                            Order+
                            (1|motherID),data=eggdata,na.action=na.fail)
summary(Eggsizemod)	

# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Eggsizemod)
print(r2_values)


# Carry out model comparisons using AICc

Eggsizemodels<-dredge(Eggsizemod,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Eggsize_selected_models <- get.models(Eggsizemodels, subset = delta < 2)
Eggsize_avg<-model.avg(Eggsize_selected_models)
Eggsize_avg_coef_table <- summary(Eggsize_avg)$coefmat.full
print(Eggsize_avg_coef_table)
print(Eggsize_avg)


# Display and save AIC table

print(Eggsizemodels)
Eggsizemodels<- as.data.frame(Eggsizemodels)
write.csv(Eggsizemodels,"Egg_size_AIC-table.csv")


### Egg developent time ###

# Fit full model

Devtime<-glmmTMB(Timedev~Reproduction*
                         Diet*
                         Genotype+
			 Order+
                        (1|motherID),data=hatchlingdata,na.action=na.fail)
summary(Devtime)


# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Devtime)
print(r2_values)


# Carry out model comparisons using AICc

Devtimemodels<-dredge(Devtime,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Devtime_selected_models <- get.models(Devtimemodels,subset=delta<2)
Devtime_avg<-model.avg(Devtime_selected_models)
Devtime_avg_coef_table <- summary(Devtime_avg)$coefmat.full
print(Devtime_avg_coef_table)
print(Devtime_avg)


# Display and save AIC table

print(Devtimemodels)
Devtimemodels<- as.data.frame(Devtimemodels)
write.csv(Devtimemodels,"Devtime_AIC-table.csv")


### Egg hatching success ###

# Fit full model

Hatching<-glmmTMB(Hatched~Reproduction*
                          Diet*
                          Genotype+
		          Order+
                          (1|motherID),family=binomial,data=eggdata,na.action=na.fail)
summary(Hatching)

# Check for overdispersion

overdisp_fun <- function(Hatching){
    rdf <- df.residual(Hatching)
    rp <- residuals(Hatching,type="pearson")
    Pearson.chisq <- sum(rp^2)
    prat <- Pearson.chisq/rdf
    pval <- pchisq(Pearson.chisq, df=rdf, lower.tail=FALSE)
    c(chisq=Pearson.chisq,ratio=prat,rdf=rdf,p=pval)}
overdisp_fun (Hatching)


# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Hatching)
print(r2_values)

# Carry out model comparisons using AICc

Hatchingmodels<-dredge(Hatching,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Hatchingmodels_selected_models <- get.models(Hatchingmodels,subset=delta<2)
Hatchingmodels_avg<-model.avg(Hatchingmodels_selected_models)
Hatchingmodels_avg_coef_table <- summary(Hatchingmodels_avg)$coefmat.full
print(Hatchingmodels_avg_coef_table)
print(Hatchingmodels_avg)


# Display and save AIC table

print(Hatchingmodels)
Hatchingmodels<- as.data.frame(Hatchingmodels)
write.csv(Hatchingmodels,"Hatching_AIC-table.csv")


### Hatchling body size ###

# Fit full model

Hatchlingsize<-glmmTMB(Hatchlingthorax~Reproduction*
                                    Diet*
                                    Genotype+
					     Order+
                                   (1|motherID),data=hatchlingdata,na.action=na.fail)
summary(Hatchlingsize)


# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Hatchlingsize)
print(r2_values)


# Carry out model comparisons using AICc

Hatchlingsizemodels<-dredge(Hatchlingsize,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Hatchlingsizemodels_selected_models <- get.models(Hatchlingsizemodels,subset=delta<2)
Hatchlingsizemodels_avg<-model.avg(Hatchlingsizemodels_selected_models)
Hatchlingsizemodels_avg_coef_table <- summary(Hatchlingsizemodels_avg)$coefmat.full
print(Hatchlingsizemodels_avg_coef_table)
print(Hatchlingsizemodels_avg)


# Display and save AIC table

print(Hatchlingsizemodels)
Hatchlingsizemodels<- as.data.frame(Hatchlingsizemodels)
write.csv(Hatchlingsizemodels,"Hatchling_size_AIC-table.csv")


### Prothoracic gland size ###

# Fit full model

Model_gland<-glmmTMB(Glandarea~Reproduction*
                            Diet*
                            Genotype+
                            Hatchlingthorax+
                            Order+
                            (1|motherID),data=hatchlingdata,na.action=na.fail)
summary(Model_gland)


# Calculate conditional and marginal R2 values

r2_values <- r.squaredGLMM(Model_gland)
print(r2_values)



# Carry out model comparisons using AICc

Glandmodels<-dredge(Model_gland,evaluate=TRUE,trace=TRUE)


# Carry out model averaging and display model-averaged parameters

Gland_selected_models <- get.models(Glandmodels,subset=delta<2)
Gland_selected_models_avg<-model.avg(Gland_selected_models)
Gland_selected_models_avg_coef_table <- summary(Gland_selected_models_avg)$coefmat.full
print(Gland_selected_models_avg_coef_table)
print(Gland_selected_models_avg)


# Display and save AIC table

print(Glandmodels)
Glandmodels <- as.data.frame(Glandmodels)
write.csv(Glandmodels,"Gland_size_AIC-table.csv")

#################
##### Plots #####
#################


# Number of eggs laid

Eggnumberplot <- ggplot(data = eggnumberdata, aes(x = Diet, y = Numbereggs, fill = Diet)) +
  geom_boxplot(width = 0.5, position = position_dodge(width = 0.9), alpha = 0.6) +
  geom_point(size = 3, color = "lightblue", position = position_jitter(width = 0.15, height = 0)) +
  labs(x = "Diet", y = "Number of eggs laid") +
  scale_fill_manual(values = c("red","blue")) +
  theme_minimal() + 
  theme(
  panel.border = element_rect(color = "black", fill = NA, size = 1),  
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14))
Eggnumberplot


# Egg size

Eggsizeplot <- ggplot(data = eggdata, aes(x = Diet, y = Eggsize)) +
  geom_boxplot(aes(fill = Treatment), position = position_dodge(width = 0.8), 
               width = 0.6, alpha = 0.6, outlier.shape = NA) +
  geom_point(aes(color = Treatment), 
             position = position_jitterdodge(jitter.width = 0.2, dodge.width = 0.8), 
             size = 2, alpha = 0.8) +
  labs(x = "Diet", y = "Egg size") +
  scale_fill_manual(values = c("red","blue","red","blue")) +
  scale_color_manual(values = c("black","black","grey","grey")) +
  theme_classic() +
  theme(
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14),
    legend.title = element_text(size = 16),
    legend.text = element_text(size = 14),
    panel.border = element_rect(color = "black", fill = NA, size = 1),
    panel.background = element_blank(), 
    panel.grid = element_blank()
  )
Eggsizeplot


# Development time

Devtimeplot <- ggplot(data = hatchlingdata, aes(x = Diet, y = Timedev)) +
  geom_boxplot(aes(fill = Treatment), position = position_dodge(width = 0.8), 
               width = 0.6, alpha = 0.6, outlier.shape = NA) +
  geom_point(aes(color = Treatment), 
             position = position_jitterdodge(jitter.width = 0.2, dodge.width = 0.8), 
             size = 2, alpha = 0.8) +
  labs(x = "Diet", y = "Development time (days)") +
  scale_fill_manual(values = c("red","blue","red","blue")) +
  scale_color_manual(values = c("black","black","grey","grey")) +
  theme_classic() +
  theme(
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14),
    legend.title = element_text(size = 16),
    legend.text = element_text(size = 14),
    panel.border = element_rect(color = "black", fill = NA, size = 1),
    panel.background = element_blank(),
  )
Devtimeplot


# Proportion of eggs that hatched

Hatchplot <- ggplot(data = prophatched, aes(x = Reproduction, y = Prophatched, fill = Reproduction)) +
  geom_boxplot(width = 0.5, position = position_dodge(width = 0.9), alpha = 0.6) +
  geom_point(aes(color = Reproduction), size = 3, position = position_jitter(width = 0.15, height = 0)) +
  labs(x = "Diet", y = "Number of eggs laid") +
  scale_fill_manual(values = c("black","grey")) +
  scale_color_manual(values = c("black","grey")) +
  theme_minimal() + 
  theme(
  panel.border = element_rect(color = "black", fill = NA, size = 1),  
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14))
Hatchplot 


# Hatchling body size

Bodysizeplot <- ggplot(data = hatchlingdata, aes(x = Diet, y = Hatchlingthorax)) +
  geom_boxplot(aes(fill = Diet.Genotype), position = position_dodge(width = 0.8), 
               width = 0.6, alpha = 0.6, outlier.shape = NA) +
  geom_point(aes(color = Diet.Genotype), 
             position = position_jitterdodge(jitter.width = 0.2, dodge.width = 0.8), 
             size = 2, alpha = 0.8) +
  labs(x = "Diet", y = "Hatchling thorax length (mm)") +
  scale_fill_manual(values = c("red","red","blue","blue")) +
  scale_color_manual(values = c("green","purple","green","purple")) +
  theme_classic() +
  theme(
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14),
    legend.title = element_text(size = 16),
    legend.text = element_text(size = 14),
    panel.border = element_rect(color = "black", fill = NA, size = 1),  # Adds a black border around the plot
    panel.background = element_blank(),
    panel.grid = element_blank()
  )
Bodysizeplot 


# Prothoracic gland relative size

Glandsizeplot<- ggplot(data = hatchlingdata, aes(x = Diet, y = Logrelativeglandarea)) +
  geom_boxplot(aes(fill = Treatment), position = position_dodge(width = 0.8), 
               width = 0.6, alpha = 0.6, outlier.shape = NA) +
  geom_point(aes(color = Treatment), 
             position = position_jitterdodge(jitter.width = 0.2, dodge.width = 0.8), 
             size = 2, alpha = 0.8) +
  labs(x = "Diet", y = "Log relative prothoracic gland size") +
  scale_fill_manual(values = c("red","blue","red","blue")) +
  scale_color_manual(values = c("black","black","grey","grey")) +
  theme_classic()+
  theme(
    axis.title.x = element_text(size = 18), 
    axis.title.y = element_text(size = 18),
    axis.text.x = element_text(size = 14),
    axis.text.y = element_text(size = 14),
    legend.title = element_text(size = 16),
    legend.text = element_text(size = 14),
    panel.border = element_rect(color = "black", fill = NA, size = 1),  # Adds a black border around the plot
    panel.background = element_blank(),
    panel.grid = element_blank()
  )
Glandsizeplot

############################




