#include <iostream>
#include <sstream>
#include <typeinfo>
#define _USE_MATH_DEFINES
#include <cmath>
#include <fstream>
#include <valarray>
#include <string.h>
#include <Vars.h>
#include <makeDicts.h>

//template <typename T>
std::string to_string_with_precision(double a_value, int n)
{
	std::ostringstream out;
	out.precision(n);
	out << std::fixed << a_value;
	return std::move(out).str();
}

std::string convertToString_wBrackets(std::valarray<double> x, std::valarray<double> z, double y) 
{
	std::string tempx, tempz;
	std::string OUT = "("; // start with opening bracket
	for (int i = 0; i < x.size(); i++) {
		tempx = to_string_with_precision(x[i],10);
		tempz = to_string_with_precision(z[i],10);
		OUT.append("("); OUT.append(tempx); OUT.append(" "); OUT.append(tempz); OUT.append(" "); OUT.append(std::to_string(y)); OUT.append(") ");
	}
	OUT.append(")");
	return OUT;
}

std::string convert_valArray_ToString(std::valarray<double> x) 
{
	std::string tempx, OUT;
	for (int i = 0; i < x.size(); i++) {
		OUT.append(to_string_with_precision(x[i],10)); OUT.append(" "); 
	}
	return OUT;
}


std::valarray<double> make_xGrid(int length, double left, double right) 
{
	std::valarray<double> x_grid(length);
	double dx = (right-left) / (length); 
	for (int i = 0; i < length; i++) {
		x_grid[i] = left+dx/2 + dx*i;
	}
	return x_grid;
}

std::valarray<double> make_xGrid_staggered(int length, double left, double right) 
{
	std::valarray<double> x_grid(length);
	double dx = (right-left) / (length); 
	for (int i = 0; i < length; i++) {
		x_grid[i] = left + dx*(i+1);
	}
	return x_grid;
}

void print_doubleValArray (std::valarray<double> A) 
{
	for (double x : A) {
//		std::cout << std::scientific << x << " ";
		std::cout << x << " ";
	}
	std::cout << std::endl;
	return;
} 

void makeBlockMeshDictFile(Vars v, std::valarray<double> x_grid, std::valarray<double> h, bool CD_switch)
{
	std::string path_to_src = "../FOAM_funcs_wesselut/";
	// make vector of bed, consistent with edge file OpenFOAM			
	std::string bedProfile_front = convertToString_wBrackets(x_grid, h, 0);
	std::string bedProfile_back = convertToString_wBrackets(x_grid, h, v.domain_width);
	
	// make scale, vertices, blocks
	std::string vertices_fileName = path_to_src + "textFiles_blockMeshDict/vertices_blocks.txt";
	std::ofstream vertices_blocks;
	
	double z_end; // this is the topography at the domain's edge (at either side)
	if (CD_switch) {
		z_end = h[v.Nx-1]; 
	} else {		
		z_end = (h[v.Nx-1] + h[0])/2; 
	}

	vertices_blocks.open (vertices_fileName);
	vertices_blocks << "scale   " << std::to_string(v.scale) << ";\n \n"
			<< "vertices \n( \n" 
			<< "(0   " << to_string_with_precision(z_end,10) << "   0) \n"
			<< "(" << std::to_string(v.x_max) << "   " << to_string_with_precision(z_end,10) << "   0) \n"
			<< "(" << std::to_string(v.x_max) << "   " << to_string_with_precision(v.depth,10) << "   0) \n"
			<< "(0   " << to_string_with_precision(v.depth,10) << "   0) \n"
			<< "(0   " << to_string_with_precision(z_end,10) << "   "<< std::to_string(v.domain_width) <<")\n"
			<< "(" << std::to_string(v.x_max) << "   " << to_string_with_precision(z_end,10) << "   "<< std::to_string(v.domain_width) <<") \n"
			<< "(" << std::to_string(v.x_max) << "   " << to_string_with_precision(v.depth,10) << "   "<< std::to_string(v.domain_width) <<") \n"
			<< "(0   " << to_string_with_precision(v.depth,10) << "   "<< std::to_string(v.domain_width) <<") \n"
			<< "); \n \n"
			<< "blocks \n(\n"
			<< "    hex (0 1 2 3 4 5 6 7) (" << std::to_string(v.Nx) << " " << std::to_string(v.Nz) << " 1) simpleGrading (1 " << std::to_string(v.Meshgrading_vertical) << " 1)\n"
			<< ");\n\n";

	vertices_blocks.close();
		
	// make edge file
	std::ofstream edgeFile;
	edgeFile.open (path_to_src + "textFiles_blockMeshDict/edgeFile.txt");
	edgeFile << "edges\n" << "(\n" << "    polyLine 0 1 "  << bedProfile_front << "\n"
	 				  "    polyLine 4 5 "  << bedProfile_back  << "\n"
	"); \n \n";
	edgeFile.close();
	
	// combine files
	std::ifstream if_header(path_to_src + "textFiles_blockMeshDict/HeaderOpenFOAM.txt", std::ios_base::binary);
	std::ifstream if_verticesBlocks(path_to_src + "textFiles_blockMeshDict/vertices_blocks.txt", std::ios_base::binary);
	std::ifstream if_edgeFile(path_to_src + "textFiles_blockMeshDict/edgeFile.txt", std::ios_base::binary);
	std::ifstream if_boundaries(path_to_src + "textFiles_blockMeshDict/boundaries.txt", std::ios_base::binary);
	std::ofstream of_c("system/blockMeshDict", std::ios_base::binary);
	of_c << if_header.rdbuf() << if_verticesBlocks.rdbuf() << if_edgeFile.rdbuf() << if_boundaries.rdbuf();
}

void makeControlDictFile(Vars v)
{
	std::string path_to_src = "../FOAM_funcs_wesselut/";
		
	std::string controlDict_tEnd_dt_fileName = path_to_src + "textFiles_controlDict/controlDict_tEnd_dt.txt";
	std::ofstream controlDict_tEnd_dt;
	
	controlDict_tEnd_dt.open (controlDict_tEnd_dt_fileName);
	controlDict_tEnd_dt << "endTime         " << std::to_string(v.T_end_hyd) << ";\n \n"
			    << "deltaT          " << std::to_string(v.dt_hyd) << ";\n" ;
			
	controlDict_tEnd_dt.close();
			
	// combine files
	std::ifstream if_controlDict_1(path_to_src + "textFiles_controlDict/controlDict_1.txt", std::ios_base::binary);
	std::ifstream if_controlDict_tEnd_dt(path_to_src + "textFiles_controlDict/controlDict_tEnd_dt.txt", std::ios_base::binary);
	std::ifstream if_controlDict_2(path_to_src + "textFiles_controlDict/controlDict_2.txt", std::ios_base::binary);
	std::ofstream of_c("system/controlDict", std::ios_base::binary);
	of_c << if_controlDict_1.rdbuf() << if_controlDict_tEnd_dt.rdbuf() << if_controlDict_2.rdbuf() ;
}

void make_fvOptions_init(double Ux)
{
	std::string path_to_src = "../FOAM_funcs_wesselut/";
		
	std::string fvOptions_begin_fileName = path_to_src + "textFiles_fvOptions/fvOptions_begin.txt";
	std::ofstream fvOptions_begin;
	
	fvOptions_begin.open (fvOptions_begin_fileName);
	fvOptions_begin << "	    Ubar            (" << to_string_with_precision(Ux,10) << " 0 0);\n";
			
	fvOptions_begin.close();
			
	// combine files
	std::ifstream if_controlDict_1(path_to_src + "textFiles_fvOptions/fvOptions_1.txt", std::ios_base::binary);
	std::ifstream if_controlDict_tEnd_dt(path_to_src + "textFiles_fvOptions/fvOptions_begin.txt", std::ios_base::binary);
	std::ifstream if_controlDict_2(path_to_src + "textFiles_fvOptions/fvOptions_2.txt", std::ios_base::binary);
	std::ofstream of_c("constant/fvOptions", std::ios_base::binary);
	of_c << if_controlDict_1.rdbuf() << if_controlDict_tEnd_dt.rdbuf() << if_controlDict_2.rdbuf() ;
}

void make_fvOptions_afterInit(double momSource)
{

	std::string path_to_src = "../FOAM_funcs_wesselut/";
	std::string command_copy_fvOptions = "cp " + path_to_src + "textFiles_fvOptions/fvOptions_notInit constant/fvOptions";
	std::system(command_copy_fvOptions.c_str());
	
	
	std::string acceleration_terms_fileName = "constant/acceleration-terms.dat";
	std::ofstream acceleration_terms;
	
	acceleration_terms.open (acceleration_terms_fileName);
	acceleration_terms << "//     t      acc    omega   dOmegadt \n" 
			<< "(\n"
			<< "        (0.0       (("<< to_string_with_precision(momSource,10) << " 0 0) (0 0 0) (0 0 0))) \n"
			<< "        (100000.0  (("<< to_string_with_precision(momSource,10) << " 0 0) (0 0 0) (0 0 0))) \n"
			<< "); \n"
			<< "// here: t = time [s] acc = acceleration vector [m/s2] omega = rotation vector [rad/s] dOmegadt = angular acceleration [rad/s2]";
			
	acceleration_terms.close();

}

