#include <iostream>
#include <sys/stat.h>
#include <sstream>
#include <cmath>
#include <fstream>
#include <valarray>
#include <filesystem>
#include <unistd.h>
#include <stdio.h>
#include <limits.h>
#include <string>
#include <iterator>


#include "xtensor/xarray.hpp"
#include "xtensor/xio.hpp"
#include "xtensor/xview.hpp"
#include "xtensor/xbuilder.hpp"
#include "xtensor/xcomplex.hpp"
#include "xtensor.hpp"


#include <FileManagement.h>
using namespace std;

void fileSystem::saveToFile (valarray<double> store_vec) 
{
 	file.open (morphDir+fileName, std::ofstream::out | std::ofstream::app);
	for (int i = 0; i < store_vec.size(); i++) {
		file << store_vec[i] << " ";		
	}
	file << "\n"; 
	file.close ();
}

void fileSystem::saveToFile_double (double store_double) 
{
 	file.open (morphDir+fileName, std::ofstream::out | std::ofstream::app);
	file << store_double << " ";		
	file.close ();
}

void fileSystem::saveToFile_array (xt::xarray<double> store_vec) 
{
 	file.open (morphDir+fileName, std::ofstream::out | std::ofstream::app);
 	for (int j = 0; j < store_vec.shape(0); j++) {
		for (int i = 0; i < store_vec.shape(1); i++) {
			file << store_vec(j,i) << " ";		
		}
 		file << "\n";		
	}
	file << "\n"; 
	file.close ();
}

string LastTime_string (string cwd_string, int skipFirstLetters_fileName) // what is the last time? get all files in cwd, convert to int, find max, convert to string
{
	vector<double> paths_double;
	vector<string> paths_string;
    	for (const auto & entry : std::filesystem::directory_iterator(cwd_string)) 
    	{
		string path_temp = entry.path().string();
		string itemOnly = path_temp.erase(0, cwd_string.size() + 1+ skipFirstLetters_fileName);
		try{ // try to convert to double. If double, store number in "to_double"
		 	double to_double = stod(itemOnly); 
 	    		paths_double.push_back(to_double);
 	    		paths_string.push_back(itemOnly);
		} catch(std::exception& e){} // else do nothing
    	}	
	int LastTime_ind = max_element(paths_double.begin(), paths_double.end()) - paths_double.begin();
	string LastTime_str = paths_string[LastTime_ind];
	return LastTime_str;
}

void restore_fromLast(string LastTime_str)
{
	string copy_from = LastTime_str + "/epsilon " + LastTime_str + "/k " + LastTime_str + "/nut " + LastTime_str + "/omega " + LastTime_str + "/p " + LastTime_str + "/U ";
	string copy_to = "temp_IC";
	string makedir_copyTo_command = "mkdir -p " + copy_to;
	system(makedir_copyTo_command.c_str());
	string copy_command = "cp " + copy_from + copy_to + " 2>/dev/null || :";
	system(copy_command.c_str());
	
	system("./Allclean");
	
	copy_from = copy_to + "/epsilon " + copy_to + "/k " + copy_to + "/nut " + copy_to + "/omega " + copy_to + "/p " + copy_to + "/U ";
	copy_to = "0"; 
	string makedir_0_command = "mkdir -p " + copy_to;
	system(makedir_0_command.c_str());
	copy_command = "cp " + copy_from + copy_to + " 2>/dev/null || :";
	system(copy_command.c_str());
}

void restore_fromLast_tidal(string LastTime_str, bool ebb)
{
	if (ebb) {
		LastTime_str = "ebb/" + LastTime_str;
	} else if (!ebb) {
		LastTime_str = "flood/" + LastTime_str;	
	}	
	string copy_from = LastTime_str + "/epsilon " + LastTime_str + "/k " + LastTime_str + "/nut " + LastTime_str + "/omega " + LastTime_str + "/p " + LastTime_str + "/U ";
	string copy_to = "temp_IC";
	string makedir_copyTo_command = "mkdir -p " + copy_to;
	system(makedir_copyTo_command.c_str());
	string copy_command = "cp " + copy_from + copy_to + " 2>/dev/null || :";
	system(copy_command.c_str());
	
	// empty flood or ebb folder
	string remove_oldFolder = "rm -r " + LastTime_str;
	system(remove_oldFolder.c_str());
	
	system("./Allclean");
	
	copy_from = copy_to + "/epsilon " + copy_to + "/k " + copy_to + "/nut " + copy_to + "/omega " + copy_to + "/p " + copy_to + "/U ";
	copy_to = "0"; 
	string makedir_0_command = "mkdir -p " + copy_to;
	system(makedir_0_command.c_str());
	copy_command = "cp " + copy_from + copy_to + " 2>/dev/null || :";
	system(copy_command.c_str());
}

readFoamFile_tau::readFoamFile_tau( istream &strm ) 
{
   string line;
   int N;

   // Read lines; the while loop will stop when it contains "fixedWalls"
   while ( getline( strm, line ) && line.find( "fixedWalls" ) == string::npos ) ;
   
   getline( strm, line );  getline( strm, line );  getline( strm, line );  // Ignore next three lines
   getline( strm, line );   stringstream( line ) >> N;     // Get the number of data points
   getline( strm, line );                                  // Ignore the next line

   // Loop through the data points, grabbing the vector (U,V,W)   
   char c;
   double u, v, w;
   valarray<double> u_vec (N);
   valarray<double> v_vec (N);
   for ( int i = 0; i < N; i++ )
   {
      getline( strm, line );
      stringstream( line ) >> c >> u >> v >> w;
      u_vec[i] = u;
      v_vec[i] = v;
   }
   U = u_vec;
   V = v_vec;
}

double readFoamFile_mom ( istream &strm ) 
{
   string line;
   string lostfound;
   double mom;

   // Read lines; the while loop will stop when it contains "fixedWalls"
   while ( getline( strm, line )  && line.find( "gradient" ) == string::npos ) ;
   
   stringstream( line ) >> lostfound >> mom;

   return mom;
}

double readFoamFile_flowRate ( istream &strm ) 
{
   string line;
   string lostfound;
   double flowRate;

   // Read lines; the while loop will stop when it contains "fixedWalls"
   while ( getline( strm, line )  && line.find( "sum(outlet,phi)" ) == string::npos ) ;
   
   stringstream( line ) >> lostfound >> flowRate;
   return flowRate;
}

void makeMorphDir (std::string morphDir) 
{
	string destroyDirCommand = "rm -r " +morphDir;
	string makeDirCommand = "mkdir -p " + morphDir;	
	system(destroyDirCommand.c_str());	
	system(makeDirCommand.c_str());
}


string getCWD () 
{
	char cwd[PATH_MAX];
	getcwd(cwd, sizeof(cwd));
	std::string cwd_string = {cwd};
	return cwd_string;
}


