#include <iostream>
#include <sys/stat.h>
#include <sstream>
#include <cmath>
#include <fstream>
#include <valarray>
#include <filesystem>
#include <unistd.h>
#include <stdio.h>
#include <limits.h>
#include <string>

#include "xtensor/xarray.hpp"
#include "xtensor/xio.hpp"
#include "xtensor/xview.hpp"
#include "xtensor/xbuilder.hpp"
#include "xtensor/xcomplex.hpp"
#include "xtensor.hpp"

#include "xtensor-blas/xblas.hpp"
#include "xtensor-blas/xlapack.hpp"
#include "xtensor-blas/xlinalg.hpp"

#include <Vars.h>
#include <makeDicts.h>
#include <FileManagement.h>
#include <numFuncs.h>

using namespace std;

int main ()
{  
	bool sea = true; bool river = false; bool ebb = false; 
	Vars variables (1,1); // obtain variables from local Vars.cpp file
	valarray<double> x_grid = xGrid_maker (variables, false);	
	double amp = 5;
	double toosteep = 0.466;
	double f_lambda_asymptotic = 0.5;
	int n = 1;
	valarray<double> h = amp * sin (x_grid * 2 * M_PI / variables.x_max);
	
	
//	valarray<double> dhdx = 2 * amp * M_PI / variables.x_max * cos (x_grid * 2 * n * M_PI / variables.x_max);
	valarray<double> dhdx (variables.Nx); 
	double Nx_double = variables.Nx;
	for (double i=0; i < dhdx.size(); i++) {
		dhdx[i] = -0.8 + 1.6/(Nx_double-1) * i;
	}
			
	valarray<double> lambda (variables.Nx);
	cout << "dhdx = " << endl;
	print_doubleValArray(dhdx);		
	cout << endl;

	double lambda_sign_base;// minus one for flood, positive one for ebb
	
	if (river || (sea && ebb)) {
		lambda_sign_base = 1;
	} else if (sea && !ebb) {
		lambda_sign_base = -1;
	}	
	for (int i=1; i <= variables.lambda_Taylor_coefs.size(); i++)
	{ 
		lambda   = lambda + 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(dhdx, i-1) * pow(lambda_sign_base, i+1);
//		print_doubleValArray( 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(dhdx, i-1) * pow(lambda_sign_base, i+1) );
	}
	
	
	
	
//	cout << endl;
	
//	lambda[dhdx > 0.466] = -0.5;	
	cout << endl;
	
	cout << "the old lambda: " << endl;
	print_doubleValArray( lambda );
	cout << endl;	
		
	valarray<bool> steepslopes = dhdx < -toosteep; 
	
	for (int i = 0; i<dhdx.size(); i++) {
		if (!ebb) {
			if(dhdx[i] < -toosteep) {
				lambda[i] = f_lambda_asymptotic / dhdx[i];
				cout << f_lambda_asymptotic / dhdx[i] << " "; 
			}
		}
		else if (ebb) { 
			if(dhdx[i] > toosteep) {
				lambda[i] = -f_lambda_asymptotic / dhdx[i];
				cout << -f_lambda_asymptotic / dhdx[i] << " "; 
			}
		}
	}
	cout << endl;
	cout << "the new lambda: " << endl;	
	print_doubleValArray( lambda );	
	
	return 0;
}
