#include <Vars.h>
#include <math.h>

Vars::Vars (double T_end, double dt) {
	g = 9.81;
	x_min = 0; // default 0
//	x_max = 70;
	x_max = 2000; // domain length in meters
//	Nx = 150; // number of grid points in horizontal direction
	Nx = 1000; 
	Nz = 140; // number of grid points in vertical direction
	domain_width = 0.1;
	depth = 7; // domain height in meters
	scale = 1; // 1 corresponds to meter scale
	Meshgrading_vertical = 50; // Vertical cell grading. See OpenFOAM documentation of BlockMesh for details on this. 
	bedAmp = 0.3; // parameter for initially perturbed bed

	lambda = 1.5; // all variables below with 'lambda' as part of their name relate to the slope-induced sediment transport component. 
	lambda_Taylor_coefs.push_back(-1.732050807568877);
	lambda_Taylor_coefs.push_back(7.0); // oddly enough, the (un?)even coefficients of the Taylor expansion are integers in this case
	lambda_Taylor_coefs.push_back(-36.373066958946424);
	lambda_Taylor_coefs.push_back(249.0);
	lambda_Taylor_coefs.push_back(-2156.403255423252);
	lambda_Taylor_coefs.push_back(22455.0);
	lambda_Taylor_coefs.push_back(-272252.4061877140);	
	lambda_Taylor_coefs.push_back(3770865.0);
	lambda_Taylor_coefs.push_back(-58781967.91634893);
	lambda_Taylor_coefs.push_back(1018232775.0); // n 10

	lambda_Taylor_coefs.push_back(-19399939902.55034); // n 11
	lambda_Taylor_coefs.push_back(403210355625.0); // n 12
	lambda_Taylor_coefs.push_back(-9078950687045.4); // n 13
	lambda_Taylor_coefs.push_back(220154258899575.0); // n 14
	lambda_Taylor_coefs.push_back(-5719775428751049.0); // n 15
		
	a_bs = 2.5; // added slope effect, as in Damveld (2020)
	
	porosity = 0.4;
	
	Ux_start = 0.8; // residual flow at start of simulation
	UM2	 = 0; // tidal M2 velocity amplitude
	Urep_ebb_given = 0.7667; // this variable (and the next) is used if rep velocities are not calculated from Ux_start and UM2
	Urep_fl_given = -0.4113;
	momentumSource_ebb = -1.2238e-4;
	momentumSource_flood = 3.51477e-5;
	momentumSource_river = 0;
	
	omega = 1.405e-4; // M2 tidal frequency

	rho0 = 1000;
	rho_s = 2650;
	nu_w = 1e-6;

	D50 = 0.35e-3; 
	
	D_star = (D50 * pow((rho_s/rho0 - 1) * g / pow(nu_w, 2.0), 1.0/3.0) ); // dimensionless grain size
	if (D_star < 4) {
		theta_crit = 0.24 * pow(D_star, -1.0);
	} else if (D_star < 10) {
		theta_crit = 0.14 * pow(D_star, -0.64);	
	} else if (D_star < 20) {
		theta_crit = 0.04 * pow(D_star, -0.1);	
	} else if (D_star < 150) {
		theta_crit = 0.013 * pow(D_star, 0.29);	
	} else if (D_star >= 150) {
		theta_crit = 0.055;	
	}
	tau_crit = theta_crit * D50 * rho0 * g * (rho_s/rho0 - 1);
			
	a_b = 0.5 * D50 / (tau_crit * pow(rho0, 1.0/2.0)) * pow(D_star, -0.3);
//	a_b = 1.56e-5;
	beta_b = 1.5;	
	dx = (x_max - x_min) / (Nx);
	T_end_hyd = T_end;
	dt_hyd = dt;
}
