#include <iostream>
#include <sys/stat.h>
#include <sstream>
#include <cmath>
#include <complex>
#include <fstream>
#include <valarray>
#include <filesystem>
#include <unistd.h>
#include <stdio.h>
#include <limits.h>
#include <string>

#include "xtensor/xarray.hpp"
#include "xtensor/xio.hpp"
#include "xtensor/xview.hpp"
#include "xtensor/xbuilder.hpp"
#include "xtensor/xcomplex.hpp"
#include "xtensor.hpp"

#include "xtensor-blas/xblas.hpp"
#include "xtensor-blas/xlapack.hpp"
#include "xtensor-blas/xlinalg.hpp"

#include <Vars.h>
#include <makeDicts.h>
#include <FileManagement.h>
#include <numFuncs.h>

using namespace std;

double Urep_calc (double Ures, double UM2, bool ebb)
{
	double phi = asin(Ures/UM2);
	double Urep;
	if (ebb) {
		Urep = 1.0 / pow(6.0*M_PI + 12.0 * phi, 1.0/3.0) * pow(6.0*pow(Ures,3.0)*(M_PI + 2.0*phi) + 9.0*pow(UM2,2.0)*Ures*(M_PI + 2.0*phi) + 2.0*UM2*(11.0*pow(Ures,2.0) + 4.0*pow(UM2,2.0)) * pow(1.0-pow(Ures/UM2,2.0),0.5),1.0/3.0);
	} else { // flood
		complex<double> Urep_1 = 6.0*pow(Ures,3.0)*(M_PI - 2.0*phi) + 9.0*pow(UM2,2.0)*Ures*(M_PI - 2.0*phi) - 2.0*UM2*(11.0*pow(Ures,2.0) + 4.0*pow(UM2,2.0)) * pow(1.0-pow(Ures/UM2,2.0),0.5); 
		complex<double> Urep_c = exp(1i*2.0*M_PI/3.0) / pow(6.0*M_PI - 12.0 * phi, 1.0/3.0) * pow(Urep_1,1.0/3.0);
		Urep = real(Urep_c);
	}	
	return Urep;
}

double tidal_time_calc (double Ures, double UM2, double omega, bool ebb)
{
	double phi = asin(Ures/UM2);
	double t_star;
	if (ebb) {
		t_star = 1 / (2*M_PI) * (M_PI + 2*phi); 
	} else { 
		t_star = 1 / (2*M_PI) * (M_PI - 2*phi); 
	}
	return t_star;
}


int main ()
{    	
	int Nt = 1; 
	bool river = true;
	bool sea = false;
	
	bool tau_crit_bool = false; // false --> tau_crit is not included (i.e. set to zero)
	
	int Nconstituents = 55;// standard is 26 for nonlin runs (with increment=1, startWaveMode=1), 55 for GCs (increment=2, startWaveMode=1)
	int increment = 2; // this determines the stepsize of the wavenumber of initial random topography, i.e. k = (1:increment:Nconstituents) * 2*pi/L
	int startWaveMode = 1;
	
	bool momForcing; if (river) 	 {momForcing	  = true;} else if (sea)  {momForcing      = true;} // if true, initial momentum source is found with velocity, afterwards momentum is kept constant
	bool velocityForcing; if (river) {velocityForcing = false;} else if (sea) {velocityForcing = false;} // if true, velocity is always kept constant (momentum source adapted accordingly)
	bool init_momForcing; if (river) {init_momForcing = false;} else if (sea) {init_momForcing = false;} // if true, an initial momentum source is chosen (defined in Vars.cpp) and kept constant over time
	if (!!momForcing+!!velocityForcing+!!init_momForcing>1) {
		cout << "Choose either momForcing, velocityForcing, or init_momForcing"  << endl;
		return 10;
	}
		
	bool asym_slope; if (river) {asym_slope	= true;} else if (sea) {asym_slope = true;} // slope correction: symmetric version or no?
	bool Urep_calc_bool = true; // if true, calculate representative velocity (only relevant for tidal case), if false use pre-given Urep_ebb_given and Urep_fl_given
	
	bool initPerturbedBed = true;
	string h_init_file = "h_file_init35"; //if not initially perturbed bed, then load file	
	bool initFlowRest = true; 
	string	init_flow_det_fileName = "dx_0_5_L2000";
	
	bool adaptiveDepth; if(river) {adaptiveDepth = true;} else if (sea) {adaptiveDepth = false;} 
	bool CD_switch = false;
	bool isStaggeredGrid = false; // staggering of 
	if (CD_switch) {isStaggeredGrid = true;} // if 
	
	bool save_MorphDat = true;
	bool save_HydDat = false;
	int hydDat_storageInterval = 1; // how many morph loops until hyd dat is stored
	bool AdaptiveTimeControl = true;
	double T_end_hyd_init = 15000;
	double T_end_hyd_fromSecond = 500;
	double dt_hyd = 1;
		
	double morph_time_static = 2*M_PI/1.405e-4; // this is the value of morphodynamic time step (i.e. dt_morph) if AdaptiveTimeControl is turned off	
	
	// it appears that the stability is primarily dependent on the slope-induced transport: d/dx (lambda * |tau|^beta * dh/dx) 
	double tolerance = 0.0015; // the tolerance, 
	
	Vars variables (T_end_hyd_init, dt_hyd); // obtain variables from local Vars.cpp file

	double theta_rad = 30 * M_PI / 180;
	double toosteep = 0.466;
	double f_lambda_asymptotic = variables.a_bs * (1 - tan(theta_rad));
	
	if (!tau_crit_bool) {
		variables.tau_crit = 0;
	}
	
	valarray<double> x_grid = xGrid_maker (variables, isStaggeredGrid);
	valarray<double> x_grid_hyd = xGrid_maker (variables, false);
//	print_doubleValArray(x_grid_hyd);	
	cout << "dx = " << variables.dx << endl;
	
	valarray<double> h = make_random_topography(Nconstituents, x_grid, variables, 1, increment, startWaveMode);
	
	if (!initPerturbedBed) {// load initial file from h_file_init
		string foldername_h_init = "h_file_init_dir/";
		string filename_h_init = foldername_h_init + h_init_file; 
		ifstream stream_h_init( filename_h_init ); 
		
		string h_file_init_line;
		getline(stream_h_init, h_file_init_line);
		istringstream stm( h_file_init_line );
		vector<double> h_init_fromfile;
		
		    std::vector<double> numbers ;
		    double number ;
		    while( stm >> number ) h_init_fromfile.push_back(number) ;
		valarray<double>   h_init_fromfile_valarray(variables.Nx);
		    for( int i =0; i< h_init_fromfile.size(); i++ ) 
		    { 
		    	h_init_fromfile_valarray[i] = h_init_fromfile[i]; 
		    }
		valarray<double> x_grid_q = make_xGrid(h_init_fromfile.size(), variables.x_min, variables.x_max);		
		h = interp1_lin(x_grid_q, h_init_fromfile_valarray, x_grid); // interpolate h from file on the current grid	

	}
	
	fileSystem h_file ("h.txt"); fileSystem xGrid_file ("xGrid.txt"); fileSystem xGrid_hyd_file ("xGrid_hyd.txt");		
	fileSystem dhdt_file ("dhdt.txt"); fileSystem dhdx_file ("dhdx.txt"); fileSystem qb_file ("qb.txt"); fileSystem taux_file ("taux.txt"); fileSystem MorphTime_file ("MorphTime.txt"); fileSystem depth_file ("WaterDepth.txt");
	fileSystem dhdt_flow_file ("dhdt_flow.txt"); fileSystem dhdt_slope_file ("dhdt_slope.txt");
	fileSystem tauy_file ("tauy.txt");
	fileSystem dhdt_flow_flood_file ("dhdt_flow_flood.txt"); fileSystem dhdt_flow_ebb_file ("dhdt_flow_ebb.txt"); 
	fileSystem dhdt_slope_flood_file ("dhdt_slope_flood.txt"); fileSystem dhdt_slope_ebb_file ("dhdt_slope_ebb.txt"); 
	fileSystem taux_flood_file ("taux_flood.txt"); fileSystem taux_ebb_file ("taux_ebb.txt");
	fileSystem velocity_file("U.txt"); fileSystem momSource_file("F_orc.txt");
	
	string morphDir = h_file.morphDir; 
	
	makeMorphDir (h_file.morphDir);	
		
	string cwd_string = getCWD (); // get the path to current working directory (cwd)
	
	h_file.saveToFile (h); 
	xGrid_file.saveToFile (x_grid); xGrid_hyd_file.saveToFile (x_grid_hyd);
	
	fileSystem CN_arrays_lambda_2_upwind ("lambda_upwind.txt");
	fileSystem CN_arrays_lambda_2_downwind ("lambda_downwind.txt");	
	
	
	fileSystem CN_arrays_LHSMat ("CN_arrays_LHS.txt");
	fileSystem CN_arrays_RHSVec ("CN_arrays_RHS.txt");

	double max_dhdt, dt_morph, dt_morph_ebb, dt_morph_flood, morph_time, morph_time_max_dhdt, t_star_ebb, t_star_flood;
	double u_avg; double q_disch; double newDepth; double flowRate;
	valarray<double> dhdx, dhdt, dhdt_flood, dhdt_ebb, dhdt_flood_slope, dhdt_ebb_slope, dhdt_flood_ebb_flow, q_flow_ebb, q_flow_flood, qb_flow, qb_flow_ebb_flood, dqdx_flow_ebb_flood, q_ebb, q_flood;
	valarray<double> morph_time_vec (Nt);
	valarray<double> water_depth_vec (Nt);	
	double momentumSource, momentumSource_ebb, momentumSource_flood;
	string LastTime_str, LastTime_str_flood, LastTime_str_ebb;	
	string VM_sf_path_hyd = "../hydDat";
	
	xt::xarray<double> RHS_vector_slope;
	valarray<double> r_upw, q_iplusHalf(variables.Nx), q_iminHalf(variables.Nx), q_star(variables.Nx);
	xt::xarray<double> RHS_vector; 
	valarray<double> h_nPlusOne;	
	xt::xarray<double> LHS_matrix;		
	xt::xarray<double> tau_lambda_minOne_half_flood, tau_lambda_plusOne_half_flood, tau_lambda_minOne_half_ebb, tau_lambda_plusOne_half_ebb, tau_lambda_plusOne_half, tau_lambda_minOne_half;
	string save_hydDat_command;
	bool ebb;
	

	
	if (sea) {
		system("rm -r flood ebb");
		system("mkdir flood ebb");
	}
	cout << "ishere1" << endl;
	
	string LastSave_hyd = LastTime_string(VM_sf_path_hyd, 6); cout << LastSave_hyd << endl;
	int LastSave_hyd_int = stoi(LastSave_hyd);

	string LastSave_hyd_plusOne = to_string(LastSave_hyd_int+1);
	
	cout << "ishere2" << endl;
	
	cout << "a_b = " << variables.a_b << endl;
	cout << "beta_b = " << variables.beta_b << endl;
	cout << "D_star = " << variables.D_star << endl;	
	cout << "tau_crit = " << variables.tau_crit << endl;	
	cout << "theta_crit = " << variables.theta_crit << endl;	

	//testing output of function Urep_calc
	cout << "rep ebb velocity = " << Urep_calc(variables.Ux_start, variables.UM2, true) << endl; 
	cout << "rep flood velocity = " << Urep_calc(variables.Ux_start, variables.UM2, false) << endl; 
	cout << "t_star_ebb = " << tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, true) << endl;
	cout << "t_star_flood = " << tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, false) << endl;	
	
	for (int i=0; i < Nt; i++) {	
		cout << "Starting loop nr " << i+1 << endl;
		if (sea) {ebb = i % 2 == 1;
			if (ebb) {cout << "starting ebb flow calculation" << endl;}
			else if (!ebb) {cout << "starting flood flow calculation" << endl;}
		}

		
		makeBlockMeshDictFile(variables, x_grid, h, CD_switch); // make meshDict from variables
		
		if ( (river && i==0) || (sea && i<=1) ) {// first run, or first two runs (depending on river or sea)
			cout << "initializing ..." << endl;
			string copy_forcing_command = "cp constant/acceleration-terms_files/acceleration-terms_init.dat constant/acceleration-terms.dat";  
			system(copy_forcing_command.c_str()); 
			makeControlDictFile (variables); // make controlDict from variables
			
			// make initial fvOptions, either for: velocityForcing or momForcing (NOT init_momForcing) OR init_momForcing
			if (!init_momForcing) {
				if (sea) {
					double Urep;
					if (Urep_calc_bool) {
						Urep = Urep_calc(variables.Ux_start, variables.UM2, ebb);
					} else {
						if (ebb) {
							Urep = variables.Urep_ebb_given;
						} else if (!ebb) {
							Urep = variables.Urep_fl_given;
						}
					}
					if (ebb) {
						make_fvOptions_init (   Urep ); 
						t_star_ebb = tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, ebb);
					} else if (!ebb) {
						make_fvOptions_init (   Urep ); 
						t_star_flood = tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, ebb);
					}
					cout << "Urep = " << Urep << endl;				
				} else if (river) {
					make_fvOptions_init (variables.Ux_start); 
				}
			} else {
				if (sea) {
					if (ebb) {
						t_star_ebb = tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, ebb);
						make_fvOptions_afterInit(variables.momentumSource_ebb);
					}
					else if (!ebb) {
						t_star_flood = tidal_time_calc (variables.Ux_start, variables.UM2, variables.omega, ebb);
						make_fvOptions_afterInit(variables.momentumSource_flood);
					}
				else if (river) {
					make_fvOptions_afterInit(variables.momentumSource_river);
					}
				}
			}
			

			
			string init_flow_det;
			if (initFlowRest) {
				init_flow_det = "rest";
			} else if (!initFlowRest) {init_flow_det = init_flow_det_fileName;}
			// use either 'in rest'  initial condition, or a spun-up one	
			string copy_init_flow_command = "cp init_flow/"+init_flow_det+"/k init_flow/"+init_flow_det+"/nut init_flow/"+init_flow_det+"/epsilon init_flow/"+init_flow_det+"/omega init_flow/"+init_flow_det+"/p init_flow/"+init_flow_det+"/U 0.orig";
			system(copy_init_flow_command.c_str());
			
			// run OpenFOAM
			system("./Allclean"); system("./Allrun_first");		
								
			LastTime_str = LastTime_string (cwd_string);

			// get momentum source
			if (!init_momForcing) { // if momForcing or velocityForcing
				string filename_momSource = LastTime_str + "/uniform/momentumSourceProperties";
				ifstream strm_momSource( filename_momSource );
				momentumSource = readFoamFile_mom ( strm_momSource );
			
				if (river || (sea && ebb)) {			
					make_fvOptions_afterInit(-momentumSource);
				} else if (sea && !ebb) {
					make_fvOptions_afterInit(momentumSource); // for some reason, OpenFOAM doesn't output the momentumsource properties with a consistent sign
				}
			}
			
			string copy_fvOptions_command;	
			if (sea) { // if sea, save the fvOptions file in either ebb or flood directory. Save hydro dat and save in same directory
				if (ebb) {
					copy_fvOptions_command = "mv constant/acceleration-terms.dat ebb/";
				}
				else if (!ebb) {
					copy_fvOptions_command = "mv constant/acceleration-terms.dat flood/";
				}
				system(copy_fvOptions_command.c_str()); 
			}		
			
			cout << "momentumSource = " << momentumSource << endl;
			
			
			if (sea) {
				if (ebb) {
					cout << "initial ebb completed" << endl;
					}
				else if (!ebb) {
					cout << "initial flood completed" << endl;
				}
			}

		} else {
			variables.T_end_hyd = T_end_hyd_fromSecond;
						
			makeControlDictFile (variables); // make controlDict from variables, with new T_end_hyd				
			if (river) {restore_fromLast (LastTime_str);} // copy from last time to 0, this script includes ./Allclean								
			else if (sea && ebb) {
				system("cp ebb/acceleration-terms.dat constant/");
				restore_fromLast_tidal (LastTime_str_ebb, ebb);
			}
			else if (sea && !ebb) {
				system("cp flood/acceleration-terms.dat constant/");
				restore_fromLast_tidal (LastTime_str_flood, ebb);
			}
			

			if (velocityForcing) {  // velocity forcing
				if (sea) {
					if (ebb) {
						make_fvOptions_init (   Urep_calc(variables.Ux_start, variables.UM2, ebb) ); 
					} else if (!ebb) {
						make_fvOptions_init (   Urep_calc(variables.Ux_start, variables.UM2, ebb) ); 
					}
					cout << "Urep = " << Urep_calc(variables.Ux_start, variables.UM2, ebb)	<< endl;				
				} else if (river) {
					make_fvOptions_init (variables.Ux_start); 
				}
			}
			
			system("./Allrun_fromSecond");	// run OpenFOAM without restoring from 0dir (Allrun_fromSecond)	
			LastTime_str = LastTime_string (cwd_string);				
		}
		
		cout << "last time hyd = " << LastTime_str << endl;
		
		if (save_HydDat) {
			if (i % hydDat_storageInterval == 0) {
				string newFolder = VM_sf_path_hyd + "/hydDat" + LastSave_hyd_plusOne + "/" + to_string(i);
				string mkdir_command = "mkdir -p " +  newFolder;
				cout << mkdir_command << endl;
				system(mkdir_command.c_str());
				string save_command = "cp -r " + LastTime_str + "/* " + newFolder;
				system(save_command.c_str());
				cout << save_command << endl;	
			}
		}
		
		// read shear stress							
		string filename = LastTime_str + "/wallShearStress"; 
		ifstream strm( filename ); 
		readFoamFile_tau readTau ( strm );
		valarray<double> tau_x, tau_y; tau_x = readTau.U; tau_y = readTau.V;
		tau_x = - variables.rho0 * tau_x; tau_y = - variables.rho0 * tau_y; // obtained (shear) stress is as experienced by the fluid, minus that is the stress experienced by the wall. It's multiplied by rho0 because the shear stress OpenFOAM outputs is the volumetric shear stress	
		
		// compute parallel component tau_x and tau_y
		valarray<double> h_OF = 0.5 * (h  + h.cshift(-1)); // this is the topography on the OpenFOAM grid: h[0] = h(x=0)
		valarray<double> dhdx_OF = (h_OF.cshift(1) - h_OF) / variables.dx; // this is the derivative at the cell faces as interpreted by OF, dhdx_OF[0] = dhdx(x=.5dx)
		valarray<double> tau_x_parallel = tau_x / pow(1 + pow(dhdx_OF , 2.0) , 0.5) ; // tau_x_parallel = tau_x / (sqrt(1 + dhdx^2))
		valarray<double> tau_y_parallel = tau_y * dhdx_OF / pow(1 + pow(dhdx_OF , 2.0) , 0.5) ;
		
		tau_x = tau_x_parallel + tau_y_parallel;		
				
		// read flow through cyclic boundary
		string filename_flowRate = LastTime_str + "/uniform/functionObjects/functionObjectProperties";
		ifstream strm_flowRate( filename_flowRate );
		flowRate = readFoamFile_flowRate ( strm_flowRate );
//		double h_domainEdge = (h[0] + h[h.size()-1]) / 2;
		u_avg = flowRate / variables.domain_width / variables.depth;
		cout << "u_avg = " << u_avg << endl;
						
		dhdx = derivative_upWind (h, variables.dx); 
		
		// Heaviside function
		valarray<double> Heaviside (variables.Nx);
		
		for (int j=0; j < variables.Nx; j++) {
			if ( abs(tau_x[j]) > variables.tau_crit ) {
				Heaviside[j] = 1.0;
			} else {
				Heaviside[j] = 0.0;
			}
		}
		
		// dhdt_slope		
		xt::xarray<double> h_array = xt::transpose (valArrayTo_xarray (h)); 
		int size_h = h_array.shape(0);
		
		valarray<double> tau_abs_pow = pow(abs(tau_x), variables.beta_b);		
		valarray<double> tau_abs_pow_half = pow(abs(tau_x), 0.50);
		valarray<double> tau_abs_pow_crit = tau_abs_pow_half * (abs(tau_x)  - variables.tau_crit) * Heaviside; // changed tau_abs_pow to tau_abs_pow_crit to account for critical shear		
						
		xt::xarray<double> tau_plusOne = xt::transpose (c_leftshift_xarray ( valArrayTo_xarray (tau_abs_pow_crit), 1)); 
		xt::xarray<double> tau_minOne = xt::transpose (c_rightshift_xarray ( valArrayTo_xarray (tau_abs_pow_crit), 1));
		xt::xarray<double> tau = xt::transpose ( valArrayTo_xarray (tau_abs_pow_crit));
		
		xt::xarray<double> h_array_plusOne = xt::transpose (c_leftshift_xarray ( valArrayTo_xarray (h), 1));
		xt::xarray<double> h_array_minOne = xt::transpose (c_rightshift_xarray ( valArrayTo_xarray (h), 1));

		xt::xarray<double> I = xt::eye<double>(size_h);
		xt::xarray<double> I_plusOne = c_rightshift_xarray (I ,1);
		xt::xarray<double> I_minOne = c_leftshift_xarray (I ,1);
		
		
		valarray<double> dhdx_upwind = derivative_upWind(h, variables.dx);
		valarray<double> dhdx_downwind = derivative_downWind(h, variables.dx);
		
		valarray<double> lambda_2_upwind (variables.Nx);
		valarray<double> lambda_2_downwind (variables.Nx);
		
		double lambda_sign_base;
		
		if (river || (sea && ebb)) {
			lambda_sign_base = 1;
		} else if (sea && !ebb) {
			lambda_sign_base = -1;
		}

		for (int i=1; i <= variables.lambda_Taylor_coefs.size(); i++)
		{ 
			if (asym_slope) {			
				lambda_2_upwind   = lambda_2_upwind   + variables.a_bs * 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(dhdx_upwind, i-1)   * pow(lambda_sign_base, i+1);
				lambda_2_downwind = lambda_2_downwind + variables.a_bs * 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(dhdx_downwind, i-1) * pow(lambda_sign_base, i+1);	
			}
			// the following is the symmetric one 	
			else if (!asym_slope) {
				lambda_2_upwind   = lambda_2_upwind   + variables.a_bs * 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(abs(dhdx_upwind), i-1)   * pow(-1, i+1);
				lambda_2_downwind = lambda_2_downwind + variables.a_bs * 1/factorial(i) * variables.lambda_Taylor_coefs[i-1] * pow(abs(dhdx_downwind), i-1) * pow(-1, i+1);
			}
		}
		
		 
		// correct the lambda value for stoss-slopes: where Taylor expansion becomes highly inaccurate (only for asymmetric slope correction)		
		if (asym_slope) {
			for (int i = 0; i < dhdx_upwind.size(); i++) {
				if (sea && !ebb) {
					if(dhdx_upwind[i] < -toosteep) {
						lambda_2_upwind[i] = f_lambda_asymptotic / dhdx_upwind[i];
					}
					if(dhdx_downwind[i] < -toosteep) {
						lambda_2_downwind[i] = f_lambda_asymptotic / dhdx_downwind[i];
					}
				}
				else if (river || (sea && ebb)) { 
					if(dhdx_upwind[i] > toosteep) {
						lambda_2_upwind[i] = -f_lambda_asymptotic / dhdx_upwind[i];
					}
					if(dhdx_downwind[i] > toosteep) {
						lambda_2_downwind[i] = -f_lambda_asymptotic / dhdx_downwind[i];
					}
				}	
			}	
		}	
		
		
		valarray<double> lambda = (lambda_2_upwind + lambda_2_downwind)/2;
		
		CN_arrays_lambda_2_upwind.saveToFile (lambda_2_upwind);
		CN_arrays_lambda_2_downwind.saveToFile (lambda_2_downwind);	
		
		xt::xarray<double> lambda_2_upwind_x = xt::transpose ( valArrayTo_xarray (-lambda_2_upwind));
		xt::xarray<double> lambda_2_downwind_x = xt::transpose ( valArrayTo_xarray (-lambda_2_downwind));
					
		xt::xarray<double> tau_plusOne_half = (tau_plusOne + tau) / 2;
		xt::xarray<double> tau_minOne_half = (tau_minOne + tau) / 2;
		
		if (river) {		

			tau_lambda_minOne_half = tau_minOne_half * lambda_2_upwind_x;
			tau_lambda_plusOne_half = tau_plusOne_half * lambda_2_downwind_x;
			
		} else if (sea) {
			if (ebb) {				
				tau_lambda_minOne_half_ebb = tau_minOne_half * lambda_2_upwind_x;
				tau_lambda_plusOne_half_ebb =  tau_plusOne_half * lambda_2_downwind_x;	
				
				tau_lambda_minOne_half  = t_star_flood * tau_lambda_minOne_half_flood  + t_star_ebb * tau_lambda_minOne_half_ebb;
				tau_lambda_plusOne_half = t_star_flood * tau_lambda_plusOne_half_flood + t_star_ebb * tau_lambda_plusOne_half_ebb;
								
			} else if (!ebb) { 
				tau_lambda_minOne_half_flood = tau_minOne_half * lambda_2_upwind_x;
				tau_lambda_plusOne_half_flood =  tau_plusOne_half * lambda_2_downwind_x;				
			}
		}
		

		if (river || (sea && ebb)) {	
			// determine time step	
			xt::xarray<double> gamma_diffusion_vec = variables.a_b * xt::abs(tau_lambda_plusOne_half - tau_lambda_minOne_half) / variables.dx;
			auto gamma_diffusion_mean_x = xt::mean(gamma_diffusion_vec, {0});
			auto gamma_diffusion_mean = gamma_diffusion_mean_x(0);

			double dt_morph_tol = tolerance * variables.dx / gamma_diffusion_mean;
			
			dt_morph = dt_morph_tol; 
			
			if (!AdaptiveTimeControl) {dt_morph = morph_time_static; }
			
			cout << "dt_morph = " << dt_morph/3600 << " h" <<  endl;

			double C1_2 = (2*pow(variables.dx, 2) * (1-variables.porosity)) / (variables.a_b *  dt_morph);
			
			// slope correction: semi-implicit
			xt::xarray<double> LHS_matrix_1 = C1_2 * I;
			xt::xarray<double> LHS_matrix_2 = (tau_lambda_plusOne_half + tau_lambda_minOne_half) * I;
			xt::xarray<double> LHS_matrix_3 = - tau_lambda_minOne_half * I_minOne;
			xt::xarray<double> LHS_matrix_4 = - tau_lambda_plusOne_half * I_plusOne;
			LHS_matrix = LHS_matrix_1 + LHS_matrix_2 + LHS_matrix_3 + LHS_matrix_4;
			
			RHS_vector_slope = (C1_2 * h_array - h_array * (tau_lambda_plusOne_half + tau_lambda_minOne_half) + h_array_minOne * tau_lambda_minOne_half + h_array_plusOne * tau_lambda_plusOne_half); 
			
		}
		
		// dhdt_flow
		
		if (sea) {
			if (ebb) {
//				q_flow_ebb = variables.a_b * tau_abs_pow * (tau_x/abs(tau_x));
				q_flow_ebb = variables.a_b * tau_abs_pow_crit * (tau_x/abs(tau_x)); // with critical shear stress
			} else if (!ebb) {
				q_flow_flood = variables.a_b * tau_abs_pow_crit * (tau_x/abs(tau_x)); // with critical shear stress
			}
		}
		
		valarray<double> dhdx_centered = derivative_center(h, variables.dx);
		
		if (river || (sea && ebb)) {
			if (sea && ebb) {
				qb_flow = t_star_ebb * q_flow_ebb + t_star_flood * q_flow_flood;
			} else if (river) {
				qb_flow = variables.a_b * tau_abs_pow_crit * (tau_x/abs(tau_x));
			}
			r_upw = (qb_flow - qb_flow.cshift(-1))/(qb_flow.cshift(1) - qb_flow);
			valarray<double> r_h = (h       - h.cshift(-1)      )/(h.cshift(1)       - h);		
			valarray<double> r_q = (qb_flow - qb_flow.cshift(-1))/(qb_flow.cshift(1) - qb_flow);		

			
			for (int i=0; i < r_h.size(); i++) { 
				r_upw[i] = min(r_h[i], r_q[i]);
			}
			
				
			valarray<double> qb_flow_minOne  = qb_flow.cshift(-1);
			valarray<double> qb_flow_plusOne = qb_flow.cshift(1);
			valarray<double> qb_flow_plusTwo = qb_flow.cshift(2);
			valarray<double> r_minOne = r_upw.cshift(-1);
			valarray<double> r_plusOne = r_upw.cshift(1);
			double S, q_R, q_L;
			for (int i=0; i < qb_flow.size(); i++) { 
				q_R = qb_flow_plusOne[i] - phi_minMod_double(r_plusOne[i]) * (qb_flow_plusTwo[i] - qb_flow_plusOne[i]) / 2;
				q_L = qb_flow[i] 	 + phi_minMod_double(r_upw[i])     * (qb_flow_plusOne[i] - qb_flow[i])  / 2;
				S = 0.5 * (q_L + q_R);
				if (q_L > q_R) {
					if (S > 0) {
						q_star[i] = q_L;
					} else if (S <= 0) {
						q_star[i] = q_R;
					}
				} else {
					if (q_L > 0) {
						q_star[i] = q_L;
					} else if ( (q_L < 0) && (q_R > 0) ) {
						q_star[i] = 0;
					} else {
						q_star[i] = q_R;
					}
				}			
			}
			q_iplusHalf = q_star;
			q_iminHalf = q_star.cshift(-1);	

			valarray<double> q_flow_RHS = - (2 * variables.dx / variables.a_b) * (q_iplusHalf - q_iminHalf); 				
			xt::xarray<double> q_flow_RHS_xt = xt::transpose ( valArrayTo_xarray (q_flow_RHS));
			RHS_vector = RHS_vector_slope + q_flow_RHS_xt;	

			xt::xarray<double> h_nPlusOne_xt = xt::linalg::solve(LHS_matrix, RHS_vector);
			
			h_nPlusOne = xarrayTo_valArray(h_nPlusOne_xt); 	
		}
				
		// total dhdt
		dhdt = (h_nPlusOne - h)/dt_morph;
		
		if (sea && ebb) {
			dhdt_ebb = dhdt;
			dt_morph_ebb = dt_morph;
			
		} else if (sea && !ebb) {
			dhdt_flood = dhdt;
			dt_morph_flood = dt_morph;
		}			
				
		if (river || (sea && ebb)) { // update bed when case = river or, when sea AND i is uneven (after ebb)
			h = h_nPlusOne;
		} else {// cout << "Bed not updated, going to calculate ebb tide first" << endl;
		}
		
		if (i == 0) { morph_time_vec[i] = dt_morph; } 
		else { // i is not 0
			if (sea && !ebb) {
				dt_morph = 0;
			}
			morph_time_vec[i] = morph_time_vec[i-1] + dt_morph;
			cout << "time = " << morph_time_vec[i]/3600/24 << " d" << endl;
		}
		
		if (river || (sea && ebb)) {
			h_file.saveToFile (h); dhdt_file.saveToFile (dhdt); dhdx_file.saveToFile (dhdx); qb_file.saveToFile (qb_flow);  tauy_file.saveToFile (tau_y);
			MorphTime_file.saveToFile_double (morph_time_vec[i]);				
		}
		

		velocity_file.saveToFile_double (u_avg);

		string filename_momSource = LastTime_str + "/uniform/momentumSourceProperties";
		ifstream strm_momSource( filename_momSource );
		momentumSource = readFoamFile_mom ( strm_momSource );
		if (river || (sea && ebb)) {			
			momentumSource = momentumSource;
		} else if (sea && !ebb) {
			momentumSource = -momentumSource;			
		}
		momSource_file.saveToFile_double(momentumSource);

		
		if (river) {
			taux_file.saveToFile (tau_x); 
		} else if (sea) { 
			if (ebb) {
				taux_ebb_file.saveToFile (tau_x);				
			} else if (!ebb) {
				taux_flood_file.saveToFile (tau_x);								
			}
		}
		

		if (river) {// adaptive Depth can only be activated with a riverine case
			if (adaptiveDepth) {// Read flowRate, determine specific discharge [m^2/s] for the first timestep (i=0), and demand this to stay the same over the simulation
				
				if (i==0) {// determine specific discharge [m^2/s], which is to remain constant
					q_disch = u_avg * variables.depth;
				} 
				// change water depth
				newDepth = q_disch / u_avg; 
				cout << "new depth = " << newDepth << endl;
				variables.depth = newDepth;
				water_depth_vec[i] = newDepth;
				depth_file.saveToFile_double (newDepth);
			}
		}
		

		if (sea) {
			string save_hydDat_command;
			if (ebb) {
				LastTime_str_ebb = LastTime_str;
				save_hydDat_command = "mv " + LastTime_str_ebb + " ebb/";
			}
			else if (!ebb) {
				LastTime_str_flood = LastTime_str;
				save_hydDat_command = "mv " + LastTime_str_flood + " flood/";
			}
			system(save_hydDat_command.c_str());
		}	
		
	}
	
		// move morphDat to shared folder (sf)
		string VM_sf_path_morph = "../morphDat";
		string LastRun = LastTime_string(VM_sf_path_morph, 8); int LastRun_int = stoi(LastRun);
		string LastRun_plusOne = to_string(LastRun_int+1);
		string mv_command = "mv morphDat " + VM_sf_path_morph + "/morphDat" + LastRun_plusOne;
		
	if (save_MorphDat) {
		system(mv_command.c_str());
		cout << "Morpho data saved as " << "morphDat" + LastRun_plusOne << endl;
	}
	if (save_HydDat) {
		cout << "Hydro data saved as " << "hydDat" + LastSave_hyd_plusOne << endl;
	}
	
	return 0;
}

	

