# Contributing to flory

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## We Develop with Github

We use Github to host code, to track issues and feature requests, as well as accept pull requests.

## All Code Changes Happen Through Pull Requests

Pull requests are the best way to propose changes to the codebase. We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If necessary, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Any contributions you make will be under the MIT license

In short, when you submit code changes, your submissions are understood to be under the same [MIT license](LICENSE) that covers the project.

## Report bugs using GitHub's issues

We use GitHub issues to track public bugs. Report a bug by opening a new issue!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- What you expected would happen
- What actually happens

## Use a Consistent Coding Style

We use [ruff](https://docs.astral.sh/ruff/) as both the formatter and linter for Python.
