###Code for article "Motor vehicle disturbance and species diet niche breadth structure urban bird communities in Southeast Asia" by Jan Grünwald and Jiří Reif
##Community level models
#Loading the required packages.
library(glmmTMB)
library(DHARMa)
library(performance)
library(MuMIn)
#Loading the data
data_community <- read.table("deposit_community_data.txt", header = T, stringsAsFactors = T, sep="\t")

#Scaling the predictors.
data_community$green_sc <- scale(data_community$Greenery..)
data_community$pointgreen_sc <- scale(data_community$PointGreenery.)
data_community$pop_sc <- scale(data_community$Population)
data_community$lon_sc <- scale(data_community$Longitude)
data_community$pede_sc <- scale(data_community$Pedestrians)
data_community$veh_sc <- scale(data_community$Vehicles)
data_community$lit_sc <- scale(data_community$Literacy..)

#Fitting the first model.
CommunityModel1 <- glmmTMB(Shannon.Index ~ pointgreen_sc + pop_sc + green_sc + pede_sc + veh_sc + lon_sc + lit_sc + (1|City), data = data_community, family = gaussian)

#Results of the first model.
summary(CommunityModel1)

#Checking the diagnostics and variability explained.
sim_res_CommunityModel1 <- simulateResiduals(CommunityModel1, n = 500)
plot(sim_res_CommunityModel1, quantreg = TRUE)
check_singularity(CommunityModel1)
r.squaredGLMM(CommunityModel1)

#Fitting the second model.
CommunityModel2 <- glmmTMB(Total.abundance ~  pointgreen_sc + pop_sc + green_sc + pede_sc + veh_sc + lon_sc + lit_sc + (1|City), data = data_community, family = nbinom1)

#Result of the second model.
summary(CommunityModel2)

#Checking the diagnostics and variability explained.
sim_res_CommunityModel2 <- simulateResiduals(CommunityModel2, n = 500)
plot(sim_res_CommunityModel2, quantreg = TRUE)
check_singularity(CommunityModel2)
r.squaredGLMM(CommunityModel2)

#Fitting the third model.
CommunityModel3 <- glmmTMB(Species.richness ~  pointgreen_sc + pop_sc + green_sc + pede_sc + veh_sc + lon_sc + lit_sc, data = data_community, family = poisson)

#Results of the third model.
summary(CommunityModel3)

#Checking the diagnostics and variability explained.
sim_res_CommunityModel3 <- simulateResiduals(CommunityModel3, n = 500)
plot(sim_res_CommunityModel3, quantreg = TRUE)
check_singularity(CommunityModel3)
r.squaredGLMM(CommunityModel3)

##Species level models
#Loading the data.
data_species<-read.table("deposit_species_data.txt", header = T, stringsAsFactors = T, sep="\t")

#Scaling of the range and generation length, log scaling the mass.
data_species$mass_log <- log(data_species$Mass)
data_species$range_sc <- scale(data_species$Range)
data_species$generation_length_sc <- scale(data_species$Generation.length)

#Fitting the model for abundance of species.
SpeciesModel1 <- glmmTMB(Total.abundance ~ mass_log + Dietary.specialization + Habitat.specialization + range_sc + generation_length_sc + (1|Family), data = data_species, family = nbinom2)

#Result of the model for abundance of species.
summary(SpeciesModel1)

#Checking the diagnostics and variability explained.
sim_res_SpeciesModel1 <- simulateResiduals(SpeciesModel1, n = 500)
plot(sim_res_SpeciesModel1, quantreg = TRUE)
check_singularity(SpeciesModel1)
r.squaredGLMM(SpeciesModel1)

#Fitting the model for occupancy of species.
SpeciesModel2 <- glmmTMB(Occupancy ~ mass_log + Dietary.specialization + Habitat.specialization + range_sc + generation_length_sc + (1|Family), data = data_species, family = gaussian)

#Result of the model for occupancy of species.
summary(SpeciesModel2)

#Checking the diagnostics and variability explained.
sim_res_SpeciesModel2 <- simulateResiduals(SpeciesModel2, n = 2000)
plot(sim_res_SpeciesModel2, quantreg = TRUE)
check_singularity(SpeciesModel2)
r.squaredGLMM(SpeciesModel2)
