# -*- coding: utf-8 -*-
"""Cheminformatics Microservice Python Modules.

This set of essential and valuable microservices is designed to be
accessed via API calls to support cheminformatics. Generally, it is
designed to work with SMILES-based inputs and could be used to translate
between different machine-readable representations, get Natural Product
(NP) likeliness scores, visualize chemical structures, and generate
descriptors. In addition, the microservices also host an instance of
STOUT and another instance of DECIMER (two deep learning models for
IUPAC name generation and optical chemical structure recognition,
respectively).

For comments, bug reports or feature requests, please raise an issue on
our GitHub repository.
"""
from __future__ import annotations

__version__ = "1.0.0"
