% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{.check_vars_FALSE}
\alias{.check_vars_FALSE}
\title{Check that at least one element is requested}
\usage{
.check_vars_FALSE(
  pre,
  pre_cv,
  rd0,
  tmp,
  dtr,
  reh,
  tmn,
  tmx,
  sunp,
  frs,
  wnd,
  elv
)
}
\arguments{
\item{pre}{Fetches precipitation (millimetres/month) from server and
returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{pre_cv}{Fetches cv of precipitation (percent) from server and
returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.  Note, setting
this to \code{TRUE} will always results in \strong{pre} being set to \code{TRUE} and
returned as well.}

\item{rd0}{Fetches wet-days (number days with >0.1 millimetres rain per
month) and returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{tmp}{Fetches temperature (degrees Celsius) and returns it in the
data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{dtr}{Fetches mean diurnal temperature range (degrees Celsius)
and returns it in the data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{reh}{Fetches relative humidity and returns it in the data frame,
\code{TRUE}. Defaults to \code{FALSE}.}

\item{tmn}{Calculates minimum temperature values (degrees Celsius)
and returns it in the data frame. Defaults to \code{FALSE}.}

\item{tmx}{Boolean. Calculates maximum temperature (degrees Celsius) and
returns it in the data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{sunp}{Fetches sunshine, percent of maximum possible (percent of
day length), and returns it in the data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{frs}{Boolean. Fetches ground-frost records (number of days with
ground-frost per month) and returns it in data frame, \code{TRUE}.  Defaults to
\code{FALSE}.}

\item{wnd}{Fetches 10m wind speed (metres/second) and returns it in the data
frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{elv}{Fetches elevation (converted to metres) and returns it in the
data frame, \code{TRUE}. Defaults to \code{FALSE}.}
}
\description{
Check that at least one element is requested
}
\examples{
.check_vars_FALSE(
  pre,
  pre_cv,
  rd0,
  tmp,
  dtr,
  reh,
  tmn,
  tmx,
  sunp,
  frs,
  wnd,
  elv
)
}
\keyword{internal}
