(* ::Package:: *)

(*********************************************************************************)
(* Two-loop helicity amplitudes for diphoton production with massive quark loop  *)
(* Taushif Ahmed, Amlan Chakraborty, Ekta Chaubey and Mandeep Kaur               *)
(*********************************************************************************)

(* This file calculates helicity amplitudes for qqbar -> diphoton in terms of master integrals *)


SetDirectory[NotebookDirectory[]]
T1 = Get["T1qq"];
T2 = Get["T2qq"];
T3 = Get["T3qq"];
T4 = Get["T4qq"];


y11 = -(t)*1/(2(s)^2)*(1/(d-3)*1/((s)+(t)));

y12 = 0;

y13 = -(t)*1/(2(s)^2)*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y14 = 0;


y21 = 0;

y22 = -(t)*1/(2(s)^2)*(1/(d-3)*1/((s)+(t)));

y23 = (t)*1/(2(s)^2)*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y24 = 0;


y31 = -(t)*1/(2(s)^2)*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y32 = (t)*1/(2(s)^2)*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y33 = -(d*(t)^2+4*(s)^2+4*(s)*(t))*1/(2(s)^2)*1/(t)*1/((s)+(t))*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y34 = (2*(s)+(t))*1/(2(s)*(t))*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));


y41 = 0;

y42 = 0;

y43 = (2*(s)+(t))*1/(2(s)*(t))*1/((s)+(t))*(1/(d-3)*1/((s)+(t)));

y44 = -1/(2(t))*(1/(d-3)*1/((s)+(t)));


FF1 = y11*T1 + y12*T2 + y13*T3 + y14*T4;
FF2 = y21*T1 + y22*T2 + y23*T3 + y24*T4;
FF3 = y31*T1 + y32*T2 + y33*T3 + y34*T4;
FF4 = y41*T1 + y42*T2 + y43*T3 + y44*T4;

(* Finite remainders: H1= H-+--, H2=H-+-+, H3= H-++-, H4= H-+++ 
see Table 2 of the paper *)
H1 = (-s-t)/2*(FF2 - (-s-t)/2*FF3 + FF4);
H2 = (-s-t)/2*((s)/2*FF3 + FF4);
H3 = (s)*(-s-t)*1/(2(t))*(FF2 - FF1 - (-s-t)/2*FF3 -(-s-t)/(s)*FF4);
H4 = (-s-t)/2*(FF1 + (-s-t)/2*FF3 - FF4);
