(* ::Package:: *)

(*********************************************************************************)
(*  Two-loop helicity amplitudes for diphoton production with massive quark loop *)
(* Taushif Ahmed, Amlan Chakraborty, Ekta Chaubey and Mandeep Kaur               *)
(*********************************************************************************)

(* This file calculates helicity amplitudes for gg -> diphoton in terms of master integrals *)


SetDirectory[NotebookDirectory[]]
T1 = Get["./T1gg.txt"];
T2 = Get["./T2gg.txt"];
T3 = Get["./T3gg.txt"];
T4 = Get["./T4gg.txt"];
T5 = Get["./T5gg.txt"];
T6 = Get["./T6gg.txt"];
T7 = Get["./T7gg.txt"];
T8 = Get["./T8gg.txt"];
Print[T8]
Print["loaded all files"]
amp = {T1,T2,T3,T4,T5,T6,T7,T8};
mat = Get["mat1.m"];
mat = mat /. {t -> -t - s,u -> -s -u};
fftohelicity = Get["fftohelicitycheck.m"];
fftohelicity = fftohelicity /. {t -> -t - s,u -> -s -u};
FF = (mat . amp);
Print[FF]
(* Finite remainders: {H++++,H-+++,H+-++,H++-+,H+++-,H\[LongDash]++,H-+-+,H+\[LongDash]+}, as
see Table 3 of the paper *)
H = (fftohelicity . FF);
Print[H]
