/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#if !defined(QGL_GENERATOR_PROGRAM)

#include "qglpickcolors_p.h"

QT_BEGIN_NAMESPACE

// The following tables are generated by the program listed at the
// end of this source file.

static int const pickColors[4096] = {
    0xffffff, 0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0xff00ff, 0x00ffff,
    0xff8000, 0x80ff00, 0x8000ff, 0xff0080, 0x0080ff, 0x00ff80, 0xff80ff,
    0x80ffff, 0xffff80, 0x80ff80, 0xff8080, 0x8080ff, 0x808080, 0x800000,
    0x008000, 0x000080, 0x808000, 0x800080, 0x008080, 0xff80c0, 0x80c0ff,
    0xc0ff80, 0xffc080, 0x80ffc0, 0xc080ff, 0xffc000, 0xc0ff00, 0xc000ff,
    0xff00c0, 0x00c0ff, 0x00ffc0, 0xffc0ff, 0xc0ffff, 0xffffc0, 0xc0ffc0,
    0xffc0c0, 0xc0c0ff, 0x80c000, 0xc08000, 0xc00080, 0x8000c0, 0x00c080,
    0x0080c0, 0x80c080, 0xc08080, 0x8080c0, 0xc080c0, 0x80c0c0, 0xc0c080,
    0xc0c0c0, 0xc00000, 0x00c000, 0x0000c0, 0xc0c000, 0xc000c0, 0x00c0c0,
    0xff8040, 0x8040ff, 0x40ff80, 0xff4080, 0x80ff40, 0x4080ff, 0xffc040,
    0xc040ff, 0x40ffc0, 0xff40c0, 0xc0ff40, 0x40c0ff, 0xff4000, 0x40ff00,
    0x4000ff, 0xff0040, 0x0040ff, 0x00ff40, 0xff40ff, 0x40ffff, 0xffff40,
    0x40ff40, 0xff4040, 0x4040ff, 0x80c040, 0xc04080, 0x4080c0, 0x8040c0,
    0xc08040, 0x40c080, 0x804000, 0x408000, 0x400080, 0x800040, 0x004080,
    0x008040, 0x804080, 0x408080, 0x808040, 0x408040, 0x804040, 0x404080,
    0xc04000, 0x40c000, 0x4000c0, 0xc00040, 0x0040c0, 0x00c040, 0xc040c0,
    0x40c0c0, 0xc0c040, 0x40c040, 0xc04040, 0x4040c0, 0x404040, 0x400000,
    0x004000, 0x000040, 0x404000, 0x400040, 0x004040, 0xff80e0, 0x80e0ff,
    0xe0ff80, 0xffe080, 0x80ffe0, 0xe080ff, 0xffc0e0, 0xc0e0ff, 0xe0ffc0,
    0xffe0c0, 0xc0ffe0, 0xe0c0ff, 0xff40e0, 0x40e0ff, 0xe0ff40, 0xffe040,
    0x40ffe0, 0xe040ff, 0xffe000, 0xe0ff00, 0xe000ff, 0xff00e0, 0x00e0ff,
    0x00ffe0, 0xffe0ff, 0xe0ffff, 0xffffe0, 0xe0ffe0, 0xffe0e0, 0xe0e0ff,
    0x80c0e0, 0xc0e080, 0xe080c0, 0x80e0c0, 0xc080e0, 0xe0c080, 0x8040e0,
    0x40e080, 0xe08040, 0x80e040, 0x4080e0, 0xe04080, 0x80e000, 0xe08000,
    0xe00080, 0x8000e0, 0x00e080, 0x0080e0, 0x80e080, 0xe08080, 0x8080e0,
    0xe080e0, 0x80e0e0, 0xe0e080, 0xc040e0, 0x40e0c0, 0xe0c040, 0xc0e040,
    0x40c0e0, 0xe040c0, 0xc0e000, 0xe0c000, 0xe000c0, 0xc000e0, 0x00e0c0,
    0x00c0e0, 0xc0e0c0, 0xe0c0c0, 0xc0c0e0, 0xe0c0e0, 0xc0e0e0, 0xe0e0c0,
    0x40e000, 0xe04000, 0xe00040, 0x4000e0, 0x00e040, 0x0040e0, 0x40e040,
    0xe04040, 0x4040e0, 0xe040e0, 0x40e0e0, 0xe0e040, 0xe0e0e0, 0xe00000,
    0x00e000, 0x0000e0, 0xe0e000, 0xe000e0, 0x00e0e0, 0xff8060, 0x8060ff,
    0x60ff80, 0xff6080, 0x80ff60, 0x6080ff, 0xffc060, 0xc060ff, 0x60ffc0,
    0xff60c0, 0xc0ff60, 0x60c0ff, 0xff4060, 0x4060ff, 0x60ff40, 0xff6040,
    0x40ff60, 0x6040ff, 0xffe060, 0xe060ff, 0x60ffe0, 0xff60e0, 0xe0ff60,
    0x60e0ff, 0xff6000, 0x60ff00, 0x6000ff, 0xff0060, 0x0060ff, 0x00ff60,
    0xff60ff, 0x60ffff, 0xffff60, 0x60ff60, 0xff6060, 0x6060ff, 0x80c060,
    0xc06080, 0x6080c0, 0x8060c0, 0xc08060, 0x60c080, 0x804060, 0x406080,
    0x608040, 0x806040, 0x408060, 0x604080, 0x80e060, 0xe06080, 0x6080e0,
    0x8060e0, 0xe08060, 0x60e080, 0x806000, 0x608000, 0x600080, 0x800060,
    0x006080, 0x008060, 0x806080, 0x608080, 0x808060, 0x608060, 0x806060,
    0x606080, 0xc04060, 0x4060c0, 0x60c040, 0xc06040, 0x40c060, 0x6040c0,
    0xc0e060, 0xe060c0, 0x60c0e0, 0xc060e0, 0xe0c060, 0x60e0c0, 0xc06000,
    0x60c000, 0x6000c0, 0xc00060, 0x0060c0, 0x00c060, 0xc060c0, 0x60c0c0,
    0xc0c060, 0x60c060, 0xc06060, 0x6060c0, 0x40e060, 0xe06040, 0x6040e0,
    0x4060e0, 0xe04060, 0x60e040, 0x406000, 0x604000, 0x600040, 0x400060,
    0x006040, 0x004060, 0x406040, 0x604040, 0x404060, 0x604060, 0x406060,
    0x606040, 0xe06000, 0x60e000, 0x6000e0, 0xe00060, 0x0060e0, 0x00e060,
    0xe060e0, 0x60e0e0, 0xe0e060, 0x60e060, 0xe06060, 0x6060e0, 0x606060,
    0x600000, 0x006000, 0x000060, 0x606000, 0x600060, 0x006060, 0xff80a0,
    0x80a0ff, 0xa0ff80, 0xffa080, 0x80ffa0, 0xa080ff, 0xffc0a0, 0xc0a0ff,
    0xa0ffc0, 0xffa0c0, 0xc0ffa0, 0xa0c0ff, 0xff40a0, 0x40a0ff, 0xa0ff40,
    0xffa040, 0x40ffa0, 0xa040ff, 0xffe0a0, 0xe0a0ff, 0xa0ffe0, 0xffa0e0,
    0xe0ffa0, 0xa0e0ff, 0xff60a0, 0x60a0ff, 0xa0ff60, 0xffa060, 0x60ffa0,
    0xa060ff, 0xffa000, 0xa0ff00, 0xa000ff, 0xff00a0, 0x00a0ff, 0x00ffa0,
    0xffa0ff, 0xa0ffff, 0xffffa0, 0xa0ffa0, 0xffa0a0, 0xa0a0ff, 0x80c0a0,
    0xc0a080, 0xa080c0, 0x80a0c0, 0xc080a0, 0xa0c080, 0x8040a0, 0x40a080,
    0xa08040, 0x80a040, 0x4080a0, 0xa04080, 0x80e0a0, 0xe0a080, 0xa080e0,
    0x80a0e0, 0xe080a0, 0xa0e080, 0x8060a0, 0x60a080, 0xa08060, 0x80a060,
    0x6080a0, 0xa06080, 0x80a000, 0xa08000, 0xa00080, 0x8000a0, 0x00a080,
    0x0080a0, 0x80a080, 0xa08080, 0x8080a0, 0xa080a0, 0x80a0a0, 0xa0a080,
    0xc040a0, 0x40a0c0, 0xa0c040, 0xc0a040, 0x40c0a0, 0xa040c0, 0xc0e0a0,
    0xe0a0c0, 0xa0c0e0, 0xc0a0e0, 0xe0c0a0, 0xa0e0c0, 0xc060a0, 0x60a0c0,
    0xa0c060, 0xc0a060, 0x60c0a0, 0xa060c0, 0xc0a000, 0xa0c000, 0xa000c0,
    0xc000a0, 0x00a0c0, 0x00c0a0, 0xc0a0c0, 0xa0c0c0, 0xc0c0a0, 0xa0c0a0,
    0xc0a0a0, 0xa0a0c0, 0x40e0a0, 0xe0a040, 0xa040e0, 0x40a0e0, 0xe040a0,
    0xa0e040, 0x4060a0, 0x60a040, 0xa04060, 0x40a060, 0x6040a0, 0xa06040,
    0x40a000, 0xa04000, 0xa00040, 0x4000a0, 0x00a040, 0x0040a0, 0x40a040,
    0xa04040, 0x4040a0, 0xa040a0, 0x40a0a0, 0xa0a040, 0xe060a0, 0x60a0e0,
    0xa0e060, 0xe0a060, 0x60e0a0, 0xa060e0, 0xe0a000, 0xa0e000, 0xa000e0,
    0xe000a0, 0x00a0e0, 0x00e0a0, 0xe0a0e0, 0xa0e0e0, 0xe0e0a0, 0xa0e0a0,
    0xe0a0a0, 0xa0a0e0, 0x60a000, 0xa06000, 0xa00060, 0x6000a0, 0x00a060,
    0x0060a0, 0x60a060, 0xa06060, 0x6060a0, 0xa060a0, 0x60a0a0, 0xa0a060,
    0xa0a0a0, 0xa00000, 0x00a000, 0x0000a0, 0xa0a000, 0xa000a0, 0x00a0a0,
    0xff8020, 0x8020ff, 0x20ff80, 0xff2080, 0x80ff20, 0x2080ff, 0xffc020,
    0xc020ff, 0x20ffc0, 0xff20c0, 0xc0ff20, 0x20c0ff, 0xff4020, 0x4020ff,
    0x20ff40, 0xff2040, 0x40ff20, 0x2040ff, 0xffe020, 0xe020ff, 0x20ffe0,
    0xff20e0, 0xe0ff20, 0x20e0ff, 0xff6020, 0x6020ff, 0x20ff60, 0xff2060,
    0x60ff20, 0x2060ff, 0xffa020, 0xa020ff, 0x20ffa0, 0xff20a0, 0xa0ff20,
    0x20a0ff, 0xff2000, 0x20ff00, 0x2000ff, 0xff0020, 0x0020ff, 0x00ff20,
    0xff20ff, 0x20ffff, 0xffff20, 0x20ff20, 0xff2020, 0x2020ff, 0x80c020,
    0xc02080, 0x2080c0, 0x8020c0, 0xc08020, 0x20c080, 0x804020, 0x402080,
    0x208040, 0x802040, 0x408020, 0x204080, 0x80e020, 0xe02080, 0x2080e0,
    0x8020e0, 0xe08020, 0x20e080, 0x806020, 0x602080, 0x208060, 0x802060,
    0x608020, 0x206080, 0x80a020, 0xa02080, 0x2080a0, 0x8020a0, 0xa08020,
    0x20a080, 0x802000, 0x208000, 0x200080, 0x800020, 0x002080, 0x008020,
    0x802080, 0x208080, 0x808020, 0x208020, 0x802020, 0x202080, 0xc04020,
    0x4020c0, 0x20c040, 0xc02040, 0x40c020, 0x2040c0, 0xc0e020, 0xe020c0,
    0x20c0e0, 0xc020e0, 0xe0c020, 0x20e0c0, 0xc06020, 0x6020c0, 0x20c060,
    0xc02060, 0x60c020, 0x2060c0, 0xc0a020, 0xa020c0, 0x20c0a0, 0xc020a0,
    0xa0c020, 0x20a0c0, 0xc02000, 0x20c000, 0x2000c0, 0xc00020, 0x0020c0,
    0x00c020, 0xc020c0, 0x20c0c0, 0xc0c020, 0x20c020, 0xc02020, 0x2020c0,
    0x40e020, 0xe02040, 0x2040e0, 0x4020e0, 0xe04020, 0x20e040, 0x406020,
    0x602040, 0x204060, 0x402060, 0x604020, 0x206040, 0x40a020, 0xa02040,
    0x2040a0, 0x4020a0, 0xa04020, 0x20a040, 0x402000, 0x204000, 0x200040,
    0x400020, 0x002040, 0x004020, 0x402040, 0x204040, 0x404020, 0x204020,
    0x402020, 0x202040, 0xe06020, 0x6020e0, 0x20e060, 0xe02060, 0x60e020,
    0x2060e0, 0xe0a020, 0xa020e0, 0x20e0a0, 0xe020a0, 0xa0e020, 0x20a0e0,
    0xe02000, 0x20e000, 0x2000e0, 0xe00020, 0x0020e0, 0x00e020, 0xe020e0,
    0x20e0e0, 0xe0e020, 0x20e020, 0xe02020, 0x2020e0, 0x60a020, 0xa02060,
    0x2060a0, 0x6020a0, 0xa06020, 0x20a060, 0x602000, 0x206000, 0x200060,
    0x600020, 0x002060, 0x006020, 0x602060, 0x206060, 0x606020, 0x206020,
    0x602020, 0x202060, 0xa02000, 0x20a000, 0x2000a0, 0xa00020, 0x0020a0,
    0x00a020, 0xa020a0, 0x20a0a0, 0xa0a020, 0x20a020, 0xa02020, 0x2020a0,
    0x202020, 0x200000, 0x002000, 0x000020, 0x202000, 0x200020, 0x002020,
    0xff80f0, 0x80f0ff, 0xf0ff80, 0xfff080, 0x80fff0, 0xf080ff, 0xffc0f0,
    0xc0f0ff, 0xf0ffc0, 0xfff0c0, 0xc0fff0, 0xf0c0ff, 0xff40f0, 0x40f0ff,
    0xf0ff40, 0xfff040, 0x40fff0, 0xf040ff, 0xffe0f0, 0xe0f0ff, 0xf0ffe0,
    0xfff0e0, 0xe0fff0, 0xf0e0ff, 0xff60f0, 0x60f0ff, 0xf0ff60, 0xfff060,
    0x60fff0, 0xf060ff, 0xffa0f0, 0xa0f0ff, 0xf0ffa0, 0xfff0a0, 0xa0fff0,
    0xf0a0ff, 0xff20f0, 0x20f0ff, 0xf0ff20, 0xfff020, 0x20fff0, 0xf020ff,
    0xfff000, 0xf0ff00, 0xf000ff, 0xff00f0, 0x00f0ff, 0x00fff0, 0xfff0ff,
    0xf0ffff, 0xfffff0, 0xf0fff0, 0xfff0f0, 0xf0f0ff, 0x80c0f0, 0xc0f080,
    0xf080c0, 0x80f0c0, 0xc080f0, 0xf0c080, 0x8040f0, 0x40f080, 0xf08040,
    0x80f040, 0x4080f0, 0xf04080, 0x80e0f0, 0xe0f080, 0xf080e0, 0x80f0e0,
    0xe080f0, 0xf0e080, 0x8060f0, 0x60f080, 0xf08060, 0x80f060, 0x6080f0,
    0xf06080, 0x80a0f0, 0xa0f080, 0xf080a0, 0x80f0a0, 0xa080f0, 0xf0a080,
    0x8020f0, 0x20f080, 0xf08020, 0x80f020, 0x2080f0, 0xf02080, 0x80f000,
    0xf08000, 0xf00080, 0x8000f0, 0x00f080, 0x0080f0, 0x80f080, 0xf08080,
    0x8080f0, 0xf080f0, 0x80f0f0, 0xf0f080, 0xc040f0, 0x40f0c0, 0xf0c040,
    0xc0f040, 0x40c0f0, 0xf040c0, 0xc0e0f0, 0xe0f0c0, 0xf0c0e0, 0xc0f0e0,
    0xe0c0f0, 0xf0e0c0, 0xc060f0, 0x60f0c0, 0xf0c060, 0xc0f060, 0x60c0f0,
    0xf060c0, 0xc0a0f0, 0xa0f0c0, 0xf0c0a0, 0xc0f0a0, 0xa0c0f0, 0xf0a0c0,
    0xc020f0, 0x20f0c0, 0xf0c020, 0xc0f020, 0x20c0f0, 0xf020c0, 0xc0f000,
    0xf0c000, 0xf000c0, 0xc000f0, 0x00f0c0, 0x00c0f0, 0xc0f0c0, 0xf0c0c0,
    0xc0c0f0, 0xf0c0f0, 0xc0f0f0, 0xf0f0c0, 0x40e0f0, 0xe0f040, 0xf040e0,
    0x40f0e0, 0xe040f0, 0xf0e040, 0x4060f0, 0x60f040, 0xf04060, 0x40f060,
    0x6040f0, 0xf06040, 0x40a0f0, 0xa0f040, 0xf040a0, 0x40f0a0, 0xa040f0,
    0xf0a040, 0x4020f0, 0x20f040, 0xf04020, 0x40f020, 0x2040f0, 0xf02040,
    0x40f000, 0xf04000, 0xf00040, 0x4000f0, 0x00f040, 0x0040f0, 0x40f040,
    0xf04040, 0x4040f0, 0xf040f0, 0x40f0f0, 0xf0f040, 0xe060f0, 0x60f0e0,
    0xf0e060, 0xe0f060, 0x60e0f0, 0xf060e0, 0xe0a0f0, 0xa0f0e0, 0xf0e0a0,
    0xe0f0a0, 0xa0e0f0, 0xf0a0e0, 0xe020f0, 0x20f0e0, 0xf0e020, 0xe0f020,
    0x20e0f0, 0xf020e0, 0xe0f000, 0xf0e000, 0xf000e0, 0xe000f0, 0x00f0e0,
    0x00e0f0, 0xe0f0e0, 0xf0e0e0, 0xe0e0f0, 0xf0e0f0, 0xe0f0f0, 0xf0f0e0,
    0x60a0f0, 0xa0f060, 0xf060a0, 0x60f0a0, 0xa060f0, 0xf0a060, 0x6020f0,
    0x20f060, 0xf06020, 0x60f020, 0x2060f0, 0xf02060, 0x60f000, 0xf06000,
    0xf00060, 0x6000f0, 0x00f060, 0x0060f0, 0x60f060, 0xf06060, 0x6060f0,
    0xf060f0, 0x60f0f0, 0xf0f060, 0xa020f0, 0x20f0a0, 0xf0a020, 0xa0f020,
    0x20a0f0, 0xf020a0, 0xa0f000, 0xf0a000, 0xf000a0, 0xa000f0, 0x00f0a0,
    0x00a0f0, 0xa0f0a0, 0xf0a0a0, 0xa0a0f0, 0xf0a0f0, 0xa0f0f0, 0xf0f0a0,
    0x20f000, 0xf02000, 0xf00020, 0x2000f0, 0x00f020, 0x0020f0, 0x20f020,
    0xf02020, 0x2020f0, 0xf020f0, 0x20f0f0, 0xf0f020, 0xf0f0f0, 0xf00000,
    0x00f000, 0x0000f0, 0xf0f000, 0xf000f0, 0x00f0f0, 0xff80b0, 0x80b0ff,
    0xb0ff80, 0xffb080, 0x80ffb0, 0xb080ff, 0xffc0b0, 0xc0b0ff, 0xb0ffc0,
    0xffb0c0, 0xc0ffb0, 0xb0c0ff, 0xff40b0, 0x40b0ff, 0xb0ff40, 0xffb040,
    0x40ffb0, 0xb040ff, 0xffe0b0, 0xe0b0ff, 0xb0ffe0, 0xffb0e0, 0xe0ffb0,
    0xb0e0ff, 0xff60b0, 0x60b0ff, 0xb0ff60, 0xffb060, 0x60ffb0, 0xb060ff,
    0xffa0b0, 0xa0b0ff, 0xb0ffa0, 0xffb0a0, 0xa0ffb0, 0xb0a0ff, 0xff20b0,
    0x20b0ff, 0xb0ff20, 0xffb020, 0x20ffb0, 0xb020ff, 0xfff0b0, 0xf0b0ff,
    0xb0fff0, 0xffb0f0, 0xf0ffb0, 0xb0f0ff, 0xffb000, 0xb0ff00, 0xb000ff,
    0xff00b0, 0x00b0ff, 0x00ffb0, 0xffb0ff, 0xb0ffff, 0xffffb0, 0xb0ffb0,
    0xffb0b0, 0xb0b0ff, 0x80c0b0, 0xc0b080, 0xb080c0, 0x80b0c0, 0xc080b0,
    0xb0c080, 0x8040b0, 0x40b080, 0xb08040, 0x80b040, 0x4080b0, 0xb04080,
    0x80e0b0, 0xe0b080, 0xb080e0, 0x80b0e0, 0xe080b0, 0xb0e080, 0x8060b0,
    0x60b080, 0xb08060, 0x80b060, 0x6080b0, 0xb06080, 0x80a0b0, 0xa0b080,
    0xb080a0, 0x80b0a0, 0xa080b0, 0xb0a080, 0x8020b0, 0x20b080, 0xb08020,
    0x80b020, 0x2080b0, 0xb02080, 0x80f0b0, 0xf0b080, 0xb080f0, 0x80b0f0,
    0xf080b0, 0xb0f080, 0x80b000, 0xb08000, 0xb00080, 0x8000b0, 0x00b080,
    0x0080b0, 0x80b080, 0xb08080, 0x8080b0, 0xb080b0, 0x80b0b0, 0xb0b080,
    0xc040b0, 0x40b0c0, 0xb0c040, 0xc0b040, 0x40c0b0, 0xb040c0, 0xc0e0b0,
    0xe0b0c0, 0xb0c0e0, 0xc0b0e0, 0xe0c0b0, 0xb0e0c0, 0xc060b0, 0x60b0c0,
    0xb0c060, 0xc0b060, 0x60c0b0, 0xb060c0, 0xc0a0b0, 0xa0b0c0, 0xb0c0a0,
    0xc0b0a0, 0xa0c0b0, 0xb0a0c0, 0xc020b0, 0x20b0c0, 0xb0c020, 0xc0b020,
    0x20c0b0, 0xb020c0, 0xc0f0b0, 0xf0b0c0, 0xb0c0f0, 0xc0b0f0, 0xf0c0b0,
    0xb0f0c0, 0xc0b000, 0xb0c000, 0xb000c0, 0xc000b0, 0x00b0c0, 0x00c0b0,
    0xc0b0c0, 0xb0c0c0, 0xc0c0b0, 0xb0c0b0, 0xc0b0b0, 0xb0b0c0, 0x40e0b0,
    0xe0b040, 0xb040e0, 0x40b0e0, 0xe040b0, 0xb0e040, 0x4060b0, 0x60b040,
    0xb04060, 0x40b060, 0x6040b0, 0xb06040, 0x40a0b0, 0xa0b040, 0xb040a0,
    0x40b0a0, 0xa040b0, 0xb0a040, 0x4020b0, 0x20b040, 0xb04020, 0x40b020,
    0x2040b0, 0xb02040, 0x40f0b0, 0xf0b040, 0xb040f0, 0x40b0f0, 0xf040b0,
    0xb0f040, 0x40b000, 0xb04000, 0xb00040, 0x4000b0, 0x00b040, 0x0040b0,
    0x40b040, 0xb04040, 0x4040b0, 0xb040b0, 0x40b0b0, 0xb0b040, 0xe060b0,
    0x60b0e0, 0xb0e060, 0xe0b060, 0x60e0b0, 0xb060e0, 0xe0a0b0, 0xa0b0e0,
    0xb0e0a0, 0xe0b0a0, 0xa0e0b0, 0xb0a0e0, 0xe020b0, 0x20b0e0, 0xb0e020,
    0xe0b020, 0x20e0b0, 0xb020e0, 0xe0f0b0, 0xf0b0e0, 0xb0e0f0, 0xe0b0f0,
    0xf0e0b0, 0xb0f0e0, 0xe0b000, 0xb0e000, 0xb000e0, 0xe000b0, 0x00b0e0,
    0x00e0b0, 0xe0b0e0, 0xb0e0e0, 0xe0e0b0, 0xb0e0b0, 0xe0b0b0, 0xb0b0e0,
    0x60a0b0, 0xa0b060, 0xb060a0, 0x60b0a0, 0xa060b0, 0xb0a060, 0x6020b0,
    0x20b060, 0xb06020, 0x60b020, 0x2060b0, 0xb02060, 0x60f0b0, 0xf0b060,
    0xb060f0, 0x60b0f0, 0xf060b0, 0xb0f060, 0x60b000, 0xb06000, 0xb00060,
    0x6000b0, 0x00b060, 0x0060b0, 0x60b060, 0xb06060, 0x6060b0, 0xb060b0,
    0x60b0b0, 0xb0b060, 0xa020b0, 0x20b0a0, 0xb0a020, 0xa0b020, 0x20a0b0,
    0xb020a0, 0xa0f0b0, 0xf0b0a0, 0xb0a0f0, 0xa0b0f0, 0xf0a0b0, 0xb0f0a0,
    0xa0b000, 0xb0a000, 0xb000a0, 0xa000b0, 0x00b0a0, 0x00a0b0, 0xa0b0a0,
    0xb0a0a0, 0xa0a0b0, 0xb0a0b0, 0xa0b0b0, 0xb0b0a0, 0x20f0b0, 0xf0b020,
    0xb020f0, 0x20b0f0, 0xf020b0, 0xb0f020, 0x20b000, 0xb02000, 0xb00020,
    0x2000b0, 0x00b020, 0x0020b0, 0x20b020, 0xb02020, 0x2020b0, 0xb020b0,
    0x20b0b0, 0xb0b020, 0xf0b000, 0xb0f000, 0xb000f0, 0xf000b0, 0x00b0f0,
    0x00f0b0, 0xf0b0f0, 0xb0f0f0, 0xf0f0b0, 0xb0f0b0, 0xf0b0b0, 0xb0b0f0,
    0xb0b0b0, 0xb00000, 0x00b000, 0x0000b0, 0xb0b000, 0xb000b0, 0x00b0b0,
    0xff8050, 0x8050ff, 0x50ff80, 0xff5080, 0x80ff50, 0x5080ff, 0xffc050,
    0xc050ff, 0x50ffc0, 0xff50c0, 0xc0ff50, 0x50c0ff, 0xff4050, 0x4050ff,
    0x50ff40, 0xff5040, 0x40ff50, 0x5040ff, 0xffe050, 0xe050ff, 0x50ffe0,
    0xff50e0, 0xe0ff50, 0x50e0ff, 0xff6050, 0x6050ff, 0x50ff60, 0xff5060,
    0x60ff50, 0x5060ff, 0xffa050, 0xa050ff, 0x50ffa0, 0xff50a0, 0xa0ff50,
    0x50a0ff, 0xff2050, 0x2050ff, 0x50ff20, 0xff5020, 0x20ff50, 0x5020ff,
    0xfff050, 0xf050ff, 0x50fff0, 0xff50f0, 0xf0ff50, 0x50f0ff, 0xffb050,
    0xb050ff, 0x50ffb0, 0xff50b0, 0xb0ff50, 0x50b0ff, 0xff5000, 0x50ff00,
    0x5000ff, 0xff0050, 0x0050ff, 0x00ff50, 0xff50ff, 0x50ffff, 0xffff50,
    0x50ff50, 0xff5050, 0x5050ff, 0x80c050, 0xc05080, 0x5080c0, 0x8050c0,
    0xc08050, 0x50c080, 0x804050, 0x405080, 0x508040, 0x805040, 0x408050,
    0x504080, 0x80e050, 0xe05080, 0x5080e0, 0x8050e0, 0xe08050, 0x50e080,
    0x806050, 0x605080, 0x508060, 0x805060, 0x608050, 0x506080, 0x80a050,
    0xa05080, 0x5080a0, 0x8050a0, 0xa08050, 0x50a080, 0x802050, 0x205080,
    0x508020, 0x805020, 0x208050, 0x502080, 0x80f050, 0xf05080, 0x5080f0,
    0x8050f0, 0xf08050, 0x50f080, 0x80b050, 0xb05080, 0x5080b0, 0x8050b0,
    0xb08050, 0x50b080, 0x805000, 0x508000, 0x500080, 0x800050, 0x005080,
    0x008050, 0x805080, 0x508080, 0x808050, 0x508050, 0x805050, 0x505080,
    0xc04050, 0x4050c0, 0x50c040, 0xc05040, 0x40c050, 0x5040c0, 0xc0e050,
    0xe050c0, 0x50c0e0, 0xc050e0, 0xe0c050, 0x50e0c0, 0xc06050, 0x6050c0,
    0x50c060, 0xc05060, 0x60c050, 0x5060c0, 0xc0a050, 0xa050c0, 0x50c0a0,
    0xc050a0, 0xa0c050, 0x50a0c0, 0xc02050, 0x2050c0, 0x50c020, 0xc05020,
    0x20c050, 0x5020c0, 0xc0f050, 0xf050c0, 0x50c0f0, 0xc050f0, 0xf0c050,
    0x50f0c0, 0xc0b050, 0xb050c0, 0x50c0b0, 0xc050b0, 0xb0c050, 0x50b0c0,
    0xc05000, 0x50c000, 0x5000c0, 0xc00050, 0x0050c0, 0x00c050, 0xc050c0,
    0x50c0c0, 0xc0c050, 0x50c050, 0xc05050, 0x5050c0, 0x40e050, 0xe05040,
    0x5040e0, 0x4050e0, 0xe04050, 0x50e040, 0x406050, 0x605040, 0x504060,
    0x405060, 0x604050, 0x506040, 0x40a050, 0xa05040, 0x5040a0, 0x4050a0,
    0xa04050, 0x50a040, 0x402050, 0x205040, 0x504020, 0x405020, 0x204050,
    0x502040, 0x40f050, 0xf05040, 0x5040f0, 0x4050f0, 0xf04050, 0x50f040,
    0x40b050, 0xb05040, 0x5040b0, 0x4050b0, 0xb04050, 0x50b040, 0x405000,
    0x504000, 0x500040, 0x400050, 0x005040, 0x004050, 0x405040, 0x504040,
    0x404050, 0x504050, 0x405050, 0x505040, 0xe06050, 0x6050e0, 0x50e060,
    0xe05060, 0x60e050, 0x5060e0, 0xe0a050, 0xa050e0, 0x50e0a0, 0xe050a0,
    0xa0e050, 0x50a0e0, 0xe02050, 0x2050e0, 0x50e020, 0xe05020, 0x20e050,
    0x5020e0, 0xe0f050, 0xf050e0, 0x50e0f0, 0xe050f0, 0xf0e050, 0x50f0e0,
    0xe0b050, 0xb050e0, 0x50e0b0, 0xe050b0, 0xb0e050, 0x50b0e0, 0xe05000,
    0x50e000, 0x5000e0, 0xe00050, 0x0050e0, 0x00e050, 0xe050e0, 0x50e0e0,
    0xe0e050, 0x50e050, 0xe05050, 0x5050e0, 0x60a050, 0xa05060, 0x5060a0,
    0x6050a0, 0xa06050, 0x50a060, 0x602050, 0x205060, 0x506020, 0x605020,
    0x206050, 0x502060, 0x60f050, 0xf05060, 0x5060f0, 0x6050f0, 0xf06050,
    0x50f060, 0x60b050, 0xb05060, 0x5060b0, 0x6050b0, 0xb06050, 0x50b060,
    0x605000, 0x506000, 0x500060, 0x600050, 0x005060, 0x006050, 0x605060,
    0x506060, 0x606050, 0x506050, 0x605050, 0x505060, 0xa02050, 0x2050a0,
    0x50a020, 0xa05020, 0x20a050, 0x5020a0, 0xa0f050, 0xf050a0, 0x50a0f0,
    0xa050f0, 0xf0a050, 0x50f0a0, 0xa0b050, 0xb050a0, 0x50a0b0, 0xa050b0,
    0xb0a050, 0x50b0a0, 0xa05000, 0x50a000, 0x5000a0, 0xa00050, 0x0050a0,
    0x00a050, 0xa050a0, 0x50a0a0, 0xa0a050, 0x50a050, 0xa05050, 0x5050a0,
    0x20f050, 0xf05020, 0x5020f0, 0x2050f0, 0xf02050, 0x50f020, 0x20b050,
    0xb05020, 0x5020b0, 0x2050b0, 0xb02050, 0x50b020, 0x205000, 0x502000,
    0x500020, 0x200050, 0x005020, 0x002050, 0x205020, 0x502020, 0x202050,
    0x502050, 0x205050, 0x505020, 0xf0b050, 0xb050f0, 0x50f0b0, 0xf050b0,
    0xb0f050, 0x50b0f0, 0xf05000, 0x50f000, 0x5000f0, 0xf00050, 0x0050f0,
    0x00f050, 0xf050f0, 0x50f0f0, 0xf0f050, 0x50f050, 0xf05050, 0x5050f0,
    0xb05000, 0x50b000, 0x5000b0, 0xb00050, 0x0050b0, 0x00b050, 0xb050b0,
    0x50b0b0, 0xb0b050, 0x50b050, 0xb05050, 0x5050b0, 0x505050, 0x500000,
    0x005000, 0x000050, 0x505000, 0x500050, 0x005050, 0xff80d0, 0x80d0ff,
    0xd0ff80, 0xffd080, 0x80ffd0, 0xd080ff, 0xffc0d0, 0xc0d0ff, 0xd0ffc0,
    0xffd0c0, 0xc0ffd0, 0xd0c0ff, 0xff40d0, 0x40d0ff, 0xd0ff40, 0xffd040,
    0x40ffd0, 0xd040ff, 0xffe0d0, 0xe0d0ff, 0xd0ffe0, 0xffd0e0, 0xe0ffd0,
    0xd0e0ff, 0xff60d0, 0x60d0ff, 0xd0ff60, 0xffd060, 0x60ffd0, 0xd060ff,
    0xffa0d0, 0xa0d0ff, 0xd0ffa0, 0xffd0a0, 0xa0ffd0, 0xd0a0ff, 0xff20d0,
    0x20d0ff, 0xd0ff20, 0xffd020, 0x20ffd0, 0xd020ff, 0xfff0d0, 0xf0d0ff,
    0xd0fff0, 0xffd0f0, 0xf0ffd0, 0xd0f0ff, 0xffb0d0, 0xb0d0ff, 0xd0ffb0,
    0xffd0b0, 0xb0ffd0, 0xd0b0ff, 0xff50d0, 0x50d0ff, 0xd0ff50, 0xffd050,
    0x50ffd0, 0xd050ff, 0xffd000, 0xd0ff00, 0xd000ff, 0xff00d0, 0x00d0ff,
    0x00ffd0, 0xffd0ff, 0xd0ffff, 0xffffd0, 0xd0ffd0, 0xffd0d0, 0xd0d0ff,
    0x80c0d0, 0xc0d080, 0xd080c0, 0x80d0c0, 0xc080d0, 0xd0c080, 0x8040d0,
    0x40d080, 0xd08040, 0x80d040, 0x4080d0, 0xd04080, 0x80e0d0, 0xe0d080,
    0xd080e0, 0x80d0e0, 0xe080d0, 0xd0e080, 0x8060d0, 0x60d080, 0xd08060,
    0x80d060, 0x6080d0, 0xd06080, 0x80a0d0, 0xa0d080, 0xd080a0, 0x80d0a0,
    0xa080d0, 0xd0a080, 0x8020d0, 0x20d080, 0xd08020, 0x80d020, 0x2080d0,
    0xd02080, 0x80f0d0, 0xf0d080, 0xd080f0, 0x80d0f0, 0xf080d0, 0xd0f080,
    0x80b0d0, 0xb0d080, 0xd080b0, 0x80d0b0, 0xb080d0, 0xd0b080, 0x8050d0,
    0x50d080, 0xd08050, 0x80d050, 0x5080d0, 0xd05080, 0x80d000, 0xd08000,
    0xd00080, 0x8000d0, 0x00d080, 0x0080d0, 0x80d080, 0xd08080, 0x8080d0,
    0xd080d0, 0x80d0d0, 0xd0d080, 0xc040d0, 0x40d0c0, 0xd0c040, 0xc0d040,
    0x40c0d0, 0xd040c0, 0xc0e0d0, 0xe0d0c0, 0xd0c0e0, 0xc0d0e0, 0xe0c0d0,
    0xd0e0c0, 0xc060d0, 0x60d0c0, 0xd0c060, 0xc0d060, 0x60c0d0, 0xd060c0,
    0xc0a0d0, 0xa0d0c0, 0xd0c0a0, 0xc0d0a0, 0xa0c0d0, 0xd0a0c0, 0xc020d0,
    0x20d0c0, 0xd0c020, 0xc0d020, 0x20c0d0, 0xd020c0, 0xc0f0d0, 0xf0d0c0,
    0xd0c0f0, 0xc0d0f0, 0xf0c0d0, 0xd0f0c0, 0xc0b0d0, 0xb0d0c0, 0xd0c0b0,
    0xc0d0b0, 0xb0c0d0, 0xd0b0c0, 0xc050d0, 0x50d0c0, 0xd0c050, 0xc0d050,
    0x50c0d0, 0xd050c0, 0xc0d000, 0xd0c000, 0xd000c0, 0xc000d0, 0x00d0c0,
    0x00c0d0, 0xc0d0c0, 0xd0c0c0, 0xc0c0d0, 0xd0c0d0, 0xc0d0d0, 0xd0d0c0,
    0x40e0d0, 0xe0d040, 0xd040e0, 0x40d0e0, 0xe040d0, 0xd0e040, 0x4060d0,
    0x60d040, 0xd04060, 0x40d060, 0x6040d0, 0xd06040, 0x40a0d0, 0xa0d040,
    0xd040a0, 0x40d0a0, 0xa040d0, 0xd0a040, 0x4020d0, 0x20d040, 0xd04020,
    0x40d020, 0x2040d0, 0xd02040, 0x40f0d0, 0xf0d040, 0xd040f0, 0x40d0f0,
    0xf040d0, 0xd0f040, 0x40b0d0, 0xb0d040, 0xd040b0, 0x40d0b0, 0xb040d0,
    0xd0b040, 0x4050d0, 0x50d040, 0xd04050, 0x40d050, 0x5040d0, 0xd05040,
    0x40d000, 0xd04000, 0xd00040, 0x4000d0, 0x00d040, 0x0040d0, 0x40d040,
    0xd04040, 0x4040d0, 0xd040d0, 0x40d0d0, 0xd0d040, 0xe060d0, 0x60d0e0,
    0xd0e060, 0xe0d060, 0x60e0d0, 0xd060e0, 0xe0a0d0, 0xa0d0e0, 0xd0e0a0,
    0xe0d0a0, 0xa0e0d0, 0xd0a0e0, 0xe020d0, 0x20d0e0, 0xd0e020, 0xe0d020,
    0x20e0d0, 0xd020e0, 0xe0f0d0, 0xf0d0e0, 0xd0e0f0, 0xe0d0f0, 0xf0e0d0,
    0xd0f0e0, 0xe0b0d0, 0xb0d0e0, 0xd0e0b0, 0xe0d0b0, 0xb0e0d0, 0xd0b0e0,
    0xe050d0, 0x50d0e0, 0xd0e050, 0xe0d050, 0x50e0d0, 0xd050e0, 0xe0d000,
    0xd0e000, 0xd000e0, 0xe000d0, 0x00d0e0, 0x00e0d0, 0xe0d0e0, 0xd0e0e0,
    0xe0e0d0, 0xd0e0d0, 0xe0d0d0, 0xd0d0e0, 0x60a0d0, 0xa0d060, 0xd060a0,
    0x60d0a0, 0xa060d0, 0xd0a060, 0x6020d0, 0x20d060, 0xd06020, 0x60d020,
    0x2060d0, 0xd02060, 0x60f0d0, 0xf0d060, 0xd060f0, 0x60d0f0, 0xf060d0,
    0xd0f060, 0x60b0d0, 0xb0d060, 0xd060b0, 0x60d0b0, 0xb060d0, 0xd0b060,
    0x6050d0, 0x50d060, 0xd06050, 0x60d050, 0x5060d0, 0xd05060, 0x60d000,
    0xd06000, 0xd00060, 0x6000d0, 0x00d060, 0x0060d0, 0x60d060, 0xd06060,
    0x6060d0, 0xd060d0, 0x60d0d0, 0xd0d060, 0xa020d0, 0x20d0a0, 0xd0a020,
    0xa0d020, 0x20a0d0, 0xd020a0, 0xa0f0d0, 0xf0d0a0, 0xd0a0f0, 0xa0d0f0,
    0xf0a0d0, 0xd0f0a0, 0xa0b0d0, 0xb0d0a0, 0xd0a0b0, 0xa0d0b0, 0xb0a0d0,
    0xd0b0a0, 0xa050d0, 0x50d0a0, 0xd0a050, 0xa0d050, 0x50a0d0, 0xd050a0,
    0xa0d000, 0xd0a000, 0xd000a0, 0xa000d0, 0x00d0a0, 0x00a0d0, 0xa0d0a0,
    0xd0a0a0, 0xa0a0d0, 0xd0a0d0, 0xa0d0d0, 0xd0d0a0, 0x20f0d0, 0xf0d020,
    0xd020f0, 0x20d0f0, 0xf020d0, 0xd0f020, 0x20b0d0, 0xb0d020, 0xd020b0,
    0x20d0b0, 0xb020d0, 0xd0b020, 0x2050d0, 0x50d020, 0xd02050, 0x20d050,
    0x5020d0, 0xd05020, 0x20d000, 0xd02000, 0xd00020, 0x2000d0, 0x00d020,
    0x0020d0, 0x20d020, 0xd02020, 0x2020d0, 0xd020d0, 0x20d0d0, 0xd0d020,
    0xf0b0d0, 0xb0d0f0, 0xd0f0b0, 0xf0d0b0, 0xb0f0d0, 0xd0b0f0, 0xf050d0,
    0x50d0f0, 0xd0f050, 0xf0d050, 0x50f0d0, 0xd050f0, 0xf0d000, 0xd0f000,
    0xd000f0, 0xf000d0, 0x00d0f0, 0x00f0d0, 0xf0d0f0, 0xd0f0f0, 0xf0f0d0,
    0xd0f0d0, 0xf0d0d0, 0xd0d0f0, 0xb050d0, 0x50d0b0, 0xd0b050, 0xb0d050,
    0x50b0d0, 0xd050b0, 0xb0d000, 0xd0b000, 0xd000b0, 0xb000d0, 0x00d0b0,
    0x00b0d0, 0xb0d0b0, 0xd0b0b0, 0xb0b0d0, 0xd0b0d0, 0xb0d0d0, 0xd0d0b0,
    0x50d000, 0xd05000, 0xd00050, 0x5000d0, 0x00d050, 0x0050d0, 0x50d050,
    0xd05050, 0x5050d0, 0xd050d0, 0x50d0d0, 0xd0d050, 0xd0d0d0, 0xd00000,
    0x00d000, 0x0000d0, 0xd0d000, 0xd000d0, 0x00d0d0, 0xff8070, 0x8070ff,
    0x70ff80, 0xff7080, 0x80ff70, 0x7080ff, 0xffc070, 0xc070ff, 0x70ffc0,
    0xff70c0, 0xc0ff70, 0x70c0ff, 0xff4070, 0x4070ff, 0x70ff40, 0xff7040,
    0x40ff70, 0x7040ff, 0xffe070, 0xe070ff, 0x70ffe0, 0xff70e0, 0xe0ff70,
    0x70e0ff, 0xff6070, 0x6070ff, 0x70ff60, 0xff7060, 0x60ff70, 0x7060ff,
    0xffa070, 0xa070ff, 0x70ffa0, 0xff70a0, 0xa0ff70, 0x70a0ff, 0xff2070,
    0x2070ff, 0x70ff20, 0xff7020, 0x20ff70, 0x7020ff, 0xfff070, 0xf070ff,
    0x70fff0, 0xff70f0, 0xf0ff70, 0x70f0ff, 0xffb070, 0xb070ff, 0x70ffb0,
    0xff70b0, 0xb0ff70, 0x70b0ff, 0xff5070, 0x5070ff, 0x70ff50, 0xff7050,
    0x50ff70, 0x7050ff, 0xffd070, 0xd070ff, 0x70ffd0, 0xff70d0, 0xd0ff70,
    0x70d0ff, 0xff7000, 0x70ff00, 0x7000ff, 0xff0070, 0x0070ff, 0x00ff70,
    0xff70ff, 0x70ffff, 0xffff70, 0x70ff70, 0xff7070, 0x7070ff, 0x80c070,
    0xc07080, 0x7080c0, 0x8070c0, 0xc08070, 0x70c080, 0x804070, 0x407080,
    0x708040, 0x807040, 0x408070, 0x704080, 0x80e070, 0xe07080, 0x7080e0,
    0x8070e0, 0xe08070, 0x70e080, 0x806070, 0x607080, 0x708060, 0x807060,
    0x608070, 0x706080, 0x80a070, 0xa07080, 0x7080a0, 0x8070a0, 0xa08070,
    0x70a080, 0x802070, 0x207080, 0x708020, 0x807020, 0x208070, 0x702080,
    0x80f070, 0xf07080, 0x7080f0, 0x8070f0, 0xf08070, 0x70f080, 0x80b070,
    0xb07080, 0x7080b0, 0x8070b0, 0xb08070, 0x70b080, 0x805070, 0x507080,
    0x708050, 0x807050, 0x508070, 0x705080, 0x80d070, 0xd07080, 0x7080d0,
    0x8070d0, 0xd08070, 0x70d080, 0x807000, 0x708000, 0x700080, 0x800070,
    0x007080, 0x008070, 0x807080, 0x708080, 0x808070, 0x708070, 0x807070,
    0x707080, 0xc04070, 0x4070c0, 0x70c040, 0xc07040, 0x40c070, 0x7040c0,
    0xc0e070, 0xe070c0, 0x70c0e0, 0xc070e0, 0xe0c070, 0x70e0c0, 0xc06070,
    0x6070c0, 0x70c060, 0xc07060, 0x60c070, 0x7060c0, 0xc0a070, 0xa070c0,
    0x70c0a0, 0xc070a0, 0xa0c070, 0x70a0c0, 0xc02070, 0x2070c0, 0x70c020,
    0xc07020, 0x20c070, 0x7020c0, 0xc0f070, 0xf070c0, 0x70c0f0, 0xc070f0,
    0xf0c070, 0x70f0c0, 0xc0b070, 0xb070c0, 0x70c0b0, 0xc070b0, 0xb0c070,
    0x70b0c0, 0xc05070, 0x5070c0, 0x70c050, 0xc07050, 0x50c070, 0x7050c0,
    0xc0d070, 0xd070c0, 0x70c0d0, 0xc070d0, 0xd0c070, 0x70d0c0, 0xc07000,
    0x70c000, 0x7000c0, 0xc00070, 0x0070c0, 0x00c070, 0xc070c0, 0x70c0c0,
    0xc0c070, 0x70c070, 0xc07070, 0x7070c0, 0x40e070, 0xe07040, 0x7040e0,
    0x4070e0, 0xe04070, 0x70e040, 0x406070, 0x607040, 0x704060, 0x407060,
    0x604070, 0x706040, 0x40a070, 0xa07040, 0x7040a0, 0x4070a0, 0xa04070,
    0x70a040, 0x402070, 0x207040, 0x704020, 0x407020, 0x204070, 0x702040,
    0x40f070, 0xf07040, 0x7040f0, 0x4070f0, 0xf04070, 0x70f040, 0x40b070,
    0xb07040, 0x7040b0, 0x4070b0, 0xb04070, 0x70b040, 0x405070, 0x507040,
    0x704050, 0x407050, 0x504070, 0x705040, 0x40d070, 0xd07040, 0x7040d0,
    0x4070d0, 0xd04070, 0x70d040, 0x407000, 0x704000, 0x700040, 0x400070,
    0x007040, 0x004070, 0x407040, 0x704040, 0x404070, 0x704070, 0x407070,
    0x707040, 0xe06070, 0x6070e0, 0x70e060, 0xe07060, 0x60e070, 0x7060e0,
    0xe0a070, 0xa070e0, 0x70e0a0, 0xe070a0, 0xa0e070, 0x70a0e0, 0xe02070,
    0x2070e0, 0x70e020, 0xe07020, 0x20e070, 0x7020e0, 0xe0f070, 0xf070e0,
    0x70e0f0, 0xe070f0, 0xf0e070, 0x70f0e0, 0xe0b070, 0xb070e0, 0x70e0b0,
    0xe070b0, 0xb0e070, 0x70b0e0, 0xe05070, 0x5070e0, 0x70e050, 0xe07050,
    0x50e070, 0x7050e0, 0xe0d070, 0xd070e0, 0x70e0d0, 0xe070d0, 0xd0e070,
    0x70d0e0, 0xe07000, 0x70e000, 0x7000e0, 0xe00070, 0x0070e0, 0x00e070,
    0xe070e0, 0x70e0e0, 0xe0e070, 0x70e070, 0xe07070, 0x7070e0, 0x60a070,
    0xa07060, 0x7060a0, 0x6070a0, 0xa06070, 0x70a060, 0x602070, 0x207060,
    0x706020, 0x607020, 0x206070, 0x702060, 0x60f070, 0xf07060, 0x7060f0,
    0x6070f0, 0xf06070, 0x70f060, 0x60b070, 0xb07060, 0x7060b0, 0x6070b0,
    0xb06070, 0x70b060, 0x605070, 0x507060, 0x706050, 0x607050, 0x506070,
    0x705060, 0x60d070, 0xd07060, 0x7060d0, 0x6070d0, 0xd06070, 0x70d060,
    0x607000, 0x706000, 0x700060, 0x600070, 0x007060, 0x006070, 0x607060,
    0x706060, 0x606070, 0x706070, 0x607070, 0x707060, 0xa02070, 0x2070a0,
    0x70a020, 0xa07020, 0x20a070, 0x7020a0, 0xa0f070, 0xf070a0, 0x70a0f0,
    0xa070f0, 0xf0a070, 0x70f0a0, 0xa0b070, 0xb070a0, 0x70a0b0, 0xa070b0,
    0xb0a070, 0x70b0a0, 0xa05070, 0x5070a0, 0x70a050, 0xa07050, 0x50a070,
    0x7050a0, 0xa0d070, 0xd070a0, 0x70a0d0, 0xa070d0, 0xd0a070, 0x70d0a0,
    0xa07000, 0x70a000, 0x7000a0, 0xa00070, 0x0070a0, 0x00a070, 0xa070a0,
    0x70a0a0, 0xa0a070, 0x70a070, 0xa07070, 0x7070a0, 0x20f070, 0xf07020,
    0x7020f0, 0x2070f0, 0xf02070, 0x70f020, 0x20b070, 0xb07020, 0x7020b0,
    0x2070b0, 0xb02070, 0x70b020, 0x205070, 0x507020, 0x702050, 0x207050,
    0x502070, 0x705020, 0x20d070, 0xd07020, 0x7020d0, 0x2070d0, 0xd02070,
    0x70d020, 0x207000, 0x702000, 0x700020, 0x200070, 0x007020, 0x002070,
    0x207020, 0x702020, 0x202070, 0x702070, 0x207070, 0x707020, 0xf0b070,
    0xb070f0, 0x70f0b0, 0xf070b0, 0xb0f070, 0x70b0f0, 0xf05070, 0x5070f0,
    0x70f050, 0xf07050, 0x50f070, 0x7050f0, 0xf0d070, 0xd070f0, 0x70f0d0,
    0xf070d0, 0xd0f070, 0x70d0f0, 0xf07000, 0x70f000, 0x7000f0, 0xf00070,
    0x0070f0, 0x00f070, 0xf070f0, 0x70f0f0, 0xf0f070, 0x70f070, 0xf07070,
    0x7070f0, 0xb05070, 0x5070b0, 0x70b050, 0xb07050, 0x50b070, 0x7050b0,
    0xb0d070, 0xd070b0, 0x70b0d0, 0xb070d0, 0xd0b070, 0x70d0b0, 0xb07000,
    0x70b000, 0x7000b0, 0xb00070, 0x0070b0, 0x00b070, 0xb070b0, 0x70b0b0,
    0xb0b070, 0x70b070, 0xb07070, 0x7070b0, 0x50d070, 0xd07050, 0x7050d0,
    0x5070d0, 0xd05070, 0x70d050, 0x507000, 0x705000, 0x700050, 0x500070,
    0x007050, 0x005070, 0x507050, 0x705050, 0x505070, 0x705070, 0x507070,
    0x707050, 0xd07000, 0x70d000, 0x7000d0, 0xd00070, 0x0070d0, 0x00d070,
    0xd070d0, 0x70d0d0, 0xd0d070, 0x70d070, 0xd07070, 0x7070d0, 0x707070,
    0x700000, 0x007000, 0x000070, 0x707000, 0x700070, 0x007070, 0xff8030,
    0x8030ff, 0x30ff80, 0xff3080, 0x80ff30, 0x3080ff, 0xffc030, 0xc030ff,
    0x30ffc0, 0xff30c0, 0xc0ff30, 0x30c0ff, 0xff4030, 0x4030ff, 0x30ff40,
    0xff3040, 0x40ff30, 0x3040ff, 0xffe030, 0xe030ff, 0x30ffe0, 0xff30e0,
    0xe0ff30, 0x30e0ff, 0xff6030, 0x6030ff, 0x30ff60, 0xff3060, 0x60ff30,
    0x3060ff, 0xffa030, 0xa030ff, 0x30ffa0, 0xff30a0, 0xa0ff30, 0x30a0ff,
    0xff2030, 0x2030ff, 0x30ff20, 0xff3020, 0x20ff30, 0x3020ff, 0xfff030,
    0xf030ff, 0x30fff0, 0xff30f0, 0xf0ff30, 0x30f0ff, 0xffb030, 0xb030ff,
    0x30ffb0, 0xff30b0, 0xb0ff30, 0x30b0ff, 0xff5030, 0x5030ff, 0x30ff50,
    0xff3050, 0x50ff30, 0x3050ff, 0xffd030, 0xd030ff, 0x30ffd0, 0xff30d0,
    0xd0ff30, 0x30d0ff, 0xff7030, 0x7030ff, 0x30ff70, 0xff3070, 0x70ff30,
    0x3070ff, 0xff3000, 0x30ff00, 0x3000ff, 0xff0030, 0x0030ff, 0x00ff30,
    0xff30ff, 0x30ffff, 0xffff30, 0x30ff30, 0xff3030, 0x3030ff, 0x80c030,
    0xc03080, 0x3080c0, 0x8030c0, 0xc08030, 0x30c080, 0x804030, 0x403080,
    0x308040, 0x803040, 0x408030, 0x304080, 0x80e030, 0xe03080, 0x3080e0,
    0x8030e0, 0xe08030, 0x30e080, 0x806030, 0x603080, 0x308060, 0x803060,
    0x608030, 0x306080, 0x80a030, 0xa03080, 0x3080a0, 0x8030a0, 0xa08030,
    0x30a080, 0x802030, 0x203080, 0x308020, 0x803020, 0x208030, 0x302080,
    0x80f030, 0xf03080, 0x3080f0, 0x8030f0, 0xf08030, 0x30f080, 0x80b030,
    0xb03080, 0x3080b0, 0x8030b0, 0xb08030, 0x30b080, 0x805030, 0x503080,
    0x308050, 0x803050, 0x508030, 0x305080, 0x80d030, 0xd03080, 0x3080d0,
    0x8030d0, 0xd08030, 0x30d080, 0x807030, 0x703080, 0x308070, 0x803070,
    0x708030, 0x307080, 0x803000, 0x308000, 0x300080, 0x800030, 0x003080,
    0x008030, 0x803080, 0x308080, 0x808030, 0x308030, 0x803030, 0x303080,
    0xc04030, 0x4030c0, 0x30c040, 0xc03040, 0x40c030, 0x3040c0, 0xc0e030,
    0xe030c0, 0x30c0e0, 0xc030e0, 0xe0c030, 0x30e0c0, 0xc06030, 0x6030c0,
    0x30c060, 0xc03060, 0x60c030, 0x3060c0, 0xc0a030, 0xa030c0, 0x30c0a0,
    0xc030a0, 0xa0c030, 0x30a0c0, 0xc02030, 0x2030c0, 0x30c020, 0xc03020,
    0x20c030, 0x3020c0, 0xc0f030, 0xf030c0, 0x30c0f0, 0xc030f0, 0xf0c030,
    0x30f0c0, 0xc0b030, 0xb030c0, 0x30c0b0, 0xc030b0, 0xb0c030, 0x30b0c0,
    0xc05030, 0x5030c0, 0x30c050, 0xc03050, 0x50c030, 0x3050c0, 0xc0d030,
    0xd030c0, 0x30c0d0, 0xc030d0, 0xd0c030, 0x30d0c0, 0xc07030, 0x7030c0,
    0x30c070, 0xc03070, 0x70c030, 0x3070c0, 0xc03000, 0x30c000, 0x3000c0,
    0xc00030, 0x0030c0, 0x00c030, 0xc030c0, 0x30c0c0, 0xc0c030, 0x30c030,
    0xc03030, 0x3030c0, 0x40e030, 0xe03040, 0x3040e0, 0x4030e0, 0xe04030,
    0x30e040, 0x406030, 0x603040, 0x304060, 0x403060, 0x604030, 0x306040,
    0x40a030, 0xa03040, 0x3040a0, 0x4030a0, 0xa04030, 0x30a040, 0x402030,
    0x203040, 0x304020, 0x403020, 0x204030, 0x302040, 0x40f030, 0xf03040,
    0x3040f0, 0x4030f0, 0xf04030, 0x30f040, 0x40b030, 0xb03040, 0x3040b0,
    0x4030b0, 0xb04030, 0x30b040, 0x405030, 0x503040, 0x304050, 0x403050,
    0x504030, 0x305040, 0x40d030, 0xd03040, 0x3040d0, 0x4030d0, 0xd04030,
    0x30d040, 0x407030, 0x703040, 0x304070, 0x403070, 0x704030, 0x307040,
    0x403000, 0x304000, 0x300040, 0x400030, 0x003040, 0x004030, 0x403040,
    0x304040, 0x404030, 0x304030, 0x403030, 0x303040, 0xe06030, 0x6030e0,
    0x30e060, 0xe03060, 0x60e030, 0x3060e0, 0xe0a030, 0xa030e0, 0x30e0a0,
    0xe030a0, 0xa0e030, 0x30a0e0, 0xe02030, 0x2030e0, 0x30e020, 0xe03020,
    0x20e030, 0x3020e0, 0xe0f030, 0xf030e0, 0x30e0f0, 0xe030f0, 0xf0e030,
    0x30f0e0, 0xe0b030, 0xb030e0, 0x30e0b0, 0xe030b0, 0xb0e030, 0x30b0e0,
    0xe05030, 0x5030e0, 0x30e050, 0xe03050, 0x50e030, 0x3050e0, 0xe0d030,
    0xd030e0, 0x30e0d0, 0xe030d0, 0xd0e030, 0x30d0e0, 0xe07030, 0x7030e0,
    0x30e070, 0xe03070, 0x70e030, 0x3070e0, 0xe03000, 0x30e000, 0x3000e0,
    0xe00030, 0x0030e0, 0x00e030, 0xe030e0, 0x30e0e0, 0xe0e030, 0x30e030,
    0xe03030, 0x3030e0, 0x60a030, 0xa03060, 0x3060a0, 0x6030a0, 0xa06030,
    0x30a060, 0x602030, 0x203060, 0x306020, 0x603020, 0x206030, 0x302060,
    0x60f030, 0xf03060, 0x3060f0, 0x6030f0, 0xf06030, 0x30f060, 0x60b030,
    0xb03060, 0x3060b0, 0x6030b0, 0xb06030, 0x30b060, 0x605030, 0x503060,
    0x306050, 0x603050, 0x506030, 0x305060, 0x60d030, 0xd03060, 0x3060d0,
    0x6030d0, 0xd06030, 0x30d060, 0x607030, 0x703060, 0x306070, 0x603070,
    0x706030, 0x307060, 0x603000, 0x306000, 0x300060, 0x600030, 0x003060,
    0x006030, 0x603060, 0x306060, 0x606030, 0x306030, 0x603030, 0x303060,
    0xa02030, 0x2030a0, 0x30a020, 0xa03020, 0x20a030, 0x3020a0, 0xa0f030,
    0xf030a0, 0x30a0f0, 0xa030f0, 0xf0a030, 0x30f0a0, 0xa0b030, 0xb030a0,
    0x30a0b0, 0xa030b0, 0xb0a030, 0x30b0a0, 0xa05030, 0x5030a0, 0x30a050,
    0xa03050, 0x50a030, 0x3050a0, 0xa0d030, 0xd030a0, 0x30a0d0, 0xa030d0,
    0xd0a030, 0x30d0a0, 0xa07030, 0x7030a0, 0x30a070, 0xa03070, 0x70a030,
    0x3070a0, 0xa03000, 0x30a000, 0x3000a0, 0xa00030, 0x0030a0, 0x00a030,
    0xa030a0, 0x30a0a0, 0xa0a030, 0x30a030, 0xa03030, 0x3030a0, 0x20f030,
    0xf03020, 0x3020f0, 0x2030f0, 0xf02030, 0x30f020, 0x20b030, 0xb03020,
    0x3020b0, 0x2030b0, 0xb02030, 0x30b020, 0x205030, 0x503020, 0x302050,
    0x203050, 0x502030, 0x305020, 0x20d030, 0xd03020, 0x3020d0, 0x2030d0,
    0xd02030, 0x30d020, 0x207030, 0x703020, 0x302070, 0x203070, 0x702030,
    0x307020, 0x203000, 0x302000, 0x300020, 0x200030, 0x003020, 0x002030,
    0x203020, 0x302020, 0x202030, 0x302030, 0x203030, 0x303020, 0xf0b030,
    0xb030f0, 0x30f0b0, 0xf030b0, 0xb0f030, 0x30b0f0, 0xf05030, 0x5030f0,
    0x30f050, 0xf03050, 0x50f030, 0x3050f0, 0xf0d030, 0xd030f0, 0x30f0d0,
    0xf030d0, 0xd0f030, 0x30d0f0, 0xf07030, 0x7030f0, 0x30f070, 0xf03070,
    0x70f030, 0x3070f0, 0xf03000, 0x30f000, 0x3000f0, 0xf00030, 0x0030f0,
    0x00f030, 0xf030f0, 0x30f0f0, 0xf0f030, 0x30f030, 0xf03030, 0x3030f0,
    0xb05030, 0x5030b0, 0x30b050, 0xb03050, 0x50b030, 0x3050b0, 0xb0d030,
    0xd030b0, 0x30b0d0, 0xb030d0, 0xd0b030, 0x30d0b0, 0xb07030, 0x7030b0,
    0x30b070, 0xb03070, 0x70b030, 0x3070b0, 0xb03000, 0x30b000, 0x3000b0,
    0xb00030, 0x0030b0, 0x00b030, 0xb030b0, 0x30b0b0, 0xb0b030, 0x30b030,
    0xb03030, 0x3030b0, 0x50d030, 0xd03050, 0x3050d0, 0x5030d0, 0xd05030,
    0x30d050, 0x507030, 0x703050, 0x305070, 0x503070, 0x705030, 0x307050,
    0x503000, 0x305000, 0x300050, 0x500030, 0x003050, 0x005030, 0x503050,
    0x305050, 0x505030, 0x305030, 0x503030, 0x303050, 0xd07030, 0x7030d0,
    0x30d070, 0xd03070, 0x70d030, 0x3070d0, 0xd03000, 0x30d000, 0x3000d0,
    0xd00030, 0x0030d0, 0x00d030, 0xd030d0, 0x30d0d0, 0xd0d030, 0x30d030,
    0xd03030, 0x3030d0, 0x703000, 0x307000, 0x300070, 0x700030, 0x003070,
    0x007030, 0x703070, 0x307070, 0x707030, 0x307030, 0x703030, 0x303070,
    0x303030, 0x300000, 0x003000, 0x000030, 0x303000, 0x300030, 0x003030,
    0xff8090, 0x8090ff, 0x90ff80, 0xff9080, 0x80ff90, 0x9080ff, 0xffc090,
    0xc090ff, 0x90ffc0, 0xff90c0, 0xc0ff90, 0x90c0ff, 0xff4090, 0x4090ff,
    0x90ff40, 0xff9040, 0x40ff90, 0x9040ff, 0xffe090, 0xe090ff, 0x90ffe0,
    0xff90e0, 0xe0ff90, 0x90e0ff, 0xff6090, 0x6090ff, 0x90ff60, 0xff9060,
    0x60ff90, 0x9060ff, 0xffa090, 0xa090ff, 0x90ffa0, 0xff90a0, 0xa0ff90,
    0x90a0ff, 0xff2090, 0x2090ff, 0x90ff20, 0xff9020, 0x20ff90, 0x9020ff,
    0xfff090, 0xf090ff, 0x90fff0, 0xff90f0, 0xf0ff90, 0x90f0ff, 0xffb090,
    0xb090ff, 0x90ffb0, 0xff90b0, 0xb0ff90, 0x90b0ff, 0xff5090, 0x5090ff,
    0x90ff50, 0xff9050, 0x50ff90, 0x9050ff, 0xffd090, 0xd090ff, 0x90ffd0,
    0xff90d0, 0xd0ff90, 0x90d0ff, 0xff7090, 0x7090ff, 0x90ff70, 0xff9070,
    0x70ff90, 0x9070ff, 0xff3090, 0x3090ff, 0x90ff30, 0xff9030, 0x30ff90,
    0x9030ff, 0xff9000, 0x90ff00, 0x9000ff, 0xff0090, 0x0090ff, 0x00ff90,
    0xff90ff, 0x90ffff, 0xffff90, 0x90ff90, 0xff9090, 0x9090ff, 0x80c090,
    0xc09080, 0x9080c0, 0x8090c0, 0xc08090, 0x90c080, 0x804090, 0x409080,
    0x908040, 0x809040, 0x408090, 0x904080, 0x80e090, 0xe09080, 0x9080e0,
    0x8090e0, 0xe08090, 0x90e080, 0x806090, 0x609080, 0x908060, 0x809060,
    0x608090, 0x906080, 0x80a090, 0xa09080, 0x9080a0, 0x8090a0, 0xa08090,
    0x90a080, 0x802090, 0x209080, 0x908020, 0x809020, 0x208090, 0x902080,
    0x80f090, 0xf09080, 0x9080f0, 0x8090f0, 0xf08090, 0x90f080, 0x80b090,
    0xb09080, 0x9080b0, 0x8090b0, 0xb08090, 0x90b080, 0x805090, 0x509080,
    0x908050, 0x809050, 0x508090, 0x905080, 0x80d090, 0xd09080, 0x9080d0,
    0x8090d0, 0xd08090, 0x90d080, 0x807090, 0x709080, 0x908070, 0x809070,
    0x708090, 0x907080, 0x803090, 0x309080, 0x908030, 0x809030, 0x308090,
    0x903080, 0x809000, 0x908000, 0x900080, 0x800090, 0x009080, 0x008090,
    0x809080, 0x908080, 0x808090, 0x908090, 0x809090, 0x909080, 0xc04090,
    0x4090c0, 0x90c040, 0xc09040, 0x40c090, 0x9040c0, 0xc0e090, 0xe090c0,
    0x90c0e0, 0xc090e0, 0xe0c090, 0x90e0c0, 0xc06090, 0x6090c0, 0x90c060,
    0xc09060, 0x60c090, 0x9060c0, 0xc0a090, 0xa090c0, 0x90c0a0, 0xc090a0,
    0xa0c090, 0x90a0c0, 0xc02090, 0x2090c0, 0x90c020, 0xc09020, 0x20c090,
    0x9020c0, 0xc0f090, 0xf090c0, 0x90c0f0, 0xc090f0, 0xf0c090, 0x90f0c0,
    0xc0b090, 0xb090c0, 0x90c0b0, 0xc090b0, 0xb0c090, 0x90b0c0, 0xc05090,
    0x5090c0, 0x90c050, 0xc09050, 0x50c090, 0x9050c0, 0xc0d090, 0xd090c0,
    0x90c0d0, 0xc090d0, 0xd0c090, 0x90d0c0, 0xc07090, 0x7090c0, 0x90c070,
    0xc09070, 0x70c090, 0x9070c0, 0xc03090, 0x3090c0, 0x90c030, 0xc09030,
    0x30c090, 0x9030c0, 0xc09000, 0x90c000, 0x9000c0, 0xc00090, 0x0090c0,
    0x00c090, 0xc090c0, 0x90c0c0, 0xc0c090, 0x90c090, 0xc09090, 0x9090c0,
    0x40e090, 0xe09040, 0x9040e0, 0x4090e0, 0xe04090, 0x90e040, 0x406090,
    0x609040, 0x904060, 0x409060, 0x604090, 0x906040, 0x40a090, 0xa09040,
    0x9040a0, 0x4090a0, 0xa04090, 0x90a040, 0x402090, 0x209040, 0x904020,
    0x409020, 0x204090, 0x902040, 0x40f090, 0xf09040, 0x9040f0, 0x4090f0,
    0xf04090, 0x90f040, 0x40b090, 0xb09040, 0x9040b0, 0x4090b0, 0xb04090,
    0x90b040, 0x405090, 0x509040, 0x904050, 0x409050, 0x504090, 0x905040,
    0x40d090, 0xd09040, 0x9040d0, 0x4090d0, 0xd04090, 0x90d040, 0x407090,
    0x709040, 0x904070, 0x409070, 0x704090, 0x907040, 0x403090, 0x309040,
    0x904030, 0x409030, 0x304090, 0x903040, 0x409000, 0x904000, 0x900040,
    0x400090, 0x009040, 0x004090, 0x409040, 0x904040, 0x404090, 0x904090,
    0x409090, 0x909040, 0xe06090, 0x6090e0, 0x90e060, 0xe09060, 0x60e090,
    0x9060e0, 0xe0a090, 0xa090e0, 0x90e0a0, 0xe090a0, 0xa0e090, 0x90a0e0,
    0xe02090, 0x2090e0, 0x90e020, 0xe09020, 0x20e090, 0x9020e0, 0xe0f090,
    0xf090e0, 0x90e0f0, 0xe090f0, 0xf0e090, 0x90f0e0, 0xe0b090, 0xb090e0,
    0x90e0b0, 0xe090b0, 0xb0e090, 0x90b0e0, 0xe05090, 0x5090e0, 0x90e050,
    0xe09050, 0x50e090, 0x9050e0, 0xe0d090, 0xd090e0, 0x90e0d0, 0xe090d0,
    0xd0e090, 0x90d0e0, 0xe07090, 0x7090e0, 0x90e070, 0xe09070, 0x70e090,
    0x9070e0, 0xe03090, 0x3090e0, 0x90e030, 0xe09030, 0x30e090, 0x9030e0,
    0xe09000, 0x90e000, 0x9000e0, 0xe00090, 0x0090e0, 0x00e090, 0xe090e0,
    0x90e0e0, 0xe0e090, 0x90e090, 0xe09090, 0x9090e0, 0x60a090, 0xa09060,
    0x9060a0, 0x6090a0, 0xa06090, 0x90a060, 0x602090, 0x209060, 0x906020,
    0x609020, 0x206090, 0x902060, 0x60f090, 0xf09060, 0x9060f0, 0x6090f0,
    0xf06090, 0x90f060, 0x60b090, 0xb09060, 0x9060b0, 0x6090b0, 0xb06090,
    0x90b060, 0x605090, 0x509060, 0x906050, 0x609050, 0x506090, 0x905060,
    0x60d090, 0xd09060, 0x9060d0, 0x6090d0, 0xd06090, 0x90d060, 0x607090,
    0x709060, 0x906070, 0x609070, 0x706090, 0x907060, 0x603090, 0x309060,
    0x906030, 0x609030, 0x306090, 0x903060, 0x609000, 0x906000, 0x900060,
    0x600090, 0x009060, 0x006090, 0x609060, 0x906060, 0x606090, 0x906090,
    0x609090, 0x909060, 0xa02090, 0x2090a0, 0x90a020, 0xa09020, 0x20a090,
    0x9020a0, 0xa0f090, 0xf090a0, 0x90a0f0, 0xa090f0, 0xf0a090, 0x90f0a0,
    0xa0b090, 0xb090a0, 0x90a0b0, 0xa090b0, 0xb0a090, 0x90b0a0, 0xa05090,
    0x5090a0, 0x90a050, 0xa09050, 0x50a090, 0x9050a0, 0xa0d090, 0xd090a0,
    0x90a0d0, 0xa090d0, 0xd0a090, 0x90d0a0, 0xa07090, 0x7090a0, 0x90a070,
    0xa09070, 0x70a090, 0x9070a0, 0xa03090, 0x3090a0, 0x90a030, 0xa09030,
    0x30a090, 0x9030a0, 0xa09000, 0x90a000, 0x9000a0, 0xa00090, 0x0090a0,
    0x00a090, 0xa090a0, 0x90a0a0, 0xa0a090, 0x90a090, 0xa09090, 0x9090a0,
    0x20f090, 0xf09020, 0x9020f0, 0x2090f0, 0xf02090, 0x90f020, 0x20b090,
    0xb09020, 0x9020b0, 0x2090b0, 0xb02090, 0x90b020, 0x205090, 0x509020,
    0x902050, 0x209050, 0x502090, 0x905020, 0x20d090, 0xd09020, 0x9020d0,
    0x2090d0, 0xd02090, 0x90d020, 0x207090, 0x709020, 0x902070, 0x209070,
    0x702090, 0x907020, 0x203090, 0x309020, 0x902030, 0x209030, 0x302090,
    0x903020, 0x209000, 0x902000, 0x900020, 0x200090, 0x009020, 0x002090,
    0x209020, 0x902020, 0x202090, 0x902090, 0x209090, 0x909020, 0xf0b090,
    0xb090f0, 0x90f0b0, 0xf090b0, 0xb0f090, 0x90b0f0, 0xf05090, 0x5090f0,
    0x90f050, 0xf09050, 0x50f090, 0x9050f0, 0xf0d090, 0xd090f0, 0x90f0d0,
    0xf090d0, 0xd0f090, 0x90d0f0, 0xf07090, 0x7090f0, 0x90f070, 0xf09070,
    0x70f090, 0x9070f0, 0xf03090, 0x3090f0, 0x90f030, 0xf09030, 0x30f090,
    0x9030f0, 0xf09000, 0x90f000, 0x9000f0, 0xf00090, 0x0090f0, 0x00f090,
    0xf090f0, 0x90f0f0, 0xf0f090, 0x90f090, 0xf09090, 0x9090f0, 0xb05090,
    0x5090b0, 0x90b050, 0xb09050, 0x50b090, 0x9050b0, 0xb0d090, 0xd090b0,
    0x90b0d0, 0xb090d0, 0xd0b090, 0x90d0b0, 0xb07090, 0x7090b0, 0x90b070,
    0xb09070, 0x70b090, 0x9070b0, 0xb03090, 0x3090b0, 0x90b030, 0xb09030,
    0x30b090, 0x9030b0, 0xb09000, 0x90b000, 0x9000b0, 0xb00090, 0x0090b0,
    0x00b090, 0xb090b0, 0x90b0b0, 0xb0b090, 0x90b090, 0xb09090, 0x9090b0,
    0x50d090, 0xd09050, 0x9050d0, 0x5090d0, 0xd05090, 0x90d050, 0x507090,
    0x709050, 0x905070, 0x509070, 0x705090, 0x907050, 0x503090, 0x309050,
    0x905030, 0x509030, 0x305090, 0x903050, 0x509000, 0x905000, 0x900050,
    0x500090, 0x009050, 0x005090, 0x509050, 0x905050, 0x505090, 0x905090,
    0x509090, 0x909050, 0xd07090, 0x7090d0, 0x90d070, 0xd09070, 0x70d090,
    0x9070d0, 0xd03090, 0x3090d0, 0x90d030, 0xd09030, 0x30d090, 0x9030d0,
    0xd09000, 0x90d000, 0x9000d0, 0xd00090, 0x0090d0, 0x00d090, 0xd090d0,
    0x90d0d0, 0xd0d090, 0x90d090, 0xd09090, 0x9090d0, 0x703090, 0x309070,
    0x907030, 0x709030, 0x307090, 0x903070, 0x709000, 0x907000, 0x900070,
    0x700090, 0x009070, 0x007090, 0x709070, 0x907070, 0x707090, 0x907090,
    0x709090, 0x909070, 0x309000, 0x903000, 0x900030, 0x300090, 0x009030,
    0x003090, 0x309030, 0x903030, 0x303090, 0x903090, 0x309090, 0x909030,
    0x909090, 0x900000, 0x009000, 0x000090, 0x909000, 0x900090, 0x009090,
    0xff8010
};

static unsigned char const pickMapComponent[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0,
    0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0,
    0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static unsigned char const pickMapComponent444[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x00, 0x00, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0x00, 0x00, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0,
    0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb0,
    0xb0, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#define MAX_PICK_COLORS 4096

// Get the value at "index" to use for color picking.  Returns a zero
// QRgb when the table has been exhausted.
QRgb qt_qgl_pick_color(int index)
{
    if (index >= 0 && index < MAX_PICK_COLORS)
        return QRgb(pickColors[index] | 0xff000000);
    else
        return 0;
}

// Normalize a color that was picked out of a screen color buffer
// so that it is a better match for something that was generated
// by qt_qgl_pick_color().  Rounding discrepancies in the
// low bits due to floating-point conversions are factored out.
QRgb qt_qgl_normalize_pick_color(QRgb color, bool is444)
{
    int red, green, blue;
    if (!is444) {
        // RGB565, RGB555, and RGB888 screens (alpha is ignored).
        red = pickMapComponent[qRed(color)];
        green = pickMapComponent[qGreen(color)];
        blue = pickMapComponent[qBlue(color)];
    } else {
        // RGB444 screens need a little more care when normalizing.
        red = pickMapComponent444[qRed(color)];
        green = pickMapComponent444[qGreen(color)];
        blue = pickMapComponent444[qBlue(color)];
    }
    return qRgb(red, green, blue);
}

QT_END_NAMESPACE

#else // QGL_GENERATOR_PROGRAM

#include <stdio.h>

static unsigned char singlePatterns[] = {
    1, 1, 1,

    1, 0, 0,
    0, 1, 0,
    0, 0, 1,
    1, 1, 0,
    1, 0, 1,
    0, 1, 1
};
#define NUM_SINGLE_PATTERNS 7

static unsigned char doublePatterns[] = {
    1, 2, 0,
    2, 1, 0,
    2, 0, 1,
    1, 0, 2,
    0, 2, 1,
    0, 1, 2,

    1, 2, 1,
    2, 1, 1,
    1, 1, 2,
    2, 1, 2,
    1, 2, 2,
    2, 2, 1
};
#define NUM_DOUBLE_PATTERNS 12

static unsigned char triplePatterns[] = {
    1, 2, 3,
    2, 3, 1,
    3, 1, 2,
    1, 3, 2,
    2, 1, 3,
    3, 2, 1
};
#define NUM_TRIPLE_PATTERNS 6

static unsigned char values[] = {
    0x00,
    0xff, 0x80, 0xc0, 0x40, 0xe0, 0x60, 0xa0, 0x20,
    0xf0, 0xb0, 0x50, 0xd0, 0x70, 0x30, 0x90, 0x10
};
#define NUM_VALUES 16
#define NUM_VALUES_444 10

#define MAX_GENERATE 4096

static unsigned char used[17][17][17];
static int generated = 0;

static void genPattern(int red, int green, int blue)
{
    ++red;
    ++green;
    ++blue;
    if (used[red][green][blue] || generated >= MAX_GENERATE)
    return;
    used[red][green][blue] = 1;
    if ((generated % 7) == 0)
    printf("\n    ");
    printf("0x%02x%02x%02x", values[red], values[green], values[blue]);
    ++generated;
    if (generated < MAX_GENERATE && (generated % 7) != 0)
    printf(", ");
    else if (generated < MAX_GENERATE)
    printf(",");
}

static void genSinglePatterns(int value)
{
    int index, red, green, blue;
    for (index = 0; index < NUM_SINGLE_PATTERNS; ++index) {
    if (singlePatterns[index * 3] == 0)
        red = -1;
    else
        red = value;
    if (singlePatterns[index * 3 + 1] == 0)
        green = -1;
    else
        green = value;
    if (singlePatterns[index * 3 + 2] == 0)
        blue = -1;
    else
        blue = value;
    genPattern(red, green, blue);
    }
}

static void genDoublePatterns(int value1, int value2)
{
    int index, red, green, blue;
    for (index = 0; index < NUM_DOUBLE_PATTERNS; ++index) {
    if (doublePatterns[index * 3] == 0)
        red = -1;
    else if (doublePatterns[index * 3] == 1)
        red = value1;
    else
        red = value2;
    if (doublePatterns[index * 3 + 1] == 0)
        green = -1;
    else if (doublePatterns[index * 3 + 1] == 1)
        green = value1;
    else
        green = value2;
    if (doublePatterns[index * 3 + 2] == 0)
        blue = -1;
    else if (doublePatterns[index * 3 + 2] == 1)
        blue = value1;
    else
        blue = value2;
    genPattern(red, green, blue);
    }
}

static void genTriplePatterns(int value1, int value2, int value3)
{
    int index, red, green, blue;
    for (index = 0; index < NUM_TRIPLE_PATTERNS; ++index) {
    if (triplePatterns[index * 3] == 0)
        red = -1;
    else if (triplePatterns[index * 3] == 1)
        red = value1;
    else if (triplePatterns[index * 3] == 2)
        red = value2;
    else
        red = value3;
    if (triplePatterns[index * 3 + 1] == 0)
        green = -1;
    else if (triplePatterns[index * 3 + 1] == 1)
        green = value1;
    else if (triplePatterns[index * 3 + 1] == 2)
        green = value2;
    else
        green = value3;
    if (triplePatterns[index * 3 + 2] == 0)
        blue = -1;
    else if (triplePatterns[index * 3 + 2] == 1)
        blue = value1;
    else if (triplePatterns[index * 3 + 2] == 2)
        blue = value2;
    else
        blue = value3;
    genPattern(red, green, blue);
    }
}

static void genPatternRange(int limit)
{
    // This will generate 4912 unique color values which are
    // reasonably well-spaced in the RGB color cube.
    int first, second, third;
    for (first = 0; first < limit; ++first) {
    genSinglePatterns(first);
    for (second = first + 1; second < limit; ++second) {
        genDoublePatterns(first, second);
        for (third = second + 1; third < limit; ++third) {
        genTriplePatterns(first, second, third);
        }
    }
    }
}

static void generateComponentMap(void)
{
    int map[256];
    int index, value, index2;

    for (index = 0; index < 256; ++index)
    map[index] = 0;

    for (index = 0; index < NUM_VALUES; ++index) {
    value = values[index + 1];
    for (index2 = value - 8; index2 < (value + 8); ++index2) {
        if (index2 >= 0 && index2 < 256)
        map[index2] = value;
    }
    }

    for (index = 0; index < 256; ++index) {
    if ((index % 8) == 0)
        printf("    ");
    printf("0x%02x", map[index]);
    if (index < 255)
        printf(",");
    if ((index % 8) == 7)
        printf("\n");
    else if (index < 255)
        printf(" ");
    }

    // Validate the reversibility of RGB565 and RGB555 mappings.
    for (index = 0; index < 17; ++index) {
    // Integer truncation test - 5-bit for red and blue (and green RGB555).
    value = values[index] * 31 / 255;
    index2 = value * 255 / 31;
    if (values[index] != map[index2]) {
        qWarning("RGB565 (i5) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Integer truncation test - 6-bit for green.
    value = values[index] * 63 / 255;
    index2 = value * 255 / 63;
    if (values[index] != map[index2]) {
        qWarning("RGB565 (i6) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Floating point rounding test - 5-bit for red and blue.
    value = (int)((values[index] * 31.0 / 255.0) + 0.5);
    index2 = (int)((value * 255.0 / 31.0) + 0.5);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (f5) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Floating point rounding test - 6-bit for green.
    value = (int)((values[index] * 63.0 / 255.0) + 0.5);
    index2 = (int)((value * 255.0 / 63.0) + 0.5);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (f6) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Test 5-bit to 8-bit conversion using doubling (ABCDE -> ABCDEABC).
    value = values[index] * 31 / 255;
    index2 = (value << 3) | (value >> 2);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (di5) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }
    value = (int)((values[index] * 31.0 / 255.0) + 0.5);
    index2 = (value << 3) | (value >> 2);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (df5) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Test 6-bit to 8-bit conversion using doubling (ABCDEF -> ABCDEFAB).
    value = values[index] * 63 / 255;
    index2 = (value << 2) | (value >> 4);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (di6) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }
    value = (int)((values[index] * 63.0 / 255.0) + 0.5);
    index2 = (value << 2) | (value >> 4);
    if (values[index] != map[index2]) {
        qWarning("RGB565 (df6) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }
    }
}

static void generateComponentMap444(void)
{
    int map[256];
    int index, value, index2;

    for (index = 0; index < 256; ++index)
    map[index] = 0;

    // Populate mappings for integer conversion with truncation.
    for (index = 0; index < NUM_VALUES_444; ++index) {
    value = values[index + 1] * 15 / 255;
    value = value * 255 / 15;
    if (value > 255)
        value = 255;
    else if (value < 0)
        value = 0;
    for (index2 = value - 8; index2 < (value + 7); ++index2) {
        if (index2 >= 0 && index2 < 256)
        map[index2] = values[index + 1];
    }
    }

    // Add some extra mappings for floating-point conversion with rounding.
    for (index = 0; index < NUM_VALUES_444; ++index) {
    value = (int)((values[index + 1] * 15.0 / 255.0) + 0.5);
    value = (int)((value * 255.0 / 15.0) + 0.5);
    if (value > 255)
        value = 255;
    else if (value < 0)
        value = 0;
    for (index2 = value - 8; index2 < (value + 7); ++index2) {
        if (index2 >= 0 && index2 < 256 && map[index2] == 0)
        map[index2] = values[index + 1];
    }
    }

    for (index = 0; index < 256; ++index) {
    if ((index % 8) == 0)
        printf("    ");
    printf("0x%02x", map[index]);
    if (index < 255)
        printf(",");
    if ((index % 8) == 7)
        printf("\n");
    else if (index < 255)
        printf(" ");
    }

    // Validate the reversibility of RGB444 mappings.
    for (index = 0; index <= NUM_VALUES_444; ++index) {
    // Integer truncation test.
    value = values[index] * 15 / 255;
    index2 = value * 255 / 15;
    if (values[index] != map[index2]) {
        qWarning("RGB444 (i) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Floating point rounding test.
    value = (int)((values[index] * 15.0 / 255.0) + 0.5);
    index2 = (int)((value * 255.0 / 15.0) + 0.5);
    if (values[index] != map[index2]) {
        qWarning("RGB444 (f) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }

    // Test 4-bit to 8-bit conversion using doubling (ABCD -> ABCDABCD).
    value = values[index] * 15 / 255;
    index2 = value | (value << 4);
    if (values[index] != map[index2]) {
        qWarning("RGB444 (di) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }
    value = (int)((values[index] * 15.0 / 255.0) + 0.5);
    index2 = value | (value << 4);
    if (values[index] != map[index2]) {
        qWarning("RGB444 (df) failure: 0x%02X -> 0x%02X -> 0x%02X\n",
            values[index], index2, map[index2]);
    }
    }
}

int main(int argc, char *argv[])
{
    int limit;

    // Run the generator multiple times using more and more of
    // the elements in the "values" table, and limit to a maximum
    // of 1024 colors.
    //
    // This will sort the output so that colors that involve elements
    // early in the table will be generated first.  All combinations
    // of early elements are exhausted before moving onto later values.
    //
    // The result of this sorting should be to maximize the spacing
    // between colors that appear early in the generated output.
    // This should produce better results for color picking on
    // low-end devices with RGB565, RGB555, and RGB444 displays.
    printf("static int const pickColors[%d] = {", MAX_GENERATE);
    for (limit = 1; limit <= NUM_VALUES; ++limit)
    genPatternRange(limit);
    printf("\n};\n\n");

    // Generate a component mapping table for mapping 8-bit RGB
    // components to the nearest normalized value.
    printf("static unsigned char const pickMapComponent[256] = {\n");
    generateComponentMap();
    printf("};\n\n");

    // Generate a separate mapping table for RGB444, which needs a
    // little more care to deal with truncation errors.
    printf("static unsigned char const pickMapComponent444[256] = {\n");
    generateComponentMap444();
    printf("};\n\n");

    printf("#define MAX_PICK_COLORS %d\n\n", MAX_GENERATE);

    return 0;
}

#endif // QGL_GENERATOR_PROGRAM
