import matplotlib.pyplot as plt
from matplotlib.markers import MarkerStyle
import numpy as np
import os.path
import math

plt.rcParams.update({'font.size': 20})

rotor_MLUPS = [4.58894, 4.48728, 4.26202, 4.15784]
CROR_MLUPS = [4.69107, 4.60461, 4.48636, 4.4780]#, 4.4697, 4.27425]

barWidth = 0.35
kernels = ['LBM\n+boundaries', 'PSM', 'PSM\n+rot (s=0)', 'PSM\n+rot (s=1)']
br1 = np.arange(len(kernels))
br2 = [x + barWidth for x in br1]

fig = plt.figure(figsize = (11, 6))
plt.bar(br1, [r * 128 for r in rotor_MLUPS], width = barWidth, label="Scenario A: Geometry in full domain", zorder=3)
plt.bar(br2, [r * 128 for r in CROR_MLUPS],  width = barWidth, label="Scenario B: Geometry in small part of domain", zorder=3)
plt.xticks([r + 0.5 * barWidth for r in range(len(kernels))], kernels)

plt.axhline(y=812.5, linestyle='dashed', color='black', label="LBM bandwidth roofline")

#plt.ylim(0, 900)
plt.ylabel('MLUPS per node (128 cores)')
plt.legend(loc='lower right')
#plt.title("Node level performance of PSM vs LBM on LUMI-C with 128 cores/blocks (64³ cells per block)")
#plt.title("CPU Performance of PSM on AMD EPYC 7763 (64³ Cells per CPU)")
plt.yticks(np.arange(0,901, 200.0))
plt.grid(axis='y', zorder=0)
plt.savefig("PSM_Node_level_performance_on_LUMIC.pdf")
plt.show()

