import matplotlib.pyplot as plt
from matplotlib.markers import MarkerStyle
import numpy as np
import os.path
import math

plt.rcParams.update({'font.size': 20})

rotor_MLUPS_GPU = [4053.14, 4225.74, 3804.68, 3741.92]
CROR_MLUPS_GPU = [4229.58, 4239.83, 3903.3, 3904.87]

barWidth = 0.35
kernels = ['LBM\n+boundaries', 'PSM', 'PSM\n+rot (s=0)', 'PSM\n+rot (s=1)']
br1 = np.arange(len(kernels))
br2 = [x + barWidth for x in br1]


fig = plt.figure(figsize = (11, 6))


plt.axhline(y=4 * 4523, linestyle='dashed', color='black', label="LBM bandwidth roofline")


plt.bar(br1, [r * 4 for r in rotor_MLUPS_GPU], width = barWidth, label="Scenario A: Geometry in full domain", zorder=3)
plt.bar(br2, [r * 4 for r in CROR_MLUPS_GPU],  width = barWidth, label="Scenario B: Geometry in small part of domain", zorder=3)
plt.xticks([r + 0.5 * barWidth for r in range(len(kernels))], kernels)
plt.ylabel('MLUPS per node (4 GPUs)')
plt.ylim(0, 20000)
plt.yticks(np.arange(0,20001, 5000.0))
plt.legend(loc='lower right')
#plt.title("GPU Performance of PSM on NVIDIA A100 (256³ cells per GPU)")
#plt.title("Node level performance of PSM vs LBM on NVIDIA A100 with 4 GPUs / blocks (256³ cells per block)")
plt.grid(axis='y', zorder=0)
plt.savefig("PSM_Node_level_performance_on_A100.pdf")

plt.show()