import matplotlib.pyplot as plt
import os

plt.rcParams["figure.figsize"] = (5,4)
plt.rcParams.update({'font.size': 12})
plt.gcf().subplots_adjust(bottom=0.15)
plt.gcf().subplots_adjust(left=0.17)

fluidTypes = ["Re15", "Re41", "Re116", "Re322"]
colors = ["C0", "C1", "C2", "C3"]


for i, fluidType in enumerate(fluidTypes):
    filePath = "./good/output_fluid_" + fluidType + ".txt"
    if os.path.exists(filePath):
        with open(filePath) as f:
            lines = f.readlines()
            timesteps = [float(line.split()[0]) for line in lines]
            zVel = [float(line.split()[3]) for line in lines]

        plt.plot(timesteps, zVel, linestyle='-', label=fluidType, color=colors[i])

    referencePath = "/home/rzlin/ed94aqyc/Documents/MyPaper/PSM/SettlingSphere/reference_vel_extract_" + fluidType + ".csv"
    with open(referencePath) as f:
        lines = f.readlines()
        timesteps = [float(line.split()[0]) for line in lines[2:]]
        zVel = [float(line.split()[1]) for line in lines[2:]]
        plt.plot(timesteps, zVel, linestyle='None', marker="x", label=fluidType + " reference", color=colors[i])


plt.xlabel('Time in s')
plt.ylabel('Settling velocity in m/s')
#plt.title('Settling velocity of settling sphere simulation')

plt.legend()
plt.grid(True)
plt.savefig("SettlingSphereVelocities.pdf")
plt.show()
