import matplotlib.pyplot as plt
from matplotlib.markers import MarkerStyle
import numpy as np
import os.path
import math

fig = plt.figure(figsize = (6, 4))
plt.rcParams.update({'font.size': 14
                     })
plt.gcf().subplots_adjust(bottom=0.15)
plt.gcf().subplots_adjust(left=0.12)

numGPUs = [4, 8, 16, 32, 64, 128, 256, 512, 1024]

MLUPS_128x128x128 = [6045.54, 11883.6, 23553, 44607.5, 81829.7, 141592, np.nan, np.nan, np.nan]
MLUPS_256x128x128 = [6720.65, 13206.5, 25753.9, 48605.3, 87085, np.nan, np.nan, np.nan, np.nan]
MLUPS_256x128x128_big_run = [np.nan, np.nan, np.nan, 49398.6, 81838, 157370, 287703, 542864, 996217]


linearScaling = [n / 4 * MLUPS_256x128x128[0] for n in numGPUs]
linearScaling_big = [n / 32 * MLUPS_256x128x128_big_run[0] for n in numGPUs]


plt.plot(numGPUs, MLUPS_256x128x128, label="CROR small problem", marker='x', markersize=7, color='tab:blue')
plt.plot(numGPUs, MLUPS_256x128x128_big_run, label="CROR large problem", marker='x', markersize=7, color='tab:orange')

plt.plot(numGPUs, linearScaling, label="Ideal scaling", linestyle='dashed', color='tab:blue', alpha=0.5)
#plt.plot(numGPUs, linearScaling_big, label="linear scaling big", linestyle='dashed', color='tab:orange', alpha=0.5)

plt.xscale('log',base=2)
plt.yscale('log',base=2)
plt.xticks(numGPUs)
plt.xlim(2, 2**11)
plt.ylim(2**12, 2**22)
plt.xlabel('#GPUs')
plt.ylabel('MLUPS')
plt.grid(axis='x', color='0.95')
plt.grid(axis='y', color='0.95')
#plt.title("CROR JUWELS booster strong scaling")
plt.legend()
plt.savefig("CROR_JUWELS_booster_strong_scaling.pdf")
plt.show()