import matplotlib.pyplot as plt
from matplotlib.markers import MarkerStyle
import numpy as np
import os.path
import math

fig = plt.figure(figsize = (6, 4))
plt.rcParams.update({'font.size': 14})
plt.gcf().subplots_adjust(bottom=0.15)
plt.gcf().subplots_adjust(left=0.12)


onlyFluidLUPS = 1   # 1 for mflups, 2 for mlups
coresPerNode = 128
maxNodesBinary = 9
numNodes = [2**i * coresPerNode for i in range(maxNodesBinary)]

#MLUPS_small_blocks = [np.nan, np.nan, 851.87,	1638.8,	2979.53, 4870.53, 6230.4, np.nan]
#MLUPS_p_core_small_blocks = [np.nan, np.nan, 1.66381, 1.60039, 1.45485, 1.18909, 0.760547, np.nan]

#MLUPS_karolina = [319.078, 591.067, 1144.99, 2158.35, 3622.96, 5680.66, 6967.69, 924.281, np.nan, np.nan]
#MLUPS_p_core_karolina = [2.4928, 2.30886, 2.2363, 2.10776, 1.76902, 1.38688, 0.850549, 0.0564136, np.nan, np.nan]

MLUPS_lumiC = [430.582, 848.665, 1672.48, 3286.13, 6289.73, 11967.8, 17121.8, 26340.9, np.nan]#, np.nan]
#MLUPS_p_core_lumiC = [3.36392, 3.3151, 3.26656, 3.20911, 3.07116, 2.92183, 2.09006, 1.60772, np.nan, np.nan]

MLUPS_lumiC_big_run = [np.nan, np.nan, np.nan, np.nan, 7493.12, 14183.8, 28547.6, 54579.4, 97406.5]#, 104448]


#linearScalingKarolina = [n / 128 * MLUPS_karolina[0] for n in numNodes]
linearScalingLumiC = [n / 128 * MLUPS_lumiC[0] for n in numNodes]


#plt.plot(numNodes, MLUPS_karolina, label="karolina", marker='x', markersize=7, color='#1f77b4')
plt.plot(numNodes, MLUPS_lumiC, label="CROR small problem",  marker='x', markersize=7, color='tab:blue')
plt.plot(numNodes, MLUPS_lumiC_big_run, label="CROR large problem",  marker='x', markersize=7, color='tab:orange')

#plt.plot(numNodes, linearScalingKarolina, label="linear scaling", linestyle='dashed', color='#1f77b4', alpha=0.5)
plt.plot(numNodes, linearScalingLumiC, label="Ideal scaling", linestyle='dashed', color='tab:blue', alpha=0.5)

plt.xscale('log',base=2)
plt.yscale('log',base=2)
plt.xlim(2**6, 2**16)
plt.ylim(2**8, 2**18)
plt.xticks(numNodes)
plt.xlabel('#Cores')
plt.ylabel('MLUPS')
plt.grid(axis='x', color='0.95')
plt.grid(axis='y', color='0.95')
#plt.title("waLBerla CROR strong scaling 220mio cells blocksize 24³ 15598 blocks")
plt.legend()
plt.savefig("waLBerla_CROR_strong_scaling.pdf")
plt.show()

