function [x,y] = removeTrackingJumps(x,y, varargin)

% sd = RemoveOutlierPositions(sd, varargin)
%   Removes any points that jump by more than maxtraveldist before and
%   after.  This helps when there are flickers that jump away.  Replaces
%   them with the mean of the points ahead and behind them.
%
% PARMS
%   maxTravelDist = 10;
%
% ADR 2012 Nov

maxTravelDist = 100;
process_varargin(varargin);

dz = sqrt(diff(x.data).^2+diff(y.data).^2);
problemDiffs = dz > maxTravelDist;
problemPoints = find(problemDiffs);
problemPoints = problemPoints(problemPoints>1);
problemDiffs(problemPoints+1) = true;
problemDiffs(problemPoints-1) = true;
problemPoints = find(problemDiffs);


xR = x.range;
xD = x.data; yD = y.data;
% 
% for iP = problemPoints'
% 	xD(iP+1) = mean([xD(iP), xD(iP+2)]);
% 	yD(iP+1) = mean([yD(iP), yD(iP+2)]);
% end
xvec = (1:length(xD))';
vq_x = interp1(xvec(~problemDiffs),xD(~problemDiffs),problemPoints);
vq_y = interp1(xvec(~problemDiffs),yD(~problemDiffs),problemPoints);

xD(problemPoints) = vq_x;
yD(problemPoints) = vq_y;


x = tsd(xR, xD);
y = tsd(xR, yD);