function plot_coefs(mdl,varargin)

labelsIn = 0;
sortPredictors = 1;

process_varargin(varargin);

%pull out the relevant values
beta = mdl.Coefficients.Estimate;

    upper = mdl.Coefficients.Upper;
    lower = mdl.Coefficients.Lower;


name = mdl.Coefficients.Name;
p = mdl.Coefficients.pValue;

%take out the intercept
beta = beta(2:end);
upper = upper(2:end);
lower = lower(2:end);
name = name(2:end);
p = p(2:end);

if sortPredictors;
    %sort them
    [beta, ix] = sort(beta,'descend');
    upper = upper(ix);
    lower = lower(ix);
    name = name(ix);
    p = p(ix);
end

%do the plot
yval = 1:2:(length(name)*2);
gray = [.75 .75 .75];
% figure
for iB = 1:length(beta);
    if p(iB)<0.05;
        col = 'b';
    else
        col = gray;
    end
    plot(beta(iB),yval(iB),'o','MarkerEdgeColor',col);
    hold on
    line([lower(iB),upper(iB)],[yval(iB),yval(iB)],'LineWidth',2,'Color',col);
end

yy = ylim;
ylim([0 yy(2)+1]);

% if max(abs(beta))<1;
%     xlim([-1 1]);
%     ylabel('Predictors')
%     xlabel('Standardized coefficient estimate')
% else
%     ylabel('Predictors')
%     xlabel('Coefficient estimate')
% end
ylabel('Predictors')
xlabel('Coefficient estimate')

line([0 0],ylim,'LineStyle',':','Color','k')

if labelsIn;
    set(gca,'YTick',yval,'YTickLabel',[]);
    minX = xlim;
    minX = minX(1)+0.01;
    for iL = 1:length(name);
        text(minX, yval(iL)+0.6, name{iL},'Interpreter','none','color',[0.5 0.5 0.5]);
    end
    h = get(gca, 'Children');

    h = flipud(h);
    set(gca, 'Children', h);
else
    set(gca,'YTick',yval,'YTickLabel',name)
end
% box off
yaxisproperties= get(gca, 'YAxis');
yaxisproperties.TickLabelInterpreter = 'none';