function nextPellet = patch_simulateITIs(varargin)

tau = 3*60; %seconds
maxT = 30*60; %seconds
n0 = 10; %initial inter-pellet interval; seconds
var0 = 4; %seconds

process_varargin(varargin);

sessTime = 0;
nextPellet  = NaN;

while sessTime<maxT;
    
    %what's the current session time?
    %I guess it's just sessTime
    
    %based on time, what's the current session rate?
    
    rate = n0.*exp( (sessTime/tau));
    
    %so generate an IPI based on that rate and prescribed variance (which you
    %should think about how to scale as rate changes...).
    % var_ipi = var0.*(rate./n0);
    temp = normrnd(rate,var0,10,1);
    temp = temp(temp>0);
    nextPellet(end+1) = temp(1);
    
    %add that to the end, and update session time?
    sessTime = sessTime+nextPellet(end);
    
end

nextPellet = nextPellet(2:end);



