function [mdl,tbl,trial] = patch_risk_singleTrialRegression(trial,varargin)

process_varargin(varargin);

%define outlier trials as residence times >2 SDs from the mean
outlier = zscore(trial.res)>2;

%save the outlier info in trial structure for use later
trial.outlier = outlier;

%make a table of all the variables
vnames = {'res','vNum','travel','risk','side','rat','sessNum','female'};
%res is residence time in seconds, vNum is the visit number to each patch
%within the sessions, travel is the travel time in seconds, risk denotes
%whether a patch followed the risky or safe reward schedule, side tracks
%the physical location of the patch within the apparatus, rat is the rat id
%number, sessNum is the session number within each rat's sequence, female
%denotes the sex of each subject.

tbl = table(zscore(trial.res(~outlier)),... %zscore continuous variables
            zscore(trial.vNum(~outlier)),... %zscore continuous variables
            zscore(trial.travel(~outlier)),... %zscore continuous variables
            ordinal(trial.risk(~outlier)),... %risk is an ordinal categorical variable
            categorical(trial.side(~outlier)),... %side is a cardinal categorical variable
            categorical(trial.rat(~outlier)),... %rat is a cardinal categorical variable
            zscore(trial.sessNum(~outlier)),... %zscore continuous variables
            categorical(trial.female(~outlier)),... %set is a cardinal categorical variable
            'VariableNames',vnames);

%set up equation for the preliminary mixed-effects model. Include session
%number as a fixed effect to look for systematic changes in residence time
%across sessions
% eq_prelim = 'res ~ vNum + travel + risk + female + side + risk*travel + sessNum + (1|rat)';
% 
% %fit the preliminary model
% mdl_prelim = fitlme(tbl,eq_prelim); %standard linear mixed-effects model

%Several predictors (sex, side, session number) are not significant in the
%preliminary model, so they're removed from the main model to conserve
%statistical power. Session number is re-coded as a random variable to
%allow for non-systematic variation in intercept on across sessions.

%set up equation for mixed-effects model
eq = 'res ~ vNum + travel + risk + risk*travel + (1|rat) + (1|sessNum)' ;

%fit the model
mdl = fitlme(tbl,eq); %standard linear mixed-effects model
