function patch_risk_runEverything

%load and prep the data, compute session-level metrics
[beh,events,meta,tracking] = patch_risk_prepCohort('doTracking',1);

%extract trial level information
[trial] = patch_risk_extractTrialData(beh,meta,events);

%run single-trial regression
[mdl,tbl,trial] = patch_risk_singleTrialRegression(trial);

%make plots showing how the risky and safe reward schedules behaved
patch_risk_fig_plotRewardSchedules(trial);

%example tracking figures from pre-selected sessions; can change indices
%listed in sessionsToPlot to plot different sessions. 
%Default set: [38,62,55,50]
patch_risk_fig_exampleTracking(beh,tracking,events,'sessionsToPlot',[38,62,55,50]);

%make a plot of the basic results alongside the statistical analysis from
%the model fit above
patch_risk_fig_basicResults(trial,mdl);

%use numerical simulation to find the optimal residence time for each
%condition. Note that this takes a while to run and the output varies
%slightly because the task is stochastic. Values used in the paper are
%hardcoded below for consistency

% bestRes = NaN(2,2,10000);
% for iSim = 1:10000;
%     [bestRes(:,:,iSim)] = patch_risk_findBestRes();
% end
% bestRes = nanmean(bestRes,3); %this is organized as: [short-standard, short-risky; long-standard long-risky]

bestRes = [89, 89; 147, 147]; %hard-coded values
t_best_0 = bestRes(1,1);
t_best_30 = bestRes(2,1);

%overstaying figure
patch_risk_fig_overstaying(trial,t_best_0,t_best_30);

