function [beh,events,meta,tracking] = patch_risk_prepCohort(varargin)

doTracking = 0; %loads & processes position-tracking data if true

process_varargin(varargin);

%load the data set
rawData = load('patchData_risk_allSessions');

%preallocate
events = cell(length(rawData.patchSessionData),1);

%load the sessions and extract data
for iS = 1:length(rawData.patchSessionData);
    
    %key events
    [events{iS}] =  patch_risk_getKeyEvents(rawData.patchSessionData(iS).taskRecord); 

    %session parameters
    beh.tau(iS,:) = rawData.patchSessionData(iS).taskRecord.parms.tau;
    beh.n0(iS,:) = rawData.patchSessionData(iS).taskRecord.parms.n0;
    beh.travel(iS,:) = rawData.patchSessionData(iS).taskRecord.parms.mu_travel;
    beh.risk(iS,:) = ( (rawData.patchSessionData(iS).taskRecord.parms.nPellets(:,1) == ...
                        rawData.patchSessionData(iS).taskRecord.parms.nPellets(:,2))==0 )';
    beh.baseline(iS,:) = sum( rawData.patchSessionData(iS).taskRecord.parms.nPellets(1,:))/2; %not actually varied in this expt, but OK to load anyways.

    %see if we need to flip everything....
    if events{iS}.open1(1)>events{iS}.open2(1);
        beh.tau(iS,:) = fliplr(beh.tau(iS,:));
        beh.n0(iS,:) = fliplr(beh.n0(iS,:));
        beh.risk(iS,:) = fliplr(beh.risk(iS,:));
    end

    %compute session-level behavioral metrics
    beh.nPellets(iS,1) = length(events{iS}.feeder1);
    beh.nPellets(iS,2) = length(events{iS}.feeder2);
    
    beh.meanTime(iS,1) = nanmean( events{iS}.close1-events{iS}.open1);
    beh.meanTime(iS,2) = nanmean( events{iS}.close2-events{iS}.open2);
    beh.medTime(iS,1) = nanmedian( events{iS}.close1-events{iS}.open1);
    beh.medTime(iS,2) = nanmedian( events{iS}.close2-events{iS}.open2);

end

% Get the rat ID for each session
meta.rat = NaN(length(rawData.patchSessionData),1);
for iS = 1:length(rawData.fn_risky);
    meta.rat(iS,:) = str2num(rawData.fn_risky{iS}(end-11)); %this is hard-coded to get rat ID from each session's original file name
end

meta.female = meta.rat>2; %this is hard-coded; rats 2 and 3 were females

sessionNumber = NaN(size(beh.travel,1),1);
for iR = 1:4;
    sessionNumber(meta.rat==iR) = (1:sum(meta.rat==iR))';
end
meta.sessionNumber = sessionNumber;

if doTracking == 1;
   [tracking] = patch_risk_processTracking(rawData.patchSessionData);
else
    tracking = [];
end