function events = patch_risk_getKeyEvents(tr,varargin)

process_varargin(varargin);

%session start
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) =strcmp('sessionStart',tr.eventID{iE});
end
sessionStart = tr.eventTime_br(match);
events.sessionStart = sessionStart;

%session end
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) =strcmp('sessionEnd',tr.eventID{iE});
end
sessionEnd = tr.eventTime_br(match);
events.sessionEnd = sessionEnd;

%door 1 opened - physical patch 1 is on the left in xy data
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) = strcmp('open1',tr.eventID{iE});
end
open1 = tr.eventTime_br(match);
events.open1 = open1';

%door 1 closed
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) = strcmp('close1',tr.eventID{iE});
end
close1 = tr.eventTime_br(match);
events.close1 = close1';

%equalize lengths
if length(events.open1)>length(events.close1);
    events.open1 = events.open1(1:end-1);
end

%door 2 opened
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) = strcmp('open2',tr.eventID{iE});
end
open2 = tr.eventTime_br(match);
events.open2 = open2';

%door 2 closed
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) = strcmp('close2',tr.eventID{iE});
end
close2 = tr.eventTime_br(match);
events.close2 = close2';

%equalize lengths
if length(events.open2)>length(events.close2);
    events.open2 = events.open2(1:end-1);
end

%feeder 1
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) =strcmp('feeder4',tr.eventID{iE}) | strcmp('feeder5',tr.eventID{iE});
end
feeder1 = tr.eventTime_br(match);
events.feeder1 = feeder1';

%feeder 2
match = false(size(tr.eventID));
for iE = 1:length(tr.eventID);
    match(iE) =strcmp('feeder6',tr.eventID{iE}) | strcmp('feeder7',tr.eventID{iE});
end
feeder2 = tr.eventTime_br(match);
events.feeder2 = feeder2';