function [bestRes] = patch_risk_findBestRes(varargin)

n0 = [15];
tau = [300];
var0 =[4];
nSim = 1000;
maxT = 300;

res = [0:1:300]; %residence times (in s) to try for finding best rate
travel = [5 30]; %using 5 (not 0) for short travel time because rats can't teleport between patches

process_varargin(varargin);

cycleRate_short = NaN(2,nSim,length(res));
cycleRate_long = NaN(2,nSim,length(res));
for iSim = 1:nSim;

    feederTimes = cumsum(patch_simulateITIs('tau',tau,'n0',n0,'var0',var0,...
        'maxT',maxT))';

    for iRes = 1:length(res);

        obtained = sum(feederTimes<=res(iRes));
        cycleRate_short(1,iSim,iRaes) = obtained./(res(iRes)+travel(1));
        cycleRate_long(1,iSim,iRes) = obtained./(res(iRes)+travel(2));
    end

    keep = rand(size(feederTimes))<0.5;
    feederTimes = feederTimes(keep);

    for iRes = 1:length(res);

        obtained = sum(feederTimes<=res(iRes))*2;
        cycleRate_short(2,iSim,iRes) = obtained./(res(iRes)+travel(1));
        cycleRate_long(2,iSim,iRes) = obtained./(res(iRes)+travel(2));
    end

end

%average over all simulations
cycleRate_short_mean(1,:) = nanmean(smooth2a(squeeze(cycleRate_short(1,:,:)),0,2));
cycleRate_short_mean(2,:) =nanmean(smooth2a(squeeze(cycleRate_short(2,:,:)),0,2));
cycleRate_long_mean(1,:) = nanmean(smooth2a(squeeze(cycleRate_long(1,:,:)),0,2));
cycleRate_long_mean(2,:) = nanmean(smooth2a(squeeze(cycleRate_long(2,:,:)),0,2));

% cycleRate_short_mean = smooth2a(cycleRate_short_mean,0, 1);
% cycleRate_long_mean = smooth2a(cycleRate_long_mean,0, 1);

[~,i] = max(cycleRate_short_mean(1,:));
best_res_short_standard = res(i);

[~,i] = max(cycleRate_short_mean(2,:));
best_res_short_risky = res(i);

[~,i] = max(cycleRate_long_mean(1,:));
best_res_long_standard = res(i);

[~,i] = max(cycleRate_long_mean(2,:));
best_res_long_risky = res(i);

bestRes(1,:) = [best_res_short_standard,best_res_short_risky];
bestRes(2,:) = [best_res_long_standard,best_res_long_risky];
