function patch_risk_fig_plotRewardSchedules(trial)

%examine how reward schedules behaved. Restrict data to patch visits <=300
%s so there's approximately the same amount of data for all time points.

%break variables out of trial structure
ppv = trial.ppv(~trial.outlier); %this is pellets per visit to each patch
risk = trial.risk(~trial.outlier);
res = trial.res(~trial.outlier);

%variability in pellets per visit
maxT = 300;
edges = linspace(0,maxT,13);
bin = discretize(res(),edges);
edges_plot = edges(1:end-1) + (mean(diff(edges))./2);

for iB = 1:max(bin);
    ppv_mean_safe(iB) = nanmean(ppv(bin==iB&risk==0&res<=maxT));
    ppv_std_safe(iB) = nanstd(ppv(bin==iB&risk==0&res<=maxT));
    ppv_mean_risk(iB) = nanmean(ppv(bin==iB&risk==1&res<=maxT));
    ppv_std_risk(iB) = nanstd(ppv(bin==iB&risk==1&res<=maxT));
end

figure
subplot(131);
plot(res(risk==0&res<maxT),ppv(risk==0&res<maxT),'b.');
hold on
errorbar(edges_plot,ppv_mean_safe,ppv_std_safe,'b','LineWidth',2);
axis square
box off
axis([0 maxT 0 25])
ylabel('Mean (\pmstd) pellets per visit')
xlabel('Patch residence duration (s)')
title('Standard reward schedule')
set(gca,'XTick',[0:100:maxT],'YTick',0:5:25);
colorbar; %adding this just so matlab scales the subplots equally


subplot(132);
plot(res(risk==1&res<maxT),ppv(risk==1&res<maxT),'r.');
hold on
errorbar(edges_plot,ppv_mean_risk,ppv_std_risk,'r','LineWidth',2);
axis square
box off
axis([0 maxT 0 25])
ylabel('Mean (\pmstd) pellets per visit')
xlabel('Patch residence duration (s)')
title('Risky reward schedule')
set(gca,'XTick',[0:100:maxT],'YTick',0:5:25);
colorbar; %adding this just so matlab scales the subplots equally

subplot(133);
plot(ppv_mean_safe(2:2:end),ppv_mean_risk(2:2:end),'k','LineWidth',2)
hold on
errorbar(ppv_mean_safe(2:2:end),ppv_mean_risk(2:2:end),ppv_std_safe(2:2:end),'horizontal','ko')
errorbar(ppv_mean_safe(2:2:end),ppv_mean_risk(2:2:end),ppv_std_risk(2:2:end),'ko')
scatter(ppv_mean_safe(2:2:end),ppv_mean_risk(2:2:end),30,edges_plot(2:2:end),'filled');
axis([-1 18 -1 18])
line([-1 18],[-1 18]) 
axis square
h = colorbar;
xlabel('Standard reward schedule')
ylabel('Risky reward schedule')
title('Mean (\pmstd) pellets per visit')
caxis([45,285])
colormap(jet(6))
box off
