function patch_risk_fig_overstaying(trial,t_best_0,t_best_30)

%break out some variables 
res = trial.res(~trial.outlier);
travel = trial.travel(~trial.outlier);
risk = trial.risk(~trial.outlier);
vNum = trial.vNum(~trial.outlier);

%separate residence times by session parameters travel time and risk
res_grouped = cell(2,2);
res_grouped {1,1} = res(risk==0&travel==0);
res_grouped {1,2} = res(risk==1&travel==0);
res_grouped {2,1} = res(risk==0&travel==30);
res_grouped {2,2} = res(risk==1&travel==30);

%reorganize slightly
rr = cat(2,res_grouped(1,:),res_grouped(2,:));
t_best = [t_best_0 t_best_0 t_best_30 t_best_30];

%compute overstaying (actual-optimal) mean and 95% confidence interval for
%each task condition
for iT = 1:4;
    [muHat_over(iT),~,muCI_over(:,iT)] = normfit(rr{iT}-t_best(iT),0.05);
end

%plot
figure
subplot(131)
%plot the magnitude of overstaying for each condition
errorbar(muHat_over,1:4,muHat_over-muCI_over(1,:),muCI_over(2,:)-muHat_over,'horizontal','ko')
ylim([0 5]);
line([0 0],ylim,'Color','k','LineStyle','--')
box off
label = {'short, safe','short, risky','long, safe','long, risky'};
set(gca,'YTick',[1:4],'YTickLabel', label);
xlim([-20 100]);
xlabel('Overstaying (s)')
% axis square
ylabel('Task condition');
set(gca,'XTick',0:25:100);

%examing how overstaying changes with successive visits to a patch

%compute overstaying (actual duration-optimal duration) for each patch visit
over = res;
over(travel==0) = over(travel==0) - t_best_0 ;
over(travel==30) = over(travel==30) - t_best_30 ;

res_optimal = NaN(size(over));
res_optimal(travel==0) = t_best_0;
res_optimal(travel==30) = t_best_30;

%compute percent of optimal residence time for each visit
res_pctOptimal = (res./ res_optimal).*100;

%separate this out by patch visit number for each task condition
nV = [1;2;3;4;5;6];
mu_res_pctOpt = [];
stderr_res_pctOpt = [];
for iV = 1:length(nV);
    mu_res_pctOpt(1,iV) = nanmean(res_pctOptimal(travel==0&risk==0&vNum==nV(iV)));
    mu_res_pctOpt(2,iV) = nanmean(res_pctOptimal(travel==0&risk==1&vNum==nV(iV)));
    mu_res_pctOpt(3,iV) = nanmean(res_pctOptimal(travel==30&risk==0&vNum==nV(iV)));
    mu_res_pctOpt(4,iV) = nanmean(res_pctOptimal(travel==30&risk==1&vNum==nV(iV)));
    
    stderr_res_pctOpt(1,iV) = nanstderr(res_pctOptimal(travel==0&risk==0&vNum==nV(iV)));
    stderr_res_pctOpt(2,iV) =nanstderr(res_pctOptimal(travel==0&risk==1&vNum==nV(iV)));
    stderr_res_pctOpt(3,iV) = nanstderr(res_pctOptimal(travel==30&risk==0&vNum==nV(iV)));
    stderr_res_pctOpt(4,iV) = nanstderr(res_pctOptimal(travel==30&risk==1&vNum==nV(iV)));
    
    n(1,iV) = sum(travel==0&risk==0&vNum==nV(iV));
    n(2,iV) = sum(travel==0&risk==1&vNum==nV(iV));
    n(3,iV) = sum(travel==30&risk==0&vNum==nV(iV));
    n(4,iV) = sum(travel==30&risk==1&vNum==nV(iV));

end

subplot(1,3,2:3)
maxVisitsToPlot = 4;
b = bar(mu_res_pctOpt(:,1:maxVisitsToPlot)');
pause(0.1);
xData = [];
for ib = 1:numel(b)
    %XData property is the tick labels/group centers; XOffset is the offset
    %of each distinct group
    xData(ib,:) = b(ib).XData+b(ib).XOffset;
end
hold on
errorbar(xData,mu_res_pctOpt(:,1:maxVisitsToPlot),stderr_res_pctOpt(:,1:maxVisitsToPlot),'ko')
line(xlim,[100 100],'Color','k','LineStyle','--')
legend({'travel=0;risk=0','travel=0,risk=1','travel=30;risk=0','travel=30,risk=1'},'Location','NW')
box off
ylabel({'Residence time (% optimal)'})
xlabel('Patch visit number')

%add sample size for each bar
for iR = 1:4;
    for iV = 1:4;
        text(xData(iR,iV),0.5,num2str(n(iR,iV)));
    end
end

%another version of the same plot with four separate graphs for the task
%conditions
figure
subplot(2,4,[1:2,5:6])
%plot the magnitude of overstaying for each condition
errorbar(muHat_over,1:4,muHat_over-muCI_over(1,:),muCI_over(2,:)-muHat_over,'horizontal','ko')
ylim([0 5]);
line([0 0],ylim,'Color','k','LineStyle','--')
box off
label = {'short, safe','short, risky','long, safe','long, risky'};
set(gca,'YTick',[1:4],'YTickLabel', label);
xlim([-20 100]);
xlabel('Overstaying (s)')
% axis square
ylabel('Task condition');
set(gca,'XTick',0:25:100);

ix = [3,4,7,8];
maxVisitsToPlot = 4;
for iC = 1:length(ix);
    subplot(2,4,ix(iC))
    b = bar(mu_res_pctOpt(iC,1:maxVisitsToPlot)');
    hold on
    errorbar(mu_res_pctOpt(iC,1:maxVisitsToPlot),stderr_res_pctOpt(iC,1:maxVisitsToPlot),'ko')
    line(xlim,[100 100],'Color','k','LineStyle','--')
    % legend({'travel=0;risk=0','travel=0,risk=1','travel=30;risk=0','travel=30,risk=1'},'Location','NW')
    box off
    ylabel({'Residence time (% optimal)'})
    xlabel('Patch visit number')
    set(gca,'YLim',[0 225],'YTick',[0:25:225])
    axis square
end

%compute correlation between visit number and res time in each condition
[r_vNumCorr(1),p_vNumCorr(1)]  = corr(vNum(travel==0&risk==0),res(travel==0&risk==0));
[r_vNumCorr(2),p_vNumCorr(2)]  = corr(vNum(travel==0&risk==1),res(travel==0&risk==1));
[r_vNumCorr(3),p_vNumCorr(3)]  = corr(vNum(travel==30&risk==0),res(travel==30&risk==0));
[r_vNumCorr(4),p_vNumCorr(4)]  = corr(vNum(travel==30&risk==1),res(travel==30&risk==1));

%plot it (not sure we'll use this figure, but no harm to have it here)
figure
subplot(221)
plot(vNum(travel==0&risk==0),res(travel==0&risk==0),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Standard reward schedule; Travel time = 0 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(1),4)),{'; '},'p=',num2str(round(p_vNumCorr(1),4)));
text(1,450,info);

subplot(222)
plot(vNum(travel==0&risk==1),res(travel==0&risk==1),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Risky reward schedule; Travel time = 0 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(2),4)),{'; '},'p=',num2str(round(p_vNumCorr(2),4)));
text(1,450,info);

subplot(223)
plot(vNum(travel==30&risk==0),res(travel==30&risk==0),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Standard reward schedule; Travel time = 30 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(3),4)),{'; '},'p=',num2str(round(p_vNumCorr(3),4)));
text(1,450,info);

subplot(224)
plot(vNum(travel==30&risk==1),res(travel==30&risk==1),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Risky reward schedule; Travel time = 30 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(4),4)),{'; '},'p=',num2str(round(p_vNumCorr(4),4)));
text(1,450,info);

%maybe all the square plots together?
figure
ix1 = [1,2,5,6];
ix2 = [3,4,7,8];
maxVisitsToPlot = 4;
for iC = 1:length(ix);
    subplot(2,4,ix1(iC))
    b = bar(mu_res_pctOpt(iC,1:maxVisitsToPlot)');
    hold on
    errorbar(mu_res_pctOpt(iC,1:maxVisitsToPlot),stderr_res_pctOpt(iC,1:maxVisitsToPlot),'ko')
    line(xlim,[100 100],'Color','k','LineStyle','--')
    % legend({'travel=0;risk=0','travel=0,risk=1','travel=30;risk=0','travel=30,risk=1'},'Location','NW')
    box off
    ylabel({'Residence time (% optimal)'})
    xlabel('Patch visit number')
    set(gca,'YLim',[0 225],'YTick',[0:25:225])
    axis square
end

subplot(243)
plot(vNum(travel==0&risk==0),res(travel==0&risk==0),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Standard reward schedule; Travel time = 0 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(1),4)),{'; '},'p=',num2str(round(p_vNumCorr(1),4)));
text(1,450,info);

subplot(244)
plot(vNum(travel==0&risk==1),res(travel==0&risk==1),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Risky reward schedule; Travel time = 0 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(2),4)),{'; '},'p=',num2str(round(p_vNumCorr(2),4)));
text(1,450,info);

subplot(247)
plot(vNum(travel==30&risk==0),res(travel==30&risk==0),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Standard reward schedule; Travel time = 30 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(3),4)),{'; '},'p=',num2str(round(p_vNumCorr(3),4)));
text(1,450,info);

subplot(248)
plot(vNum(travel==30&risk==1),res(travel==30&risk==1),'k.');
axis tight
lsline
box off
axis([0 11 0 500]);
set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
axis square
title('Risky reward schedule; Travel time = 30 s')
ylabel('Residence duration (s)')
xlabel('Patch visit number')
info = strcat('R=',num2str(round(r_vNumCorr(4),4)),{'; '},'p=',num2str(round(p_vNumCorr(4),4)));
text(1,450,info);



% %let's take a shot at reorganizing and getting all of the data above into a
% %single figure.....
% 
% figure
% subplot(2,6,[1:2,7:8]);
% 
% %plot the magnitude of overstaying for each condition
% errorbar(muHat_over,1:4,muHat_over-muCI_over(1,:),muCI_over(2,:)-muHat_over,'horizontal','ko')
% ylim([0 5]);
% line([0 0],ylim,'Color','k','LineStyle','--')
% box off
% label = {'short, safe','short, risky','long, safe','long, risky'};
% set(gca,'YTick',[1:4],'YTickLabel', label);
% xlim([-20 100]);
% xlabel('Overstaying (s)')
% % axis square
% ylabel('Task condition');
% set(gca,'XTick',0:25:100);
% 
% ix = [3,4,9,10];
% for iB = 1:length(ix);
%     subplot(2,6,ix(iB));
%     b = bar(mu_res_pctOpt(iB,1:maxVisitsToPlot)');
%     %we can just get the n from the other plot instead of figuring that out
%     %again.....
%     hold on
%     errorbar(xData,mu_res_pctOpt(iB,1:maxVisitsToPlot),stderr_res_pctOpt(iB,1:maxVisitsToPlot),'ko')
%     line(xlim,[100 100],'Color','k','LineStyle','--')
% %     legend({'travel=0;risk=0','travel=0,risk=1','travel=30;risk=0','travel=30,risk=1'},'Location','NW')
%     %no room for legend; can annotate in illustrator
%     box off
%     ylabel({'Residence time (% optimal)'})
%     xlabel('Patch visit number')
%     axis square
% end
% 
% subplot(2,6,5)
% plot(vNum(travel==0&risk==0),res(travel==0&risk==0),'k.');
% axis tight
% lsline
% box off
% axis([0 11 0 500]);
% set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
% axis square
% % title('Standard reward schedule; Travel time = 0 s')
% ylabel('Residence duration (s)')
% xlabel('Patch visit number')
% info = strcat('R=',num2str(round(r_vNumCorr(1),4)),{'; '},'p=',num2str(round(p_vNumCorr(1),4)));
% text(1,450,info);
% 
% subplot(2,6,6)
% plot(vNum(travel==0&risk==1),res(travel==0&risk==1),'k.');
% axis tight
% lsline
% box off
% axis([0 11 0 500]);
% set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
% axis square
% % title('Risky reward schedule; Travel time = 0 s')
% ylabel('Residence duration (s)')
% xlabel('Patch visit number')
% info = strcat('R=',num2str(round(r_vNumCorr(2),4)),{'; '},'p=',num2str(round(p_vNumCorr(2),4)));
% text(1,450,info);
% 
% subplot(2,6,11)
% plot(vNum(travel==30&risk==0),res(travel==30&risk==0),'k.');
% axis tight
% lsline
% box off
% axis([0 11 0 500]);
% set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
% axis square
% % title('Standard reward schedule; Travel time = 30 s')
% ylabel('Residence duration (s)')
% xlabel('Patch visit number')
% info = strcat('R=',num2str(round(r_vNumCorr(3),4)),{'; '},'p=',num2str(round(p_vNumCorr(3),4)));
% text(1,450,info);
% 
% subplot(2,6,12)
% plot(vNum(travel==30&risk==1),res(travel==30&risk==1),'k.');
% axis tight
% lsline
% box off
% axis([0 11 0 500]);
% set(gca,'XTick',[1:10],'XTickLabel',[1:10],'YTick',[0:100:500],'YTickLabel',[0:100:500]);
% axis square
% % title('Risky reward schedule; Travel time = 30 s')
% ylabel('Residence duration (s)')
% xlabel('Patch visit number')
% info = strcat('R=',num2str(round(r_vNumCorr(4),4)),{'; '},'p=',num2str(round(p_vNumCorr(4),4)));
% text(1,450,info);
