function patch_risk_fig_exampleTracking(beh,tracking,events,varargin)

sessionsToPlot = [53,17,38,36]; 

process_varargin(varargin);

%example tracking plots
%18 safe/safe t = 30 
%19 risk/risk t = 30
%35 risk/risk t = 0 
%36 safe/safe t = 0
%[38,62,55,50];

%make titles for figs denoting session parameters
riskStr{1} = 'safe';
riskStr{2} = 'risky';
for iS = 1:length(sessionsToPlot);
    titleStr{iS} = strcat(  riskStr(beh.risk(sessionsToPlot(iS),1)+1),',',...
                            riskStr(beh.risk(sessionsToPlot(iS),2)+1),...
                            ', travel=',...
                            num2str(beh.travel(sessionsToPlot(iS))));
end

%do the plot
figure

for iS = 1:length(sessionsToPlot);

    subplot(1,4,iS)

    i = sessionsToPlot(iS);
    x = tracking.x(i); x = tsd(x.T(1:4:end),x.D(1:4:end));
    y = tracking.y(i); y = tsd(y.T(1:4:end),y.D(1:4:end));

    plot(x.data,y.data+1700,'Color', [0 0.45 0.74]);
    hold on
    plot(x.data,y.range,'Color', [0 0.45 0.74]);
    plot(x.data(events{i}.feeder1),events{i}.feeder1,'r.');
    plot(x.data(events{i}.feeder2),events{i}.feeder2,'r.');

    
    %add scale bars (~230 pixel / ~80 cm = 2.88 px/cm)
    line([10 10],[200 260],'Color','k'); %time
    line([10 10+2.88*20],[200 200],'Color','k');
    
    axis([0 640 0 2200])
    axis equal
    axis tight
    axis off
    title(titleStr{iS})
end

%add text reminder about scale bars
subplot(141);
text(0,0,'time scale = 60s; space scale = 20 cm','FontSize',5);
