function patch_risk_fig_basicResults(trial,mdl,varargin)

process_varargin(varargin);

%separate residence times by session parameters travel time and risk
res_grouped = cell(2,2);
res_grouped {1,1} = trial.res(trial.risk==0&trial.travel==0&trial.outlier==0);
res_grouped {1,2} = trial.res(trial.risk==1&trial.travel==0&trial.outlier==0);
res_grouped {2,1} = trial.res(trial.risk==0&trial.travel==30&trial.outlier==0);
res_grouped {2,2} = trial.res(trial.risk==1&trial.travel==30&trial.outlier==0);

%start plotting
figure

%add the average residence time for each session condition as bars
subplot(121)
bar(cellfun(@nanmean,res_grouped))
hold on
xx = [.85 1.15 1.85 2.15];
errorbar(xx,reshape(cellfun(@nanmean,res_grouped'),[],1),reshape(cellfun(@nanstderr,res_grouped'),1,[]),'ko');

%overlay all the individual data points at the correct x locations
% plotSpread({res_grouped{1,1},res_grouped{1,2},...
%     res_grouped{2,1},res_grouped{2,2}},'xValues',xx,'spreadWidth',0.25);

%labels, axes, etc.
ylabel('Patch residence duration (s)');
xlabel('Travel time')
set(gca,'XTick',[1 2],'XTickLabel',{'Short (0 s)','Long (30 s)'})
box off
line([xx(1),xx(2)],[160 160])
line([xx(3),xx(4)],[195 195])
ylim([0 200]);
set(gca,'YTick',0:100:200)
legend('Safe','Risky')
axis square

%run post-hoc ttests to validate the interaction effect
[~,p_short] = ttest2(res_grouped{1,1},res_grouped{1,2});
[~,p_long] = ttest2(res_grouped{2,1},res_grouped{2,2});

%bonferroni p-values
p_short = p_short*2; %two tests, so multiple p by two
if p_short>1;
    p_short=1; %reduce to one if corrected p-value>1
end

p_long = p_long*2; 
if p_long>1;
    p_long=1;
end

%append corrected p-values above each set of bars
text(xx(1),160,strcat('p=',num2str(p_short,'%1.2e')));
text(xx(3),195,strcat('p=',num2str(p_long,'%1.2e')));

%plot the model coefs in the opposite panel
subplot(122);
plot_coefs(mdl);
axis square
box off