function [trial] = patch_risk_extractTrialData(beh,meta,events,varargin)

%this function extracts all data for individual trials rather than session
%means/medians.

process_varargin(varargin);

%preallocate
ppv = cell(size(beh.risk));
res = ppv;
travel = ppv;
vNum = ppv;
sessNum = ppv;
risk = ppv;
female = ppv;
rat = ppv;
firstPelletTime = ppv;
lastIPI = ppv;
timeSinceLastPell= ppv;
side = ppv;

for iSess = 1:length(ppv);
    
    %number of pellets and visit duration
    
    %patch 1
    for iV = 1:length(events{iSess}.open1);
        ppv{iSess,1}(iV,:) = sum( events{iSess}.feeder1>events{iSess}.open1(iV) & ...
            events{iSess}.feeder1<events{iSess}.close1(iV) );
        
        side{iSess,1} = ones(size(ppv{iSess,1}));

        res{iSess,1}(iV,:) = events{iSess}.close1(iV)-events{iSess}.open1(iV);
        
        keep = events{iSess}.feeder1>events{iSess}.open1(iV) & ...
            events{iSess}.feeder1<events{iSess}.close1(iV);
        if ~sum(keep)==0;
            fpt = min(events{iSess}.feeder1(keep));
            tlp = max(events{iSess}.feeder1(keep));
        else
            fpt= NaN;
            tlp = NaN;
        end
        
        temp = unique(events{iSess}.feeder1(keep));
        if length(temp)>1;
            l_ipi = temp(end)-temp(end-1);
        else
            l_ipi = NaN;
        end
        timeSinceLastPell{iSess,1}(iV,:) = events{iSess}.close1(iV)-tlp;
        firstPelletTime{iSess,1}(iV,:) = fpt-events{iSess}.open1(iV);
        lastIPI{iSess,1}(iV,:) = l_ipi;
        %matching predictors for patch 1;
        
        travel{iSess,1}(iV,:) = beh.travel(iSess);
        vNum{iSess,1}(iV,:) = iV;
        sessNum{iSess,1}(iV,:) = meta.sessionNumber(iSess);
        risk{iSess,1}(iV,:) = beh.risk(iSess,1);
        baseline{iSess,1}(iV,:) = beh.baseline(iSess);
        female{iSess,1}(iV,:) = meta.female(iSess);
        rat{iSess,1}(iV,:) = meta.rat(iSess);
         
    end
    
    %patch2
    for iV = 1:length(events{iSess}.open2);
        ppv{iSess,2}(iV,:) = sum( events{iSess}.feeder2>events{iSess}.open2(iV) & ...
            events{iSess}.feeder2<events{iSess}.close2(iV) );

                side{iSess,2} = ones(size(ppv{iSess,2})).*2;

        
        res{iSess,2}(iV,:) = events{iSess}.close2(iV)-events{iSess}.open2(iV);
        
        keep = events{iSess}.feeder2>events{iSess}.open2(iV) & ...
            events{iSess}.feeder2<events{iSess}.close2(iV);
        if ~sum(keep)==0;
            fpt = min(events{iSess}.feeder2(keep));
            tlp = max(events{iSess}.feeder2(keep));
            
        else
            fpt= NaN;
            tlp = NaN;
            
        end
        
        temp = unique(events{iSess}.feeder2(keep));
        if length(temp)>1;
            l_ipi = temp(end)-temp(end-1);
        else
            l_ipi = NaN;
        end
        timeSinceLastPell{iSess,2}(iV,:) = events{iSess}.close2(iV)-tlp;-tlp;
        
        firstPelletTime{iSess,2}(iV,:) = fpt-events{iSess}.open2(iV);
        lastIPI{iSess,2}(iV,:) = l_ipi;
        
        %matching predictors
        
        travel{iSess,2}(iV,:) = beh.travel(iSess);
        vNum{iSess,2}(iV,:) = iV;
        sessNum{iSess,2}(iV,:) = meta.sessionNumber(iSess);
        risk{iSess,2}(iV,:) = beh.risk(iSess,2);
        baseline{iSess,2}(iV,:) = beh.baseline(iSess);
        female{iSess,2}(iV,:) = meta.female(iSess);
        rat{iSess,2}(iV,:) = meta.rat(iSess);
    end


end


%linearize everything!
timeSinceLastPell = cell2mat(timeSinceLastPell(:));
ppv = cell2mat(ppv(:));
res = cell2mat(res(:));
side = cell2mat(side(:));
travel = cell2mat(travel(:));
vNum = cell2mat(vNum(:));
sessNum = cell2mat(sessNum(:));
risk = cell2mat(risk(:));
baseline = cell2mat(baseline(:));
female = cell2mat(female(:));
rat = cell2mat(rat(:));
firstPelletTime = cell2mat(firstPelletTime(:));
lastIPI = cell2mat(lastIPI(:));
vRate = ppv./res;

%package for output
trial.ppv = ppv;
trial.res = res;
trial.travel = travel;
trial.vNum = vNum;
trial.sessNum = sessNum;
trial.risk = risk;
trial.female = female;
trial.rat = rat;
trial.side = side;
trial.baseline = baseline;
