function [x,y] = patch_resampleBRtrackingdata(x,y,varargin)

%this function corrects anomolous blackrock tracking sessions, where
%framerate was unexpectedly high. Also works on normal sessions. Processing
%everything through here ensures a perfectly consistent sampling rate for
%every session, which makes feederpeth analyses much easier to handle.

fs = 30; 
maxTravelDist = 12; %values less than 12 or so over-smooth data...
process_varargin(varargin);

%first, remove samples with a time diff that is too small to be real:
%(1./0.005 = 200 hz!)
xd = x.data; xr = x.range;
keep = diff(xr)>0.005;
x = tsd(xr(keep),xd(keep));
y = tsd(x.range,y.data(x.range));

% %remove any jumps and interp over the gaps in tracking data
% [x,y] = removeTrackingJumps(x,y,'maxTravelDist',maxTravelDist );
% [x,y] = interpTrackingPoints(x,y,isnan(x.data));

%resample at set sampling rate
xd = x.data; xr = x.range;
yd = y.data; yr = y.range;

[xd_new,xr_new] = resample(xd,xr,fs);
x = tsd(xr_new,xd_new);

[yd_new,yr_new] = resample(yd,yr,fs);
y = tsd(yr_new,yd_new);

[x,y] = removeTrackingJumps(x,y,'maxTravelDist',maxTravelDist );
[x,y] = interpTrackingPoints(x,y,isnan(x.data));
[x,y] = removeTrackingJumps(x,y,'maxTravelDist',maxTravelDist*2 );

