function se = nanstderr(x)

if size(x,1) == 1
	x = x';
end

nC = size(x,2);

se = nan(nC, 1);
for iC = 1:nC
	f = ~isnan(x(:,iC));
	if ~isempty(f)
		se(iC) = std(x(f,iC))/sqrt(length(f));
	end
end