function [x,y] = interpTrackingPoints(x,y,xyq, varargin)

% sd = RemoveOutlierPositions(sd, varargin)
%   Removes any points that jump by more than maxtraveldist before and
%   after.  This helps when there are flickers that jump away.  Replaces
%   them with the mean of the points ahead and behind them.
%
% PARMS
%   maxTravelDist = 10;
%
% ADR 2012 Nov

%xyq is a logical vector where true means interp across this point

process_varargin(varargin);

xR = x.range;
xD = x.data; yD = y.data;
% 
% for iP = problemPoints'
% 	xD(iP+1) = mean([xD(iP), xD(iP+2)]);
% 	yD(iP+1) = mean([yD(iP), yD(iP+2)]);
% end
xvec = (1:length(xD))';
vq_x = interp1(find(~xyq),xD(~xyq),find(xyq),'pchip');
vq_y = interp1(find(~xyq),yD(~xyq),find(xyq),'pchip');

xD(xyq) = vq_x;
yD(xyq) = vq_y;


x = tsd(xR, xD);
y = tsd(xR, yD);