v {xschem version=3.4.6 file_version=1.2}
G {}
K {}
V {}
S {}
E {}
P 4 5 1040 -620 2460 -620 2460 -120 1040 -120 1040 -620 {dash = 4}
P 4 5 1040 -1180 2460 -1180 2460 -680 1040 -680 1040 -1180 {dash = 4}
T {Middlebrook's Method} 1040 -650 0 0 0.4 0.4 {}
T {Tian's Method} 1040 -1210 0 0 0.4 0.4 {}
N 720 -160 720 -140 {
lab=GND}
N 880 -160 880 -140 {
lab=GND}
N 880 -320 880 -300 {lab=v_ss}
N 1500 -400 1580 -400 {
lab=vr1}
N 1380 -580 1380 -560 {lab=v_dd}
N 1340 -580 1380 -580 {lab=v_dd}
N 1340 -580 1340 -480 {lab=v_dd}
N 1380 -500 1380 -480 {lab=#net1}
N 1100 -370 1260 -370 {lab=vf1}
N 1100 -370 1100 -280 {lab=vf1}
N 1380 -320 1380 -300 {lab=v_ena}
N 720 -240 720 -220 {lab=v_dd}
N 880 -240 880 -220 {lab=v_ss}
N 720 -320 720 -300 {lab=v_ss}
N 720 -400 720 -380 {lab=v_in}
N 880 -400 880 -380 {lab=v_ena}
N 1340 -320 1340 -220 {lab=v_ss}
N 1580 -400 1580 -340 {lab=vr1}
N 1580 -280 1580 -220 {lab=v_ss}
N 1340 -220 1580 -220 {lab=v_ss}
N 1500 -400 1500 -280 {lab=vr1}
N 1440 -400 1500 -400 {
lab=vr1}
N 1100 -430 1260 -430 {lab=v_in}
N 1240 -280 1500 -280 {lab=vr1}
N 1100 -280 1180 -280 {lab=vf1}
N 2260 -400 2340 -400 {
lab=#net2}
N 2140 -580 2140 -560 {lab=v_dd}
N 2100 -580 2140 -580 {lab=v_dd}
N 2100 -580 2100 -480 {lab=v_dd}
N 2140 -500 2140 -480 {lab=#net3}
N 1860 -370 2020 -370 {lab=#net4}
N 1860 -370 1860 -280 {lab=#net4}
N 2140 -320 2140 -300 {lab=v_ena}
N 2100 -320 2100 -220 {lab=v_ss}
N 2340 -400 2340 -340 {lab=#net2}
N 2340 -280 2340 -220 {lab=v_ss}
N 2100 -220 2340 -220 {lab=v_ss}
N 2260 -400 2260 -280 {lab=#net2}
N 2200 -400 2260 -400 {
lab=#net2}
N 1860 -430 2020 -430 {lab=v_in}
N 1980 -280 2000 -280 {
lab=#net5}
N 2100 -220 2100 -160 {lab=v_ss}
N 1980 -280 1980 -240 {lab=#net5}
N 1960 -280 1980 -280 {
lab=#net5}
N 2060 -280 2260 -280 {lab=#net2}
N 1860 -280 1900 -280 {lab=#net4}
N 1980 -180 1980 -160 {lab=v_ss}
N 1980 -160 2100 -160 {lab=v_ss}
N 1500 -960 1580 -960 {
lab=#net6}
N 1380 -1140 1380 -1120 {lab=v_dd}
N 1340 -1140 1380 -1140 {lab=v_dd}
N 1340 -1140 1340 -1040 {lab=v_dd}
N 1380 -1060 1380 -1040 {lab=#net7}
N 1100 -930 1260 -930 {lab=vmeas1}
N 1380 -880 1380 -860 {lab=v_ena}
N 1340 -880 1340 -780 {lab=v_ss}
N 1580 -960 1580 -900 {lab=#net6}
N 1580 -840 1580 -780 {lab=v_ss}
N 1340 -780 1580 -780 {lab=v_ss}
N 1500 -960 1500 -840 {lab=#net6}
N 1440 -960 1500 -960 {
lab=#net6}
N 1100 -990 1260 -990 {lab=v_in}
N 2260 -960 2340 -960 {
lab=#net8}
N 2140 -1140 2140 -1120 {lab=v_dd}
N 2100 -1140 2140 -1140 {lab=v_dd}
N 2100 -1140 2100 -1040 {lab=v_dd}
N 2140 -1060 2140 -1040 {lab=#net9}
N 1860 -930 2020 -930 {lab=vmeas2}
N 1860 -930 1860 -840 {lab=vmeas2}
N 2140 -880 2140 -860 {lab=v_ena}
N 2100 -880 2100 -780 {lab=v_ss}
N 2340 -960 2340 -900 {lab=#net8}
N 2340 -840 2340 -780 {lab=v_ss}
N 2100 -780 2340 -780 {lab=v_ss}
N 2260 -960 2260 -840 {lab=#net8}
N 2200 -960 2260 -960 {
lab=#net8}
N 1860 -990 2020 -990 {lab=v_in}
N 2100 -780 2100 -700 {lab=v_ss}
N 2060 -840 2260 -840 {lab=#net8}
N 1100 -730 1100 -700 {lab=v_ss}
N 1200 -840 1240 -840 {lab=#net10}
N 1300 -840 1500 -840 {lab=#net6}
N 1100 -840 1140 -840 {lab=vmeas1}
N 1100 -930 1100 -840 {lab=vmeas1}
N 1100 -800 1140 -800 {lab=vmeas1}
N 1100 -840 1100 -800 {lab=vmeas1}
N 1100 -800 1100 -780 {lab=vmeas1}
N 1100 -700 1340 -700 {lab=v_ss}
N 1340 -780 1340 -700 {lab=v_ss}
N 1960 -840 2000 -840 {lab=#net11}
N 1860 -840 1900 -840 {lab=vmeas2}
N 1860 -720 1860 -700 {lab=v_ss}
N 1860 -700 2100 -700 {lab=v_ss}
N 1860 -800 1860 -780 {lab=vmeas2}
N 1860 -800 1900 -800 {lab=vmeas2}
N 1860 -840 1860 -800 {lab=vmeas2}
C {devices/code_shown.sym} 0 -180 0 0 {name=MODEL only_toplevel=true
format="tcleval( @value )"
value="
.lib cornerMOSlv.lib mos_tt
.lib cornerRES.lib res_typ
"}
C {devices/code_shown.sym} 20 -1170 0 0 {name=NGSPICE
only_toplevel=true
value="
.param temp=27
.options savecurrents reltol=1e-3 abstol=1e-12 gmin=1e-15
.control
save all

* Operating Point Analysis
op
remzerovec
write ota-improved_tb-loopgain.raw
set appendwrite

* AC Analysis
ac dec 101 1 100G
remzerovec
write ota-improved_tb-loopgain.raw
set appendwrite

* Middlebrook's Method
let tv=-v(vr1)/v(vf1)
let ti=-i(vir1)/i(vif1)
let tmb=(tv*ti - 1)/(tv + ti + 2)

plot db(tmb) ylabel 'Magnitude - Middlebrook'
plot 180/pi*cphase(tmb) ylabel 'Phase - Middlebrook'

* Tian's Method
* vtest=0, itest=1:
let A=i(Vimeas2)
let C=v(vmeas2)

* vtest=1, itest=0:
let B=i(Vimeas1)
let D=v(vmeas1)
let ttian=(A*D-B*C-A)/(2*(B*C-A*D)+A-D+1)

plot db(ttian) ylabel 'Magnitude - Tian'
plot 180/pi*cphase(ttian) ylabel 'Phase - Tian'

* Middlebrook vs. Tian
plot db(tmb) db(ttian) ylabel 'Magnitude'
plot 180/pi*cphase(tmb) 180/pi*cphase(ttian) ylabel 'Phase'

write ota-improved_tb-loopgain.raw

*quit
.endc
"}
C {devices/title.sym} 160 -30 0 0 {name=l5 author="(c) 2024 H. Pretl, S. Dorrer, Apache-2.0 license"}
C {devices/launcher.sym} 750 -480 0 0 {name=h2
descr="Annotate OP" 
tclcommand="set show_hidden_texts 1; xschem annotate_op"
}
C {devices/launcher.sym} 750 -540 0 0 {name=h3
descr="Simulate" 
tclcommand="xschem save; xschem netlist; xschem simulate"
}
C {devices/vsource.sym} 720 -190 0 0 {name=Vdd value=1.5}
C {devices/gnd.sym} 720 -140 0 0 {name=l3 lab=GND}
C {lab_pin.sym} 720 -240 0 0 {name=p2 sig_type=std_logic lab=v_dd}
C {devices/vsource.sym} 880 -190 0 0 {name=Vss value=0}
C {devices/gnd.sym} 880 -140 0 0 {name=l1 lab=GND}
C {lab_pin.sym} 880 -240 0 0 {name=p1 sig_type=std_logic lab=v_ss}
C {devices/vsource.sym} 720 -350 0 0 {name=Vin value="dc 0.75"}
C {lab_wire.sym} 720 -400 0 0 {name=p4 sig_type=std_logic lab=v_in}
C {vsource.sym} 880 -350 0 0 {name=Venable value=1.5 savecurrent=false}
C {lab_wire.sym} 880 -400 0 1 {name=p8 sig_type=std_logic lab=v_ena}
C {lab_pin.sym} 1340 -580 0 0 {name=p5 sig_type=std_logic lab=v_dd}
C {lab_pin.sym} 1340 -220 0 0 {name=p6 sig_type=std_logic lab=v_ss}
C {capa.sym} 1580 -310 0 0 {name=C2
value=50f}
C {lab_wire.sym} 1100 -430 0 0 {name=p9 sig_type=std_logic lab=v_in}
C {isource.sym} 1380 -530 0 0 {name=I1 value=20u pwl(0 0 10u 0 11u 20u)"}
C {lab_wire.sym} 1380 -300 0 1 {name=p10 sig_type=std_logic lab=v_ena}
C {lab_pin.sym} 720 -300 0 0 {name=p11 sig_type=std_logic lab=v_ss}
C {lab_pin.sym} 880 -300 0 0 {name=p12 sig_type=std_logic lab=v_ss}
C {devices/vsource.sym} 1210 -280 3 0 {name=Vtest1 value="dc 0 ac 1"}
C {lab_wire.sym} 1140 -280 0 0 {name=p3 sig_type=std_logic lab=vf1}
C {lab_wire.sym} 1290 -280 0 0 {name=p13 sig_type=std_logic lab=vr1}
C {lab_pin.sym} 2100 -580 0 0 {name=p14 sig_type=std_logic lab=v_dd}
C {lab_pin.sym} 2100 -220 0 0 {name=p15 sig_type=std_logic lab=v_ss}
C {capa.sym} 2340 -310 0 0 {name=C1
value=50f}
C {lab_wire.sym} 1860 -430 0 0 {name=p17 sig_type=std_logic lab=v_in}
C {isource.sym} 2140 -530 0 0 {name=I2 value=20u pwl(0 0 10u 0 11u 20u)"}
C {lab_wire.sym} 2140 -300 0 1 {name=p18 sig_type=std_logic lab=v_ena}
C {ammeter.sym} 2030 -280 1 0 {name=Vir1 savecurrent=true spice_ignore=0}
C {ammeter.sym} 1930 -280 1 0 {name=Vif1 savecurrent=true spice_ignore=0}
C {isource.sym} 1980 -210 2 0 {name=Itest1 value="dc 0 ac 1"}
C {lab_pin.sym} 1340 -1140 0 0 {name=p19 sig_type=std_logic lab=v_dd}
C {lab_pin.sym} 1340 -780 0 0 {name=p20 sig_type=std_logic lab=v_ss}
C {capa.sym} 1580 -870 0 0 {name=C3
value=50f}
C {lab_wire.sym} 1100 -990 0 0 {name=p22 sig_type=std_logic lab=v_in}
C {isource.sym} 1380 -1090 0 0 {name=I3 value=20u pwl(0 0 10u 0 11u 20u)"}
C {lab_wire.sym} 1380 -860 0 1 {name=p23 sig_type=std_logic lab=v_ena}
C {lab_pin.sym} 2100 -1140 0 0 {name=p26 sig_type=std_logic lab=v_dd}
C {lab_pin.sym} 2100 -780 0 0 {name=p27 sig_type=std_logic lab=v_ss}
C {capa.sym} 2340 -870 0 0 {name=C4
value=50f}
C {lab_wire.sym} 1860 -990 0 0 {name=p29 sig_type=std_logic lab=v_in}
C {isource.sym} 2140 -1090 0 0 {name=I4 value=20u pwl(0 0 10u 0 11u 20u)"}
C {lab_wire.sym} 2140 -860 0 1 {name=p30 sig_type=std_logic lab=v_ena}
C {isource.sym} 1100 -750 2 1 {name=Itest3 value="dc 0 ac 0"}
C {devices/vsource.sym} 1170 -840 3 0 {name=Vtest2 value="dc 0 ac 1"}
C {lab_wire.sym} 1140 -800 2 0 {name=p24 sig_type=std_logic lab=vmeas1}
C {ammeter.sym} 1270 -840 1 0 {name=Vimeas1 savecurrent=true spice_ignore=0}
C {isource.sym} 1860 -750 2 1 {name=Itest2 value="dc 0 ac 1"}
C {devices/vsource.sym} 1930 -840 3 0 {name=Vtest3 value="dc 0 ac 0"}
C {lab_wire.sym} 1900 -800 2 0 {name=p25 sig_type=std_logic lab=vmeas2}
C {ammeter.sym} 2030 -840 1 0 {name=Vimeas2 savecurrent=true spice_ignore=0}
C {ota-improved.sym} 1340 -400 0 0 {name=x1}
C {ota-improved.sym} 2100 -400 0 0 {name=x2}
C {ota-improved.sym} 1340 -960 0 0 {name=x3}
C {ota-improved.sym} 2100 -960 0 0 {name=x4}
