# -*- coding: utf-8 -*-
"""
Created on Wed Aug 14 17:21:16 2024

@author: Mario
"""


import itertools
import numpy as np
import pandas as pd
from collections import Counter
from tqdm import tqdm
import rasterio
from rasterio.warp import calculate_default_transform, reproject, Resampling
from sklearn.utils import resample
from sklearn.preprocessing import StandardScaler
from sklearn.utils.class_weight import compute_class_weight
from imblearn.over_sampling import SMOTE
import tensorflow as tf
from tensorflow.keras import layers, models
from tensorflow.keras.models import Sequential, Model
from tensorflow.keras.layers import ConvLSTM2D, Dense, Flatten, Dropout, BatchNormalization, Input, Concatenate, Reshape, LSTM, TimeDistributed, Add, GlobalAveragePooling1D, GlobalAveragePooling2D
from tensorflow.keras.optimizers import Adam
from tensorflow.keras.metrics import AUC
from tensorflow.keras.callbacks import EarlyStopping, LearningRateScheduler, Callback
from keras.preprocessing.image import ImageDataGenerator
from sklearn.metrics import cohen_kappa_score, accuracy_score, confusion_matrix, average_precision_score
import matplotlib.pyplot as plt
import seaborn as sns
import docx
from io import StringIO
import time
import psutil
import GPUtil
from tensorflow.keras.layers import Input, Dense, Flatten, ConvLSTM2D, Dropout, BatchNormalization, Concatenate, TimeDistributed, LSTM, Add, Reshape, GlobalAveragePooling1D, GlobalAveragePooling2D
from tensorflow.keras.models import Model
from tensorflow.keras.regularizers import l2
from tensorflow.keras.layers import LayerNormalization, MultiHeadAttention, Conv1D
from tensorflow.keras.layers import MultiHeadAttention, LayerNormalization, Dense, Add
from tensorflow.keras.layers import Input, Dense, Flatten, Conv3D, Dropout, BatchNormalization, Concatenate, Add, GlobalAveragePooling3D, LayerNormalization, MultiHeadAttention, Reshape, TimeDistributed
from tensorflow.keras.models import Model

import tensorflow as tf
from tensorflow.keras.layers import Input, ConvLSTM2D, BatchNormalization, Dropout, Flatten, Dense, Add, LayerNormalization, MultiHeadAttention, GlobalAveragePooling1D, Concatenate, Reshape, Lambda
from tensorflow.keras.models import Model
from tensorflow.keras.regularizers import l2
import tensorflow.keras.backend as K
import tensorflow as tf
from tensorflow.keras.callbacks import Callback
from tensorflow.keras.layers import Input, ConvLSTM2D, BatchNormalization, Dropout, Flatten, Reshape, MultiHeadAttention, Dense, Add, LayerNormalization, GlobalAveragePooling1D, Multiply, Concatenate
from tensorflow.keras.models import Model
from tensorflow.keras.optimizers import Adam
from tensorflow.keras.regularizers import l2
from tensorflow.keras.layers import ConvLSTM2D, Conv2D, BatchNormalization, ReLU, Multiply
from spektral.layers.convolutional import GCNConv
from spektral.layers.pooling import GlobalAvgPool
from load_functions_order_final import (
    ImageSequence, mix_patches,
    organizar_secuencias_temporales_generator,
    crear_patches_generator, ClearMemory, construct_labels,
    load_file_stacked,   
    ImageSequenceRandomized,
    ajustar_division_clases_proporcion_stream_full_random,
    first_seq_stream_full_random
)

from tensorflow.keras import backend as keras_backend
import gc

from tensorflow.keras.utils import set_random_seed
import random

seed = 12
set_random_seed(seed)
random.seed(seed)
# tf.config.run_functions_eagerly(True)
# tf.data.experimental.enable_debug_mode()



#%% 
# Mark the start of the entire script
start_time = time.time()

# Step 1: Load land use and ancillary data for 2000, 2005, 2010, 2015 and 2020

rutas_cobertura_tierra = [
    "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2000_1.tif",
    "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2005_1.tif",
    "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2010_1.tif",
    "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2015_1.tif",
    "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2020_1.tif"
]

rutas_auxiliares = [
     "D:/Islas/simulacion/Canarias/pca_output_{year}/pca_component_1.tif",
     "D:/Islas/simulacion/Canarias/pca_output_{year}/pca_component_2.tif",
     "D:/Islas/simulacion/Canarias/pca_output_{year}/pca_component_3.tif",
     "D:/Islas/simulacion/Canarias/pca_output_{year}/pca_component_4.tif"
]
def cargar_raster(ruta):
    "Loads a raster file and returns the data together with its profile."
    with rasterio.open(ruta) as src:
        datos = src.read(1)  # Read the first band (assuming there is only one band)
        perfil = src.profile
    return datos, perfil

def reproyectar_a_referencia(ruta, perfil_referencia):
    "Reproject a raster to the given spatial reference."
    with rasterio.open(ruta) as src:
        transform, width, height = calculate_default_transform(
            src.crs, perfil_referencia['crs'], 
            src.width, src.height, *src.bounds)
        
        perfil = perfil_referencia.copy()
        perfil.update({
            'crs': perfil_referencia['crs'],
            'transform': transform,
            'width': width,
            'height': height
        })

        datos_reproyectados = np.empty((height, width), dtype=src.dtypes[0])

        reproject(
            source=rasterio.band(src, 1),
            destination=datos_reproyectados,
            src_transform=src.transform,
            src_crs=src.crs,
            dst_transform=transform,
            dst_crs=perfil_referencia['crs'],
            resampling=Resampling.nearest
        )

    return datos_reproyectados

def normalizar_datos_auxiliares(auxiliares):
    """Normaliza los datos auxiliares utilizando StandardScaler."""
    scaler = StandardScaler()
    auxiliares_normalizados = []
    
    for aux in auxiliares:
        aux_shape = aux.shape
        aux_flat = aux.reshape(-1, aux_shape[-1])  # Aplana el array excepto la última dimensión (canales)
        aux_normalizado = scaler.fit_transform(aux_flat)  # Aplicar la normalización
        auxiliares_normalizados.append(aux_normalizado.reshape(aux_shape))  # Restaurar la forma original
    
    return auxiliares_normalizados

def ajustar_dimensiones_y_proyeccion(datos_auxiliares, perfil_cobertura):
    """Ajusta las dimensiones y proyección de los datos auxiliares para que coincidan con los de cobertura terrestre."""
    with rasterio.open(datos_auxiliares) as src:
        transform, width, height = calculate_default_transform(
            src.crs, perfil_cobertura['crs'], 
            src.width, src.height, *src.bounds)
        
        perfil = perfil_cobertura.copy()
        perfil.update({
            'crs': perfil_cobertura['crs'],
            'transform': transform,
            'width': width,
            'height': height
        })

        datos_ajustados = np.empty((perfil_cobertura['height'], perfil_cobertura['width']), dtype=src.dtypes[0])

        reproject(
            source=rasterio.band(src, 1),
            destination=datos_ajustados,
            src_transform=src.transform,
            src_crs=src.crs,
            dst_transform=perfil_cobertura['transform'],
            dst_crs=perfil_cobertura['crs'],
            resampling=Resampling.bilinear
        )

    return datos_ajustados

# Listas para almacenar los datos cargados
# Cargar y normalizar los datos auxiliares para cada año
coberturas_tierra = []
auxiliares_normalizados = []
perfiles = []

for i, ruta in enumerate(rutas_cobertura_tierra):
    cobertura, perfil_cobertura = cargar_raster(ruta)
    coberturas_tierra.append(cobertura)
    perfiles.append(perfil_cobertura)
    
    year = [2000, 2005, 2010, 2015, 2020][i]
    rutas_auxiliares_year = [ruta_aux.format(year=year) for ruta_aux in rutas_auxiliares]
    
    auxiliares_year = []
    for ruta_aux in rutas_auxiliares_year:
        datos_auxiliares, perfil_auxiliar = cargar_raster(ruta_aux)
        
        if perfil_auxiliar['crs'] != perfil_cobertura['crs'] or \
           datos_auxiliares.shape != cobertura.shape:
            datos_ajustados = ajustar_dimensiones_y_proyeccion(ruta_aux, perfil_cobertura)
        else:
            datos_ajustados = datos_auxiliares
            
        auxiliares_year.append(datos_ajustados)
    
    # Normalizar los datos auxiliares de este año
    auxiliares_year_normalizados = normalizar_datos_auxiliares(auxiliares_year)
    auxiliares_normalizados.append(np.stack(auxiliares_year_normalizados, axis=-1))

# Verificar que todas las dimensiones coincidan
for i in range(len(coberturas_tierra)):
    if coberturas_tierra[i].shape != auxiliares_normalizados[i].shape[:2]:
        raise ValueError(f"Las dimensiones de las coberturas y auxiliares no coinciden para el año {year}")
            

#%%




def crear_patches(cobertura, auxiliares_normalizados, patch_size=5):
    patches_cobertura = []
    patches_auxiliares = []
    patches_y = []
    
    half_patch = patch_size // 2

    # Configurar las barras de progreso
    total_patches = (cobertura.shape[0] - patch_size + 1) * (cobertura.shape[1] - patch_size + 1)
    progress_bar = tqdm(total=total_patches, desc="Creando parches")

    for i in range(half_patch, cobertura.shape[0] - half_patch):
        for j in range(half_patch, cobertura.shape[1] - half_patch):
            # Crear el parche de la cobertura terrestre
            patch_cobertura = cobertura[i - half_patch: i + half_patch + 1,
                                        j - half_patch: j + half_patch + 1]
            if np.isnan(patch_cobertura).any():
                progress_bar.update(1)
                continue

            # Crear los parches de los auxiliares
            patch_aux = []
            for k in range(auxiliares_normalizados.shape[-1]):
                aux_patch = auxiliares_normalizados[i - half_patch: i + half_patch + 1,
                                       j - half_patch: j + half_patch + 1, k]
                if np.isnan(aux_patch).any():
                    patch_aux = None
                    break
                patch_aux.append(aux_patch)
            
            if patch_aux is not None:
                patches_cobertura.append(patch_cobertura)
                patches_auxiliares.append(np.stack(patch_aux, axis=-1))
                patches_y.append(cobertura[i, j])
            progress_bar.update(1)
    
    progress_bar.close()
    
    return (np.array(patches_cobertura), np.array(patches_auxiliares), np.array(patches_y))

#%%


def organizar_secuencias_temporales(X_patches_list, aux_patches_list, y_patches_list, timesteps=3):
    X_seqs = []
    aux_seqs = []
    y_seqs = []
    
    for i in range(len(X_patches_list) - timesteps):
        for j in range(len(X_patches_list[0])):  # Iterar sobre todos los parches en una imagen
            X_seq = [X_patches_list[i + t][j] for t in range(timesteps)]
            aux_seq = [aux_patches_list[i + t][j] for t in range(timesteps)]
            y_target = y_patches_list[i + timesteps][j]
            
            X_seqs.append(np.array(X_seq))
            aux_seqs.append(np.array(aux_seq))
            y_seqs.append(y_target)
    
    return np.array(X_seqs), np.array(aux_seqs), np.array(y_seqs)



#%%
def ajustar_division_clases_proporcion(X_train, aux_train, y_train, X_test, aux_test, y_test, test_proportion=0.2, min_samples_per_class=5):
    clases_unicas = np.unique(y_train)

    for clase in clases_unicas:
        # Encuentra los índices de la clase actual en el conjunto de entrenamiento
        indices_clase = np.where(y_train == clase)[0]
        indices_no_clase = np.where(y_train != clase)[0]
        num_to_move = max(int(len(indices_clase) * test_proportion), min_samples_per_class)
        
        # Asegurarse de no mover más muestras de las que existen
        num_to_move = min(num_to_move, len(indices_clase))

        if num_to_move > 0:
            # Mover las primeras num_to_move muestras
            X_mover = X_train[indices_clase[:num_to_move]]
            aux_mover = aux_train[indices_clase[:num_to_move]]
            y_mover = y_train[indices_clase[:num_to_move]]

            # Mover al conjunto de prueba
            X_test = np.concatenate([X_test, X_mover], axis=0)
            aux_test = np.concatenate([aux_test, aux_mover], axis=0)
            y_test = np.concatenate([y_test, y_mover], axis=0)

            # Eliminar las muestras movidas del conjunto de entrenamiento
            # X_train = X_train[num_to_move:]
            # aux_train = aux_train[num_to_move:]
            # y_train = y_train[num_to_move:]
            indices_clase_remain = indices_clase[num_to_move:]
            rest_idx = sorted(np.concatenate([indices_clase_remain, indices_no_clase]))
            # X_train = X_train[num_to_move:]
            # aux_train = aux_train[num_to_move:]
            # y_train = y_train[num_to_move:]
            X_train = X_train[rest_idx]
            aux_train = aux_train[rest_idx]
            y_train = y_train[rest_idx]


    # Asegurarse de que todas las clases están representadas en el conjunto de entrenamiento
    clases_faltantes_train = np.setdiff1d(np.unique(y_test), np.unique(y_train))
    for clase in clases_faltantes_train:
        indices_clase = np.where(y_test == clase)[0]
        # Mover la última muestra de regreso al entrenamiento si falta en el entrenamiento
        X_train = np.concatenate([X_train, X_test[indices_clase[-1:]]], axis=0)
        aux_train = np.concatenate([aux_train, aux_test[indices_clase[-1:]]], axis=0)
        y_train = np.concatenate([y_train, y_test[indices_clase[-1:]]], axis=0)

        # Eliminar del conjunto de prueba
        X_test = np.delete(X_test, indices_clase[-1:], axis=0)
        aux_test = np.delete(aux_test, indices_clase[-1:], axis=0)
        y_test = np.delete(y_test, indices_clase[-1:], axis=0)

    return X_train, aux_train, y_train, X_test, aux_test, y_test



# Función de data augmentation específica para secuencias
def augmentar_secuencia(secuencia):
    datagen = ImageDataGenerator(rotation_range=10, width_shift_range=0.1, height_shift_range=0.1)
    secuencia_aumentada = []
    for i in range(secuencia.shape[0]):
        imagen = secuencia[i, :, :, :]  # Extraer cada imagen en la secuencia
        imagen = imagen.reshape((1,) + imagen.shape)  # Ajustar la forma para el generador
        iterador = datagen.flow(imagen, batch_size=1)
        secuencia_aumentada.append(iterador[0].reshape(imagen.shape[1:]))  # Aplicar augmentación
    return np.array(secuencia_aumentada)

# Oversampling para clases minoritarias
def oversample_clase(X, aux, y, clase_objetivo, factor=10):
    indices_clase = np.where(y == clase_objetivo)[0]
    X_clase = X[indices_clase]
    aux_clase = aux[indices_clase]
    y_clase = y[indices_clase]

    X_augmentado = []
    aux_augmentado = []
    y_augmentado = []

    for _ in range(factor):
        for i in range(X_clase.shape[0]):
            X_augmentado.append(augmentar_secuencia(X_clase[i]))
            aux_augmentado.append(augmentar_secuencia(aux_clase[i]))
            y_augmentado.append(y_clase[i])

    # Concatenar las nuevas muestras al final para mantener el orden temporal
    return np.concatenate([X, X_augmentado], axis=0), np.concatenate([aux, aux_augmentado], axis=0), np.concatenate([y, y_augmentado], axis=0)



# Undersampling para la clase mayoritaria
def undersample_clase_mayoritaria(X, aux, y, clase_mayoritaria, target_size=1000000):
    indices_clase_mayoritaria = np.where(y == clase_mayoritaria)[0]
    indices_reducidos = indices_clase_mayoritaria[:target_size]  # Mantener las últimas muestras

    indices_a_mantener = np.where(y != clase_mayoritaria)[0]
    indices_a_mantener = np.concatenate([indices_a_mantener, indices_reducidos])

    return X[indices_a_mantener], aux[indices_a_mantener], y[indices_a_mantener]


# Aplicar oversampling y undersampling en el conjunto de entrenamiento
def balancear_clases(X_train, aux_train, y_train, factor_oversample=10, target_size_undersample=1000000):
    clases_unicas, conteos_clases = np.unique(y_train, return_counts=True)
    
    # Determinar la clase mayoritaria (la que tiene más muestras)
    clase_mayoritaria = clases_unicas[np.argmax(conteos_clases)]

    # Aplicar oversampling a todas las clases excepto la mayoritaria
    for clase in clases_unicas:
        if clase != clase_mayoritaria:
            X_train, aux_train, y_train = oversample_clase(X_train, aux_train, y_train, clase_objetivo=clase, factor=factor_oversample)

    # Aplicar undersampling a la clase mayoritaria
    X_train, aux_train, y_train = undersample_clase_mayoritaria(X_train, aux_train, y_train, clase_mayoritaria=clase_mayoritaria, target_size=target_size_undersample)

    return X_train, aux_train, y_train





#%%

# Callback personalizado para calcular AUC PR
class AUC_PR_Callback(Callback):
    def __init__(self, training_data, validation_data, test_data, num_classes):
        super(AUC_PR_Callback, self).__init__()
        self.training_data = training_data
        self.validation_data = validation_data
        self.test_data = test_data
        self.num_classes = num_classes

    def on_epoch_end(self, epoch, logs=None):
        # Evaluación en datos de entrenamiento
        X_train, y_train = self.training_data
        y_train_pred_probs = self.model.predict(X_train)
        y_train_bin = tf.keras.utils.to_categorical(y_train, num_classes=self.num_classes)

        train_auc_pr_scores = []
        for i in range(self.num_classes):
            auc_pr_train = average_precision_score(y_train_bin[:, i], y_train_pred_probs[:, i])
            train_auc_pr_scores.append(auc_pr_train)
        
        avg_train_auc_pr = np.mean(train_auc_pr_scores)
        logs['train_auc_pr'] = avg_train_auc_pr
        
        # Evaluación en datos de validación
        X_val, y_val = self.validation_data
        y_val_pred_probs = self.model.predict(X_val)
        y_val_bin = tf.keras.utils.to_categorical(y_val, num_classes=self.num_classes)
        
        val_auc_pr_scores = []
        for i in range(self.num_classes):
            auc_pr = average_precision_score(y_val_bin[:, i], y_val_pred_probs[:, i])
            val_auc_pr_scores.append(auc_pr)
        
        avg_val_auc_pr = np.mean(val_auc_pr_scores)
        logs['val_auc_pr'] = avg_val_auc_pr

        # Evaluación en datos de prueba
        X_test, y_test = self.test_data
        y_test_pred_probs = self.model.predict(X_test)
        y_test_bin = tf.keras.utils.to_categorical(y_test, num_classes=self.num_classes)
        
        test_auc_pr_scores = []
        for i in range(self.num_classes):
            auc_pr_test = average_precision_score(y_test_bin[:, i], y_test_pred_probs[:, i])
            test_auc_pr_scores.append(auc_pr_test)
        
        avg_test_auc_pr = np.mean(test_auc_pr_scores)
        self.test_auc_pr = avg_test_auc_pr
        logs['test_auc_pr'] = avg_test_auc_pr


        
        

class MemoryUsageCallback(tf.keras.callbacks.Callback):
    def on_epoch_end(self, epoch, logs=None):
        # Obtener uso de RAM
        ram_usage = psutil.virtual_memory().used / (1024 ** 3)  # Convertir a GB
        
        # Obtener uso de VRAM (GPU)
        gpus = GPUtil.getGPUs()
        if gpus:
            vram_usage = gpus[0].memoryUsed / 1024  # Convertir a GB
        else:
            vram_usage = 0
        
        print(f"Epoch {epoch+1}: RAM Usage: {ram_usage:.2f} GB, VRAM Usage: {vram_usage:.2f} GB")
        
   
        
patches_list = []
for i in range(len(coberturas_tierra)):
    patch = crear_patches_generator(coberturas_tierra[i], auxiliares_normalizados[i], patch_size=5)
    patches_list.append(patch)

seq_files, class_counts, total_written = organizar_secuencias_temporales_generator(patches_list, timesteps=3)
num_classes = len(class_counts)
train_files, test_files, counter_train, counter_test = ajustar_division_clases_proporcion_stream_full_random(
    seq_files, total_written,
   num_shards = 100,
   factor_oversample = 10,
)
train_files_first_seq, counter_first_seq = first_seq_stream_full_random(seq_files, total_written // 2, num_shards = 50)
        
        
        
        
        
#%% 
# Input shapes
input_X = Input(shape=(3, 5, 5, 1))  # Entrada para X_train
input_aux = Input(shape=(3, 5, 5, 4))  # Entrada para aux_train

# Parte ConvLSTM para X_train
x = ConvLSTM2D(filters=32, kernel_size=(3, 3), activation='relu', padding='same', return_sequences=True)(input_X)
x = BatchNormalization()(x)
x = Dropout(0.2)(x)
x = ConvLSTM2D(filters=64, kernel_size=(3, 3), activation='relu', padding='same', return_sequences=False)(x)
x = BatchNormalization()(x)
x = Dropout(0.2)(x)
x = Flatten()(x)

# Parte ConvLSTM para aux_train
aux_temporal = ConvLSTM2D(filters=32, kernel_size=(3, 3), activation='relu', padding='same', return_sequences=True)(input_aux)
aux_temporal = BatchNormalization()(aux_temporal)
aux_temporal = Dropout(0.2)(aux_temporal)
aux_temporal = ConvLSTM2D(filters=64, kernel_size=(3, 3), activation='relu', padding='same', return_sequences=True)(aux_temporal)
aux_temporal = BatchNormalization()(aux_temporal)
aux_temporal = Dropout(0.2)(aux_temporal)
aux_temporal = Reshape((3, 5 * 5 * 64))(aux_temporal)  # Aplana las dimensiones espaciales

# Bloque Transformer para aux_train
attn_output = MultiHeadAttention(num_heads=4, key_dim=64)(aux_temporal, aux_temporal)
attn_output = Dense(aux_temporal.shape[-1])(attn_output)
attn_output = Add()([aux_temporal, attn_output])
attn_output = LayerNormalization()(attn_output)
attn_output = GlobalAveragePooling1D()(attn_output)

# Alinear dimensiones de aux_temporal y attn_output para la combinación
aux_temporal_flat = Flatten()(aux_temporal)
attn_output_flat = Dense(aux_temporal_flat.shape[-1])(attn_output)

# Gate para controlar la influencia del Transformer
gate = Dense(1, activation='sigmoid')(attn_output_flat)  # Valor entre 0 y 1 para ponderar la influencia

# Combinación ponderada de las salidas
combined_transformer = Add()([aux_temporal_flat * (1 - gate), attn_output_flat * gate])

# Agregar una capa LSTM para capturar dependencias entre secuencias de aux_train (RETENCION MEMORIA)
combined_aux = Reshape((1, -1))(combined_transformer)  # Asegúrate de que la entrada a LSTM tenga la forma adecuada
combined_aux = LSTM(128, return_sequences=False)(combined_aux)  # LSTM a nivel inter-secuencia

# Agregar una capa LSTM para capturar dependencias entre secuencias de input_X (RETENCION MEMORIA)
x_reshaped = Reshape((1, -1))(x)  # Asegúrate de que la entrada a LSTM tenga la forma adecuada
x_lstm = LSTM(128, return_sequences=False)(x_reshaped)  # LSTM a nivel inter-secuencia

# Concatenar las salidas de las LSTM de input_X y aux_train
combined = Concatenate()([x_lstm, combined_aux])

# Parte densa para características no espaciotemporales
aux_non_temporal = Dense(64, activation='relu')(Flatten()(input_aux))
aux_non_temporal = BatchNormalization()(aux_non_temporal)
aux_non_temporal = Dropout(0.5)(aux_non_temporal)
aux_non_temporal = Dense(32, activation='relu')(aux_non_temporal)
aux_non_temporal = BatchNormalization()(aux_non_temporal)
aux_non_temporal = Dropout(0.5)(aux_non_temporal)

# Combinar todas las salidas
combined = Concatenate()([combined, aux_non_temporal])

# Capas densas para la clasificación con regularización L2
combined = Dense(128, activation='relu', kernel_regularizer=l2(0.001))(combined)
combined = BatchNormalization()(combined)
combined = Dropout(0.5)(combined)
output = Dense(num_classes, activation='softmax', kernel_regularizer=l2(0.001))(combined)  

# Definición y compilación del modelo
model = Model(inputs=[input_X, input_aux], outputs=output)
optimizer = Adam(learning_rate=1e-4)  # Tasa de aprendizaje ajustada
model.compile(optimizer=optimizer, loss='sparse_categorical_crossentropy', 
              metrics=['accuracy'])

# Resumen del modelo
model.summary()


# Definir la llamada de EarlyStopping
early_stopping = EarlyStopping(monitor='val_loss', patience=5, restore_best_weights=True)

# Definir una función que ajuste la tasa de aprendizaje
def scheduler(epoch, lr):
    if epoch != 0 and epoch % 10 == 0:
        return lr * 0.1  # Reduce la tasa de aprendizaje en un factor de 10 cada 10 épocas
    return lr

# Crear el callback para el ajuste de la tasa de aprendizaje
lr_scheduler = LearningRateScheduler(scheduler)
memory_callback = MemoryUsageCallback()




# Calcular class_weight basado en la distribución de clases para la primera secuencia
y_first_seq = [y.numpy() for _, _, y in itertools.chain(*[load_file_stacked(f) for f in train_files_first_seq])]
class_weights_first_seq = compute_class_weight(class_weight='balanced', classes=np.unique(y_first_seq), y=y_first_seq)

class_weights_first_seq_dict = {i : class_weights_first_seq[i] for i in range(len(class_weights_first_seq))}

# Definición y compilación del modelo sin la métrica AUC PR
model_first = Model(inputs=[input_X, input_aux], outputs=output)
optimizer = Adam(learning_rate=1e-4)
model_first.compile(optimizer=optimizer, loss='sparse_categorical_crossentropy', metrics=['accuracy'], run_eagerly=False)


data_first_seq = ImageSequenceRandomized(
    train_files_first_seq, 32, sum(counter_first_seq.values()),
    block_length = 1, cycle_length = None,
)
data_test = ImageSequence(test_files, 32, sum(counter_test.values()))


x_samp, aux_samp, y_samp = next(iter(load_file_stacked(train_files_first_seq[0])))


#Entrenamiento del modelo con la primera secuencia temporal
print("Entrenando el modelo con la primera secuencia...")
history_first = model_first.fit(
    data_first_seq,
    validation_data=data_test,
    epochs=25, batch_size=1024, 
    class_weight=class_weights_first_seq_dict,  # Usar class_weight
    callbacks=[early_stopping, lr_scheduler, memory_callback, 
                ClearMemory()
                ]
)

# Guardar los pesos del modelo entrenado con la primera secuencia
model_save_path = 'model_weights_first_sequence_Canarias.h5'
model_first.save_weights(model_save_path)
print(f'Modelo guardado en: {model_save_path}')




# **Segunda Iteración: Entrenamiento con Todas las Secuencias**

# Cargar los pesos del modelo entrenado en la primera iteración
model.load_weights('model_weights_first_sequence_Canarias.h5')
print("Pesos del modelo cargados para reentrenar con todas las secuencias...")

# Calcular los pesos de las clases para todas las secuencias
class_weights_all_seqs = compute_class_weight('balanced', classes=np.unique(list(counter_train)), y=construct_labels(counter_train))
class_weights_all_seqs_dict = {i : class_weights_all_seqs[i] for i in range(len(class_weights_all_seqs))}


out_file = "train_out_merge_files/train.tfrecords"

data_test = ImageSequence(test_files, 32, sum(counter_test.values()))
data_train = ImageSequenceRandomized(
    train_files, 128, sum(counter_train.values()), 
    block_length = 1, cycle_length = None,
)





# Reentrenar el modelo con todas las secuencias temporales (2000, 2005, 2010, 2015, 2020)
print("Reentrenando el modelo con todas las secuencias...")
history_final = model.fit(
    data_train, 
    validation_data=data_test,
    epochs=25, batch_size=1024, 
    class_weight=class_weights_all_seqs_dict,
    callbacks=[early_stopping, lr_scheduler, memory_callback, 
                ClearMemory()
                ]
)


# Evaluar el modelo en el conjunto de prueba (opcional, ya que se calcula en el callback)
test_loss, test_accuracy = model.evaluate(data_test)
print(f"Test loss: {test_loss:.4f}")
print(f"Test accuracy: {test_accuracy:.4f}")


# Captura el resumen del modelo
stream = StringIO()
model.summary(print_fn=lambda x: stream.write(x + '\n'))
summary_str = stream.getvalue()

# Crear un documento de Word
doc = docx.Document()
doc.add_heading('Model Summary', 0)
doc.add_paragraph(summary_str)
doc.save('simulacion/reprojected/Model_Summary_Canarias.docx')

# Guardar el modelo final entrenado con todas las secuencias
model_save_path_final = 'model_weights_all_sequences_Canarias.h5'
model.save_weights(model_save_path_final)
print(f'Modelo final guardado en: {model_save_path_final}')



# Cargar el modelo entrenado (si no lo tienes cargado ya)
# model = tf.keras.models.load_model('modelo_cnn_lstm_entrenado.h5')

#%%


# Cargar el modelo entrenado (si no lo tienes cargado ya)
# model = tf.keras.models.load_model('modelo_cnn_lstm_entrenado.h5')

#%%


# Definir el tamaño del parche
patch_size = 5

# Cargar los pesos del modelo entrenado
model_first.load_weights('model_weights_first_sequence_Canarias.h5')
print("Pesos del modelo cargados para predicción...")

# Crear parches de los datos para 2000, 2005 y 2010
X_patches_list = []
aux_patches_list = []

# Incluir los años 2000, 2005 y 2010 para la predicción
for i in range(3):
    X_patches, aux_patches, _ = crear_patches(coberturas_tierra[i], auxiliares_normalizados[i], patch_size=patch_size)
    X_patches_list.append(X_patches)
    aux_patches_list.append(aux_patches)

# Obtener las dimensiones de la imagen original
image_height, image_width = coberturas_tierra[0].shape

# Predicción para 2015
X_seqs_pred_2015 = np.array(X_patches_list)
aux_seqs_pred_2015 = np.array(aux_patches_list)

X_seqs_pred_2015 = np.expand_dims(X_seqs_pred_2015, axis=-1)
X_seqs_pred_2015 = np.transpose(X_seqs_pred_2015, (1, 0, 2, 3, 4))

aux_seqs_pred_2015 = np.transpose(aux_seqs_pred_2015, (1, 0, 2, 3, 4))

predicciones_2015 = model_first.predict([X_seqs_pred_2015, aux_seqs_pred_2015])
predicciones_clases_2015 = np.argmax(predicciones_2015, axis=-1).reshape(-1)

# Reconstruir la imagen de 2015
predicted_image_2015 = np.zeros((image_height, image_width))
half_patch = patch_size // 2
patch_index = 0
for i in range(half_patch, image_height - half_patch):
    for j in range(half_patch, image_width - half_patch):
        predicted_image_2015[i, j] = predicciones_clases_2015[patch_index]
        patch_index += 1

# Crear parches del raster predicho de 2015 para predicción de 2020
X_patches_2015_pred, aux_patches_2015_pred, _ = crear_patches(predicted_image_2015, auxiliares_normalizados[-1], patch_size=patch_size)

# Crear la nueva secuencia de entrada para predecir 2020
X_seqs_pred_2020 = np.array([X_patches_list[-3], X_patches_list[-2], X_patches_2015_pred])
X_seqs_pred_2020 = np.expand_dims(X_seqs_pred_2020, axis=-1)
X_seqs_pred_2020 = np.transpose(X_seqs_pred_2020, (1, 0, 2, 3, 4))

aux_seqs_pred_2020 = np.array([aux_patches_list[-3], aux_patches_list[-2], aux_patches_2015_pred])
aux_seqs_pred_2020 = np.transpose(aux_seqs_pred_2020, (1, 0, 2, 3, 4))

predicciones_2020 = model_first.predict([X_seqs_pred_2020, aux_seqs_pred_2020])
predicciones_clases_2020 = np.argmax(predicciones_2020, axis=-1).reshape(-1)

predicted_image_2020 = np.zeros((image_height, image_width))
patch_index = 0
for i in range(half_patch, image_height - half_patch):
    for j in range(half_patch, image_width - half_patch):
        predicted_image_2020[i, j] = predicciones_clases_2020[patch_index]
        patch_index += 1


#%%





# Rutas a los rásters reprojectados y reclasificados
raster_paths = [
        "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2000.tif",
        "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2005.tif",
        "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2010.tif",
        "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2015.tif",
        "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2020.tif"
    ]


# Cargar los rásters de cobertura de tierra y clases únicas
coberturas_tierra = []
clases_unicas = []

for path in raster_paths:
    with rasterio.open(path) as src:
        raster_data = src.read(1)
        coberturas_tierra.append(raster_data)
        clases_unicas.append(np.unique(raster_data))

def remap_predictions(predictions, original_classes, target_classes):
    # Crear un mapa de remapeo basado en las clases originales y las clases objetivo
    remap_dict = {i: target_classes[idx] for idx, i in enumerate(original_classes)}
    
    # Aplicar el remapeo a las predicciones
    remapped_predictions = np.vectorize(remap_dict.get)(predictions)
    
    return remapped_predictions

# Cargar clases de los rásters originales
with rasterio.open(raster_paths[3]) as src:
    raster_data_2015 = src.read(1)
    unique_classes_2015 = np.unique(raster_data_2015)

with rasterio.open(raster_paths[-1]) as src:
    raster_data_2020 = src.read(1)
    unique_classes_2020 = np.unique(raster_data_2020)

# Remapear predicciones (se puede obviar)
predicciones_remapeadas_2015 = remap_predictions(predicted_image_2015, np.arange(len(unique_classes_2015)), unique_classes_2015)
predicciones_remapeadas_2020 = remap_predictions(predicted_image_2020, np.arange(len(unique_classes_2020)), unique_classes_2020)

# Guardar los rásters remapeados
output_path_2015 = "predicciones_remapeadas_2015_Canarias.tif"
output_path_2020 = "predicciones_remapeadas_2020_Canarias.tif"

def guardar_raster_remapeado(output_path, predicciones_remapeadas, raster_template_path):
    with rasterio.open(raster_template_path) as src:
        profile = src.profile
        profile.update(dtype=rasterio.float32, count=1)
        with rasterio.open(output_path, 'w', **profile) as dst:
            dst.write(predicciones_remapeadas.astype(rasterio.float32), 1)

guardar_raster_remapeado(output_path_2015, predicciones_remapeadas_2015, raster_paths[3])
guardar_raster_remapeado(output_path_2020, predicciones_remapeadas_2020, raster_paths[-1])

# Visualizar las imágenes remapeadas
def visualizar_imagen(predicciones_remapeadas, year):
    plt.figure(figsize=(10, 10))
    plt.imshow(predicciones_remapeadas, cmap='terrain')
    plt.colorbar(label='Clases de Cobertura Terrestre')
    plt.title(f'Land Cover Prediction {year} ')
    plt.show()

visualizar_imagen(predicciones_remapeadas_2015, 2015)
visualizar_imagen(predicciones_remapeadas_2020, 2020)

## Función para crear etiquetas descriptivas basadas en las clases únicas
def crear_labels_descriptivos(unique_classes):
    return [f"Clase {int(clase)}" for clase in unique_classes]

# Calcular las métricas de evaluación y la matriz de confusión
def calcular_evaluaciones(y_true, y_pred, labels):
    y_true = np.array(y_true)
    y_pred = np.array(y_pred)
    matriz_confusion = confusion_matrix(y_true, y_pred, labels=labels)
    
    A = np.sum((y_true != y_pred) & (y_true == 1))
    B = np.sum((y_true == y_pred) & (y_true == 1))
    C = np.sum((y_true != y_pred) & (y_pred == 1))
    D = np.sum((y_true == y_pred) & (y_true == 0))
    
    FoM = B / (A + B + C + D)
    PA = B / (B + A)
    UA = B / (B + C)
    kappa = cohen_kappa_score(y_true, y_pred)
    
    # Calcular OA usando la fórmula OA = (B + D) / (A + B + C + D)
    OA = (B + D) / (A + B + C + D)
    
    return FoM, PA, UA, kappa, OA, matriz_confusion

    

# Cargar verdades de terreno (Repetido)
ruta_verdad_terreno_2015 = "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2015.tif"
ruta_verdad_terreno_2020 = "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2020.tif"

with rasterio.open(ruta_verdad_terreno_2015) as src:
    verdad_terreno_2015 = src.read(1)
with rasterio.open(ruta_verdad_terreno_2020) as src:
    verdad_terreno_2020 = src.read(1)

# Crear etiquetas descriptivas para 2015 y 2020
labels_2015 = np.unique(np.concatenate([verdad_terreno_2015, predicciones_remapeadas_2015]))
labels_2020 = np.unique(np.concatenate([verdad_terreno_2020, predicciones_remapeadas_2020]))

labels_descriptivos_2015 = crear_labels_descriptivos(labels_2015)
labels_descriptivos_2020 = crear_labels_descriptivos(labels_2020)

# Calcular métricas para 2015
if predicciones_remapeadas_2015.shape != verdad_terreno_2015.shape:
    raise ValueError("Las dimensiones de la imagen predicha y la verdad de terreno no coinciden.")
FoM_2015, PA_2015, UA_2015, kappa_2015, OA_2015,  matriz_confusion_2015 = calcular_evaluaciones(
    verdad_terreno_2015.flatten(), predicciones_remapeadas_2015.flatten(), labels_2015
)

# Calcular métricas para 2020
if predicciones_remapeadas_2020.shape != verdad_terreno_2020.shape:
    raise ValueError("Las dimensiones de la imagen predicha y la verdad de terreno no coinciden.")
FoM_2020, PA_2020, UA_2020, kappa_2020, OA_2020, matriz_confusion_2020 = calcular_evaluaciones(
    verdad_terreno_2020.flatten(), predicciones_remapeadas_2020.flatten(), labels_2020
)

# Imprimir las métricas de rendimiento y la matriz de confusión (SE PUEDE AHORRAR YA QUE SE REALIZA EN LOS ESCENARIOS)
def imprimir_metricas(FoM, PA, UA, kappa, OA, matriz_confusion, labels, year):
    print(f"--- Métricas de Evaluación para {year} ---")
    print(f"Figura de Mérito (FoM): {FoM:.4f}")
    print(f"Precisión del Productor (PA): {PA:.4f}")
    print(f"Precisión del Usuario (UA): {UA:.4f}")
    print(f"Coeficiente Kappa: {kappa:.4f}")
    print(f"Exactitud General (OA): {OA:.4f}")
    print("\nMatriz de Confusión:")
    
    # Mostrar la matriz de confusión con las etiquetas descriptivas
    df_matriz_confusion = pd.DataFrame(matriz_confusion, index=labels, columns=labels)
    print(df_matriz_confusion)
    print("\n")

imprimir_metricas(FoM_2015, PA_2015, UA_2015, kappa_2015, OA_2015, matriz_confusion_2015, labels_descriptivos_2015, 2015)
imprimir_metricas(FoM_2020, PA_2020, UA_2020, kappa_2020, OA_2020, matriz_confusion_2020, labels_descriptivos_2020, 2020)

# Guardar las métricas y matrices de confusión en Excel
def guardar_metricas_y_confusion_en_excel(FoM, PA, UA, kappa, OA, matriz_confusion, labels, filename):
    df_metricas = pd.DataFrame({
        'Métrica': ['Figura de Mérito (FoM)', 'Precisión del Productor (PA)', 'Precisión del Usuario (UA)', 'Coeficiente Kappa', 'Exactitud General (OA)'],
        'Valor': [FoM, PA, UA, kappa, OA]
    })
    df_matriz_confusion = pd.DataFrame(matriz_confusion, index=labels, columns=labels)
    with pd.ExcelWriter(filename) as writer:
        df_metricas.to_excel(writer, sheet_name='Métricas', index=False)
        df_matriz_confusion.to_excel(writer, sheet_name='Matriz de Confusión')

# Usar la función para guardar las métricas de 2015 y 2020
guardar_metricas_y_confusion_en_excel(FoM_2015, PA_2015, UA_2015, kappa_2015, OA_2015, matriz_confusion_2015, labels_descriptivos_2015, "evaluacion_cobertura_terrestre_2015_Canarias.xlsx")
guardar_metricas_y_confusion_en_excel(FoM_2020, PA_2020, UA_2020, kappa_2020, OA_2020, matriz_confusion_2020, labels_descriptivos_2020, "evaluacion_cobertura_terrestre_2020_Canarias.xlsx")


# Calcular y exportar áreas por clase
def calcular_areas_por_clase(imagen_remapeada, pixel_size=30):
    imagen_remapeada = np.nan_to_num(imagen_remapeada, nan=-1)
    unique_classes, counts = np.unique(imagen_remapeada, return_counts=True)
    mask = unique_classes != -1
    unique_classes = unique_classes[mask]
    counts = counts[mask]
    areas_m2 = counts * (pixel_size ** 2)
    areas_ha = areas_m2 / 10000
    areas_por_clase = dict(zip(unique_classes, areas_ha))
    df_areas_por_clase = pd.DataFrame(list(areas_por_clase.items()), columns=['Clase', 'Área (ha)'])
    return df_areas_por_clase

df_areas_2015 = calcular_areas_por_clase(predicciones_remapeadas_2015)
df_areas_2020 = calcular_areas_por_clase(predicciones_remapeadas_2020)

df_areas_2015.to_excel("coberturas_simuladas_2015Canarias.xlsx", index=False)
df_areas_2020.to_excel("coberturas_simuladas_2020Canarias.xlsx", index=False)

# Imprimir áreas por clase
def imprimir_areas_por_clase(df_areas, year):
    print(f"--- Áreas por Clase para {year} ---")
    print(df_areas)
    print("\n")

imprimir_areas_por_clase(df_areas_2015, 2015)
imprimir_areas_por_clase(df_areas_2020, 2020)

# Exportar áreas por clase a Excel
df_areas_2015.to_excel("coberturas_simuladas_2015Canarias.xlsx", index=False)
df_areas_2020.to_excel("coberturas_simuladas_2020Canarias.xlsx", index=False)

print("Proceso completo. Archivos guardados.")

#%% 

# Función para guardar un ráster
def guardar_raster(ruta_salida, array, profile, dtype=rasterio.float32):
    profile.update(dtype=dtype, count=1, nodata=None)  # No asignar nodata para asegurarse de que clase 0 es válida
    with rasterio.open(ruta_salida, 'w', **profile) as dst:
        dst.write(array, 1)

# Función para calcular y guardar el ráster de cambios
def calcular_y_guardar_cambios(cobertura_tierra_1, cobertura_tierra_2, profile, ruta_salida):
    cambios = np.full(cobertura_tierra_1.shape, np.nan)
    mask = ~np.isnan(cobertura_tierra_1) & ~np.isnan(cobertura_tierra_2)
    cambios[mask] = (cobertura_tierra_2[mask] != cobertura_tierra_1[mask]).astype(np.int32)
    guardar_raster(ruta_salida, cambios, profile, dtype=rasterio.float32)
    return cambios

# Calcular los cambios entre los años hasta 2010
def calcular_cambios_hasta_2010(coberturas_tierra, perfiles):
    cambios_info = []
    areas_cambio_acumulado = np.zeros_like(coberturas_tierra[0], dtype=np.int32)

    for i in range(len(coberturas_tierra) - 2):  # Solo hasta 2010 (excluyendo 2015 y 2020)
        cambio = calcular_y_guardar_cambios(
            coberturas_tierra[i],
            coberturas_tierra[i + 1],
            perfiles[i],
            f"changesAtlanticas_{2000 + i*5}_{2005 + i*5}.tif"
        ).astype(np.int32)
        
        cambios_info.append({
            'Initial Year': 2000 + i*5,
            'Final Year': 2005 + i*5,
            'Cambio': cambio,
            'Initial Cover': coberturas_tierra[i],
            'Final Cover': coberturas_tierra[i + 1]
        })
        
        # Sumar al área de cambios acumulados
        areas_cambio_acumulado += cambio

    return cambios_info, areas_cambio_acumulado

# Calcular los cambios entre 2000 y 2020 para 2040
def calcular_cambios_hasta_2020(coberturas_tierra, perfiles):
    cambios_info = []
    areas_cambio_acumulado = np.zeros_like(coberturas_tierra[0], dtype=np.int32)

    for i in range(len(coberturas_tierra) - 1):  # Incluye todos los años disponibles hasta 2020
        cambio = calcular_y_guardar_cambios(
            coberturas_tierra[i],
            coberturas_tierra[i + 1],
            perfiles[i],
            f"changes_{2000 + i*5}_{2005 + i*5}.tif"
        ).astype(np.int32)
        
        cambios_info.append({
            'Initial Year': 2000 + i*5,
            'Final Year': 2005 + i*5,
            'Cambio': cambio,
            'Initial Cover': coberturas_tierra[i],
            'Final Cover': coberturas_tierra[i + 1]
        })
        
        # Sumar al área de cambios acumulados
        areas_cambio_acumulado += cambio

    return cambios_info, areas_cambio_acumulado

# Calcular cambios acumulados hasta 2010 para los escenarios de 2015 y 2020
cambios_info_2010, areas_cambio_acumulado_2010 = calcular_cambios_hasta_2010(coberturas_tierra, perfiles)

# Guardar el área de cambios acumulado hasta 2010 como un ráster georreferenciado
guardar_raster("areas_cambio_acumuladoCanarias_2000_2010.tif", areas_cambio_acumulado_2010, perfiles[0])

# Visualizar los cambios acumulados 2000-2010
plt.figure(figsize=(10, 10))
plt.imshow(areas_cambio_acumulado_2010, cmap='Blues', interpolation='none')
plt.title('Accumulated Exchange Areas 2000-2010')
plt.colorbar(label='Number of changes')
plt.savefig('areas_cambio_acumulado_2000_2010.png')
plt.show()

# Calcular cambios acumulados hasta 2020 para los escenarios de 2040
cambios_info_2020, areas_cambio_acumulado_2020 = calcular_cambios_hasta_2020(coberturas_tierra, perfiles)

# Guardar el área de cambios acumulado hasta 2020 como un ráster georreferenciado
guardar_raster("areas_cambio_acumuladoMadeira_2000_2020.tif", areas_cambio_acumulado_2020, perfiles[0])

# Visualizar los cambios acumulados 2000-2020
plt.figure(figsize=(10, 10))
plt.imshow(areas_cambio_acumulado_2020, cmap='Reds', interpolation='none')
plt.title('Accumulated Exchange Areas 2000-2020')
plt.colorbar(label='Number of changes')
plt.savefig('areas_cambio_acumulado_2000_2020.png')
plt.show()

# Imprimir el DataFrame de cambios en la consola y guardarlo en un archivo Excel
def exportar_cambios_a_excel(cambios_info, filename):
    data_cambios = []
    for cambio_info in cambios_info:
        year_initial = cambio_info['Initial Year']
        year_final = cambio_info['Final Year']
        cobertura_inicial = cambio_info['Initial Cover']
        cobertura_final = cambio_info['Final Cover']
        
        # Crear un diccionario para almacenar el área total de cada tipo de cambio
        cambios_totales = {}
        
        for y in range(cobertura_inicial.shape[0]):
            for x in range(cobertura_inicial.shape[1]):
                clase_inicial = cobertura_inicial[y, x]
                clase_final = cobertura_final[y, x]
                
                if not np.isnan(clase_inicial) and not np.isnan(clase_final):
                    cambio_clave = (clase_inicial, clase_final)
                    if cambio_clave not in cambios_totales:
                        cambios_totales[cambio_clave] = 0
                    cambios_totales[cambio_clave] += 1
        
        # Convertir los píxeles cambiados a hectáreas (asumiendo un tamaño de píxel de 30x30 metros)
        pixel_area_ha = 1  # 30m x 30m = 900 m^2 = 0.09 hectáreas
        for (clase_inicial, clase_final), count in cambios_totales.items():
            area_total_ha = count * pixel_area_ha
            data_cambios.append([year_initial, year_final, clase_inicial, clase_final, area_total_ha])

    # Crear DataFrame final
    df_cambios = pd.DataFrame(data_cambios, columns=['Initial Year', 'Final Year', 'Initial Class', 'Final Class', 'Total area (ha)'])

    # Imprimir el DataFrame de cambios en la consola
    print(df_cambios)

    # Guardar el DataFrame de cambios en un archivo Excel
    df_cambios.to_excel(filename, index=False)

# Exportar cambios 2000-2010 a Excel
exportar_cambios_a_excel(cambios_info_2010, "cambios_coberturaCanarias_2000_2010.xlsx")

# Exportar cambios 2000-2020 a Excel
exportar_cambios_a_excel(cambios_info_2020, "cambios_coberturaCanarias_2000_2020.xlsx")

print("Proceso completo. Cambios calculados, visualizados y exportados a Excel.")



def calcular_matriz_de_transicion(cobertura_inicial, cobertura_final):
    clases_unicas = np.unique(np.concatenate((cobertura_inicial, cobertura_final)))
    matriz_transicion = np.zeros((len(clases_unicas), len(clases_unicas)), dtype=np.int32)

    for i, clase_inicial in enumerate(clases_unicas):
        for j, clase_final in enumerate(clases_unicas):
            matriz_transicion[i, j] = np.sum((cobertura_inicial == clase_inicial) & (cobertura_final == clase_final))

    return matriz_transicion, clases_unicas

def normalizar_matriz_de_transicion(matriz):
    # Sumar los valores de cada fila
    sumas_filas = matriz.sum(axis=1, keepdims=True)
    # Normalizar dividiendo cada fila por su suma
    matriz_normalizada = matriz / sumas_filas
    # Reemplazar NaN (que pueden aparecer por división entre cero) por 0
    matriz_normalizada = np.nan_to_num(matriz_normalizada)
    return matriz_normalizada


# Suponiendo que ya tienes las coberturas de tierra para dos periodos
cobertura_tierra_1 = coberturas_tierra[0]  # 2000
cobertura_tierra_2 = coberturas_tierra[2]  # 2010

# Calcular la matriz de transición para 2000-2010
matriz_transicion_2000_2010, clases = calcular_matriz_de_transicion(cobertura_tierra_1, cobertura_tierra_2)


cobertura_tierra_4 = coberturas_tierra[4]  # 2020



# Calcular la matriz de transición para 2015-2020
matriz_transicion_2000_2020, _ = calcular_matriz_de_transicion(cobertura_tierra_1, cobertura_tierra_4)

# Normalizar las matrices de transición
matriz_transicion_2000_2010_normalizada = normalizar_matriz_de_transicion(matriz_transicion_2000_2010)
matriz_transicion_2000_2020_normalizada = normalizar_matriz_de_transicion(matriz_transicion_2000_2020)

# Plotear la matriz de transición normalizada usando seaborn y matplotlib
def plot_matriz_de_transicion_normalizada(matriz, clases, titulo):
    plt.figure(figsize=(10, 8))
    sns.heatmap(matriz, annot=True, fmt=".2f", cmap="viridis", xticklabels=clases, yticklabels=clases)
    plt.title(titulo)
    plt.xlabel('Final Class')
    plt.ylabel('Initial Class')
    plt.show()

# Plot de la matriz de transición normalizada para 2000-2010
plot_matriz_de_transicion_normalizada(matriz_transicion_2000_2010_normalizada, clases, 'Normalised Transition Matrix 2000-2010')

# Plot de la matriz de transición normalizada para 2015-2020
plot_matriz_de_transicion_normalizada(matriz_transicion_2000_2020_normalizada, clases, 'Standard Transition Matrix 2000-2020')

#%% 

    
# Predecir la cobertura terrestre para los años futuros (2025, 2030, 2035, 2040)


# Definir el tamaño del parche (patch_size) antes de su uso
patch_size = 5  # Puedes ajustar este valor según tus necesidades

# Cargar los pesos del modelo entrenado
model.load_weights('model_weights_all_sequences_Canarias.h5')
print("Pesos del modelo cargados para predicción...")

# Crear parches de los datos para 2000, 2005, 2010, 2015 y 2020
X_patches_list = []
aux_patches_list = []

for i in range(5):  # Considerar todos los años disponibles (2000, 2005, 2010, 2015, 2020)
    X_patches, aux_patches, _ = crear_patches(coberturas_tierra[i], auxiliares_normalizados[i], patch_size=patch_size)
    X_patches_list.append(X_patches)
    aux_patches_list.append(aux_patches)

# Obtener las dimensiones de la imagen original de uno de los raster
image_height, image_width = coberturas_tierra[0].shape  # Usar la forma del primer raster

# Iterar para predecir cada año futuro hasta 2040
anos_futuros = [2025, 2030, 2035, 2040]
predicciones = []

# Usar las secuencias 2010, 2015, 2020 como base para la predicción
X_patches_list_base = X_patches_list[-3:]  # Secuencia de 2010, 2015, 2020
aux_patches_list_base = aux_patches_list[-3:]

# Iniciar con la predicción de 2020
cobertura_actual = coberturas_tierra[-1]  # Cobertura de 2020

for año in anos_futuros:
    # Crear parches de la última cobertura predicha
    X_patches_pred, aux_patches_pred, _ = crear_patches(cobertura_actual, auxiliares_normalizados[-1], patch_size=patch_size)

    # Actualizar las secuencias de entrada, manteniendo la longitud de 3
    X_patches_list_base = X_patches_list_base[1:] + [X_patches_pred]
    aux_patches_list_base = aux_patches_list_base[1:] + [aux_patches_pred]

    # Crear la nueva secuencia de entrada para el año futuro
    X_seqs_pred = np.array(X_patches_list_base)
    X_seqs_pred = np.expand_dims(X_seqs_pred, axis=-1)  # Añadir dimensión de canales
    X_seqs_pred = np.transpose(X_seqs_pred, (1, 0, 2, 3, 4))  # Reordenar a (n_patches, 3, 5, 5, 1)

    aux_seqs_pred = np.array(aux_patches_list_base)
    aux_seqs_pred = np.transpose(aux_seqs_pred, (1, 0, 2, 3, 4))  # Reordenar a (n_patches, 3, 5, 5, n_channels_aux)

    # Realizar la predicción para el año futuro
    predicciones_futuro = model.predict([X_seqs_pred, aux_seqs_pred])

    # Convertir las predicciones a clases
    predicciones_clases_futuro = np.argmax(predicciones_futuro, axis=-1).reshape(-1)

    # Inicializar la imagen predicha con ceros
    predicted_image_futuro = np.zeros((image_height, image_width))

    # Reconstruir la imagen del año futuro a partir de los parches predichos
    half_patch = patch_size // 2
    patch_index = 0
    for i in range(half_patch, image_height - half_patch):
        for j in range(half_patch, image_width - half_patch):
            predicted_image_futuro[i, j] = predicciones_clases_futuro[patch_index]
            patch_index += 1

    # Guardar la predicción del año futuro
    predicciones.append(predicted_image_futuro)
    cobertura_actual = predicted_image_futuro  # Usar la cobertura predicha como base para la siguiente iteración

# Cargar las clases únicas del ráster de 2020
with rasterio.open(raster_paths[-1]) as src:
    unique_classes_2020 = np.unique(src.read(1))

# Remapear y calcular áreas para cada predicción futura
for i, año in enumerate(anos_futuros):
    predicted_image = predicciones[i]
    remapped_image = remap_predictions(predicted_image, np.arange(len(unique_classes_2020)), unique_classes_2020)
    
    # Guardar la imagen remapeada
    output_path = f"simulacion/reprojected/cobertura_remapeadaCanarias_{año}.tif"
    with rasterio.open(
        output_path,
        'w',
        driver='GTiff',
        height=remapped_image.shape[0],
        width=remapped_image.shape[1],
        count=1,
        dtype=remapped_image.dtype,
        crs=src.crs,
        transform=src.transform
    ) as dst:
        dst.write(remapped_image, 1)
    print(f"Ráster remapeado guardado en {output_path}")

    # Calcular áreas por clase
    df_areas = calcular_areas_por_clase(remapped_image)
    print(f"Áreas por clase para el año {año}:\n", df_areas)

    # Guardar áreas en un archivo Excel
    df_areas.to_excel(f'simulacion/reprojected/areas_predichasCanarias_{año}.xlsx', index=False)
    
    # Visualizar la cobertura predicha remapeada
    plt.figure()
    plt.imshow(remapped_image, cmap='terrain')  
    plt.colorbar(label='Land Cover Classes')
    plt.title(f'Remapped Land Cover Prediction {año}')
    plt.show()
    
#%%     
    
# Cargar el ráster de áreas protegidas
ruta_areas_protegidas = "D:/Islas/Canarias/EspaciosProtegidosCanarias_2.tif"
areas_protegidas, profile_protegidas = cargar_raster(ruta_areas_protegidas)
    
# Después de predecir 2040, generar los escenarios
cobertura_predicha_2040 = predicciones[-1]  # La última predicción generada

# Crear los escenarios para 2040
escenarios = ['BS', 'EPS', 'EDS']
resultados_escenarios = {}

def ajustar_dimensiones(*matrices):
    """
    Ajusta las dimensiones de las matrices a las dimensiones máximas encontradas entre ellas.
    
    Parámetros:
    matrices (numpy arrays): Las matrices que se desean ajustar.
    
    Retorna:
    list: Una lista con las matrices ajustadas.
    """
    # Encontrar las dimensiones máximas entre todas las matrices
    max_shape = tuple(max(sizes) for sizes in zip(*[m.shape for m in matrices]))
    
    # Ajustar cada matriz a las dimensiones máximas
    adjusted_matrices = []
    for m in matrices:
        adjusted_matrix = np.zeros(max_shape, dtype=m.dtype)
        adjusted_matrix[:m.shape[0], :m.shape[1]] = m
        adjusted_matrices.append(adjusted_matrix)
    
    return adjusted_matrices

# Función para simular los escenarios
def simular_escenario(clases_predichas, coberturas_tierra_actual, areas_protegidas, areas_cambio_acumulado, escenario):
    # Ajustar dimensiones de las entradas
    clases_predichas, coberturas_tierra_actual, areas_protegidas, areas_cambio_acumulado = ajustar_dimensiones(
        clases_predichas, coberturas_tierra_actual, areas_protegidas, areas_cambio_acumulado
    )

    if escenario == 'BS':  # Escenario Business as Usual
        return clases_predichas

    elif escenario == 'EPS':  # Escenario de Protección Estricta
        # Mantener coberturas actuales en áreas protegidas
        clases_predichas[areas_protegidas > 0] = coberturas_tierra_actual[areas_protegidas > 0]
        return clases_predichas

    elif escenario == 'EDS':  # Escenario de Desarrollo Económico
        # Probabilidad aleatoria para cambio en áreas no protegidas
        prob_ocurrencia = np.random.rand(*clases_predichas.shape)
        incremento_probabilidad = (prob_ocurrencia <= 0.5) & (areas_cambio_acumulado > 0) & (areas_protegidas == 0)
        
        # Cambiar clases en las áreas seleccionadas aleatoriamente
        valores_unicos_originales = np.unique(coberturas_tierra_actual)
        clases_predichas[incremento_probabilidad] = np.random.choice(valores_unicos_originales, size=np.sum(incremento_probabilidad))
        
        return clases_predichas

# Cargar los rásters de la verdad de terreno de 2015 y 2020
ruta_verdad_terreno_2015 = "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2015.tif"
ruta_verdad_terreno_2020 = "D:/Islas/simulacion/Canarias/reprojected/reclassified_land_cover_2020.tif"

with rasterio.open(ruta_verdad_terreno_2015) as src:
    verdad_terreno_2015 = src.read(1)
with rasterio.open(ruta_verdad_terreno_2020) as src:
    verdad_terreno_2020 = src.read(1)

# Obtener las clases únicas de los rásters
unique_classes_2015 = np.unique(verdad_terreno_2015)
unique_classes_2020 = np.unique(verdad_terreno_2020)

# Crear etiquetas descriptivas para las clases
labels_descriptivos_2015 = [f"Clase {int(clase)}" for clase in unique_classes_2015]
labels_descriptivos_2020 = [f"Clase {int(clase)}" for clase in unique_classes_2020]

def remap_predictions(predictions, original_classes, target_classes):
    """
    Remapea las predicciones de las clases originales a las clases objetivo.

    Parámetros:
    - predictions: numpy array con las predicciones originales.
    - original_classes: lista o numpy array con las clases originales.
    - target_classes: lista o numpy array con las clases objetivo a las que se quieren mapear.

    Retorna:
    - numpy array con las predicciones remapeadas.
    """
    remap_dict = {int(original): target for original, target in zip(original_classes, target_classes)}
    remapped_predictions = np.vectorize(remap_dict.get)(predictions)
    return remapped_predictions

# Generar y guardar escenarios para los años 2015, 2020 y 2040
for year, prediccion in [(2015, predicted_image_2015), (2020, predicted_image_2020), (2040, cobertura_predicha_2040)]:
    # Establecer las clases reales y las áreas de cambio acumulado según el año
    if year == 2015:
        unique_classes_real = unique_classes_2015
        areas_cambio_acumulado = areas_cambio_acumulado_2010
    elif year == 2020:
        unique_classes_real = unique_classes_2020
        areas_cambio_acumulado = areas_cambio_acumulado_2010
    elif year == 2040:
        unique_classes_real = unique_classes_2020
        areas_cambio_acumulado = areas_cambio_acumulado_2020

    # Simular y guardar cada escenario
    for escenario in escenarios:
        # Simular el escenario actual
        clases_predichas_escenario = simular_escenario(
            np.copy(prediccion),
            prediccion,
            areas_protegidas,
            areas_cambio_acumulado,
            escenario
        )
        
        # Remapear las clases predichas a las originales
        cobertura_predicha_mapeada = remap_predictions(clases_predichas_escenario, np.arange(len(unique_classes_real)), unique_classes_real)

        # Guardar el ráster del escenario simulado
        guardar_raster(f"simulacion/reprojected/cobertura_{year}_predichaCanarias_{escenario}.tif", cobertura_predicha_mapeada, profile_protegidas)
        
        # Calcular y guardar las áreas por clase
        areas_simuladas = calcular_areas_por_clase(cobertura_predicha_mapeada)
        areas_simuladas.to_excel(f'simulacion/reprojected/areas_simuladasCanarias_{year}_{escenario}.xlsx', index=False)
        
        # Guardar los resultados del escenario en un diccionario
        resultados_escenarios[f"{escenario}_{year}"] = {
            'clases_predichas_escenario': clases_predichas_escenario,
            'cobertura_predicha_mapeada': cobertura_predicha_mapeada,
            'areas_simuladas': areas_simuladas,
        }
        
        # Imprimir las áreas calculadas
        print(f"Áreas simuladas para el año {year} en hectáreas ({escenario}):")
        print(areas_simuladas)
        
        # Visualizar la cobertura predicha
        plt.figure()
        plt.imshow(cobertura_predicha_mapeada, cmap='terrain')
        plt.title(f'Land cover simulation {year} ({escenario})')
        plt.colorbar()
        plt.show()
        
# Evaluar los escenarios de 2015 y 2020 usando las verdades de terreno correspondientes
def evaluar_escenario_con_verdad_terreno(escenario, year, cobertura_predicha_mapeada, verdad_terreno, unique_classes_real, labels_descriptivos):
    # Asegurarse de que las dimensiones coincidan
    if cobertura_predicha_mapeada.shape != verdad_terreno.shape:
        raise ValueError("Las dimensiones de la imagen predicha y la verdad de terreno no coinciden.")

    # Calcular métricas de evaluación
    FoM, PA, UA, kappa, OA,  matriz_confusion = calcular_evaluaciones(
        verdad_terreno.flatten(),
        cobertura_predicha_mapeada.flatten(),
        unique_classes_real
    )
    
    # Guardar las métricas de evaluación en Excel con etiquetas descriptivas
    guardar_metricas_y_confusion_en_excel(
        FoM, PA, UA, kappa, OA,  matriz_confusion, labels_descriptivos,
        f"evaluacion_{escenario}_{year}_vs_verdad_Canarias.xlsx"
    )
    
    # Crear un DataFrame para las métricas
    df_metricas = pd.DataFrame({
        'Métrica': ['Figura de Mérito (FoM)', 'Precisión del Productor (PA)', 'Precisión del Usuario (UA)', 'Coeficiente Kappa', 'Exactitud General (OA)'],
        'Valor': [FoM, PA, UA, kappa, OA]
    })
    
    # Crear un DataFrame para la matriz de confusión con etiquetas descriptivas
    df_matriz_confusion = pd.DataFrame(matriz_confusion, index=labels_descriptivos, columns=labels_descriptivos)
    
    # Guardar las métricas y la matriz de confusión en un archivo Excel
    with pd.ExcelWriter(f"metricas_{escenario}_{year}_vs_verdad_OA_Canarias.xlsx") as writer:
        df_metricas.to_excel(writer, sheet_name='Métricas', index=False)
        df_matriz_confusion.to_excel(writer, sheet_name='Matriz de Confusión')
    
    # Imprimir las métricas de evaluación
    print(f"Métricas para el escenario {escenario} en el año {year} comparado con la verdad de terreno:")
    imprimir_metricas(FoM, PA, UA, kappa, OA, matriz_confusion, labels_descriptivos, year)

# Evaluar cada escenario para 2015 y 2020
for year, verdad_terreno, unique_classes, labels_descriptivos in [(2015, verdad_terreno_2015, unique_classes_2015, labels_descriptivos_2015),
                                                                  (2020, verdad_terreno_2020, unique_classes_2020, labels_descriptivos_2020)]:
    for escenario in escenarios:
        cobertura_predicha_mapeada = resultados_escenarios[f"{escenario}_{year}"]['cobertura_predicha_mapeada']
        evaluar_escenario_con_verdad_terreno(escenario, year, cobertura_predicha_mapeada, verdad_terreno, unique_classes, labels_descriptivos)

print("Evaluación de los escenarios en comparación con la verdad de terreno completada.")



    # Marcar el final del script completo
end_time = time.time()

# Calcular y mostrar el tiempo total de ejecución en segundos
total_time_seconds = end_time - start_time

# Convertir el tiempo total de ejecución a horas
total_time_horas = total_time_seconds / 3600

# Mostrar el tiempo total de ejecución en minutos
print(f"Tiempo total de ejecución del script: {total_time_horas:.2f} horas")